/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.utilities;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.ote.define.jobs.RemoteResourceRequestJob;
import org.eclipse.osee.ote.ui.define.reports.HttpReportRequest;
import org.eclipse.osee.ote.ui.define.reports.output.OutputFactory;
import org.eclipse.osee.ote.ui.define.reports.output.OutputFormat;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class EditorUtility {
    private EditorUtility() {
    }

    public static void openEditor(String reportId, String format) {
        try {
            OutputFormat outputFormat = OutputFormat.fromString(format);
            String url = HttpReportRequest.getUrl(reportId, outputFormat.name(), "local");
            String tempFileName = OutputFactory.getOutputFilename(outputFormat, reportId);
            switch (outputFormat) {
                case HTML: {
                    EditorUtility.openAsHtml(reportId, url);
                    break;
                }
                default: {
                    EditorUtility.openAsNative(tempFileName, url);
                    break;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void openAsHtml(String fileName, String url) throws Exception {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        IWebBrowser browser = browserSupport.createBrowser(32, fileName, fileName, "");
        browser.openURL(new URL(url));
    }

    private static void openAsNative(String fileName, String url) throws Exception {
        RemoteResourceRequestJob job = new RemoteResourceRequestJob(url, fileName);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                IFile file;
                IStatus status = event.getResult();
                if ((status.equals(Status.OK_STATUS) || status.getCode() == 0) && (file = ((RemoteResourceRequestJob)event.getJob()).getDownloadedFile()) != null && file.exists()) {
                    Program.launch((String)new File(file.getLocationURI()).getAbsolutePath());
                }
            }
        });
        job.schedule();
    }
}

