/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow.util;

import java.util.Collection;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IValidatingOperation;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractDuplicateWorkflowOperation
implements IValidatingOperation {
    protected final Collection<IAtsTeamWorkflow> teamWfs;
    protected final String title;
    protected final AtsApi atsApi;
    protected Map<IAtsTeamWorkflow, IAtsTeamWorkflow> oldToNewMap;
    protected final AtsUser asUser;

    public AbstractDuplicateWorkflowOperation(Collection<IAtsTeamWorkflow> teamWfs, String title, AtsUser asUser, AtsApi atsApi) {
        this.teamWfs = teamWfs;
        this.title = title;
        this.asUser = asUser;
        this.atsApi = atsApi;
    }

    public XResultData validate() {
        XResultData results = new XResultData();
        if (this.teamWfs.isEmpty()) {
            results.error("Team Workflows can not be empty.");
        }
        if (this.asUser == null) {
            results.error("AsUser can not be empty.");
        }
        return results;
    }

    protected String getTitle(IAtsWorkItem workItem) {
        if (workItem.isTask()) {
            return workItem.getName();
        }
        if (this.teamWfs.size() == 1 && Strings.isValid((String)this.title)) {
            return AXml.textToXml((String)this.title);
        }
        if (workItem.isTeamWorkflow()) {
            return AXml.textToXml((String)("Copy of " + workItem.getName()));
        }
        return workItem.getName();
    }

    public Map<IAtsTeamWorkflow, IAtsTeamWorkflow> getResults() {
        return this.oldToNewMap;
    }
}

