/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.agile.IAgileItem;
import org.eclipse.osee.ats.api.agile.IAgileSprint;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.team.ChangeTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.team.ITeamWorkflowProvider;
import org.eclipse.osee.ats.api.team.Priorities;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workdef.WidgetResult;
import org.eclipse.osee.ats.api.workdef.model.StateDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.ActionResult;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemService;
import org.eclipse.osee.ats.api.workflow.ITeamWorkflowProvidersLazy;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsTransitionHook;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsWorkItemHook;
import org.eclipse.osee.ats.api.workflow.journal.JournalData;
import org.eclipse.osee.ats.api.workflow.note.IAtsStateNoteService;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionData;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.core.agile.AgileBacklog;
import org.eclipse.osee.ats.core.agile.AgileItem;
import org.eclipse.osee.ats.core.agile.AgileSprint;
import org.eclipse.osee.ats.core.column.ChangeTypeColumn;
import org.eclipse.osee.ats.core.review.DecisionReviewOnTransitionToHook;
import org.eclipse.osee.ats.core.review.PeerReviewOnTransitionToHook;
import org.eclipse.osee.ats.core.review.hooks.AtsDecisionReviewPrepareWorkItemHook;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.core.util.hooks.AtsNotificationTransitionHook;
import org.eclipse.osee.ats.core.validator.AtsXWidgetValidateManager;
import org.eclipse.osee.ats.core.workflow.Action;
import org.eclipse.osee.ats.core.workflow.Goal;
import org.eclipse.osee.ats.core.workflow.TeamWorkflow;
import org.eclipse.osee.ats.core.workflow.TeamWorkflowProviders;
import org.eclipse.osee.ats.core.workflow.hooks.AtsCommitBranchWhenCompleteHook;
import org.eclipse.osee.ats.core.workflow.hooks.AtsForceAssigneesToTeamLeadsWorkItemHook;
import org.eclipse.osee.ats.core.workflow.hooks.AtsHoldOrBlockedTransitionHook;
import org.eclipse.osee.ats.core.workflow.hooks.AtsPeerReviewRoleDefectValidator;
import org.eclipse.osee.ats.core.workflow.hooks.AtsPeerToPeerReviewReviewWorkItemHook;
import org.eclipse.osee.ats.core.workflow.hooks.AtsWriteDiffWhenCompleteHook;
import org.eclipse.osee.ats.core.workflow.hooks.ConfirmPlarbApprovalHook;
import org.eclipse.osee.ats.core.workflow.note.AtsStateNoteServiceImpl;
import org.eclipse.osee.ats.core.workflow.transition.TransitionHelper;
import org.eclipse.osee.ats.core.workflow.transition.TransitionManager;
import org.eclipse.osee.ats.core.workflow.util.CopyActionDetails;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsWorkItemServiceImpl
implements IAtsWorkItemService {
    private final ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy;
    protected final AtsApi atsApi;
    private IAtsStateNoteService stateNoteService;
    private static final String CANCEL_HYPERLINK_URL_CONFIG_KEY = "CancelHyperlinkUrl";
    public static final String ATS_DEFAULT_JOURNAL_URL = "/ats/ui/action/ID/journal/USERID";
    protected static Set<IAtsWorkItemHook> workflowHooks = new HashSet<IAtsWorkItemHook>();
    private static Set<IAtsTransitionHook> transitionHooks = null;

    public void addTransitionHook(IAtsTransitionHook hook) {
        this.getTransitionHooks();
        transitionHooks.add(hook);
    }

    public void addWorkItemHook(IAtsWorkItemHook hook) {
        this.getWorkItemHooks();
        workflowHooks.add(hook);
    }

    public AtsWorkItemServiceImpl() {
        this(null, null);
    }

    public AtsWorkItemServiceImpl(AtsApi atsApi, ITeamWorkflowProvidersLazy teamWorkflowProvidersLazy) {
        this.atsApi = atsApi;
        this.teamWorkflowProvidersLazy = teamWorkflowProvidersLazy;
    }

    public IStateToken getCurrentState(IAtsWorkItem workItem) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get((IAtsObject)workItem);
        Conditions.checkNotNull((Object)artifact, (String)"workItem", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{workItem.toString()});
        return workItem.getStateDefinition();
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get((IAtsObject)teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        return this.atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, IAtsAbstractReview.class);
    }

    public Collection<IAtsAbstractReview> getReviews(IAtsTeamWorkflow teamWf, IStateToken state) {
        ArtifactId artifact = this.atsApi.getArtifactResolver().get((IAtsObject)teamWf);
        Conditions.checkNotNull((Object)artifact, (String)"teamWf", (String)"Can't Find Artifact matching [%s]", (Object[])new Object[]{teamWf.toString()});
        LinkedList<IAtsAbstractReview> reviews = new LinkedList<IAtsAbstractReview>();
        for (IAtsAbstractReview review : this.atsApi.getRelationResolver().getRelated((IAtsObject)teamWf, AtsRelationTypes.TeamWorkflowToReview_Review, IAtsAbstractReview.class)) {
            if (!((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)review, (AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)"")).equals(state.getName())) continue;
            reviews.add(review);
        }
        return reviews;
    }

    public IAtsTeamWorkflow getFirstTeam(Object object) {
        Collection<IAtsTeamWorkflow> related = this.getTeams(object);
        return related.isEmpty() ? null : related.iterator().next();
    }

    public Collection<IAtsTeamWorkflow> getTeams(Object object) {
        LinkedList<IAtsTeamWorkflow> teams = new LinkedList<IAtsTeamWorkflow>();
        if (object instanceof IAtsAction) {
            for (ArtifactToken teamWfArt : this.atsApi.getRelationResolver().getRelated((IAtsObject)((IAtsAction)object), AtsRelationTypes.ActionToWorkflow_TeamWorkflow)) {
                teams.add(this.atsApi.getWorkItemService().getTeamWf(teamWfArt));
            }
        } else {
            if (object instanceof ActionResult) {
                return Collections.castAll(AtsObjects.getArtifacts(((ActionResult)object).getTeamWfArts()));
            }
            throw new OseeArgumentException("Unhandled object type", new Object[0]);
        }
        return teams;
    }

    public void clearImplementersCache(IAtsWorkItem workItem) {
        this.atsApi.clearImplementersCache(workItem);
    }

    public Collection<WidgetResult> validateWidgetTransition(IAtsWorkItem workItem, StateDefinition toStateDef) {
        return AtsXWidgetValidateManager.validateTransition(workItem, toStateDef, this.atsApi);
    }

    public Collection<IAtsTransitionHook> getTransitionHooks() {
        if (transitionHooks == null) {
            transitionHooks = new HashSet<IAtsTransitionHook>();
            transitionHooks.add(new DecisionReviewOnTransitionToHook());
            transitionHooks.add(new PeerReviewOnTransitionToHook());
            transitionHooks.add(new AtsNotificationTransitionHook());
            transitionHooks.add(new AtsDecisionReviewPrepareWorkItemHook());
            transitionHooks.add(new AtsForceAssigneesToTeamLeadsWorkItemHook());
            transitionHooks.add(new AtsPeerToPeerReviewReviewWorkItemHook());
            transitionHooks.add(new AtsCommitBranchWhenCompleteHook());
            transitionHooks.add(new AtsWriteDiffWhenCompleteHook());
            transitionHooks.add(new AtsHoldOrBlockedTransitionHook());
            transitionHooks.add(new AtsPeerReviewRoleDefectValidator());
        }
        return transitionHooks;
    }

    public String getTargetedVersionStr(IAtsTeamWorkflow teamWf) {
        IAtsVersion targetedVersion = this.atsApi.getVersionService().getTargetedVersionByTeamWf(teamWf);
        if (targetedVersion != null) {
            return targetedVersion.getName();
        }
        return "";
    }

    public String getArtifactTypeShortName(IAtsTeamWorkflow teamWf) {
        for (ITeamWorkflowProvider atsTeamWorkflow : this.teamWorkflowProvidersLazy.getProviders()) {
            String typeName = atsTeamWorkflow.getArtifactTypeShortName(teamWf);
            if (!Strings.isValid((String)typeName)) continue;
            return typeName;
        }
        return null;
    }

    public String getCombinedPcrId(IAtsWorkItem workItem) {
        String id = "";
        for (ITeamWorkflowProvider provider : TeamWorkflowProviders.getTeamWorkflowProviders()) {
            try {
                String computedPcrId;
                if (!provider.isResponsibleFor(workItem) || !Strings.isValid((String)(computedPcrId = provider.getComputedPcrId(workItem)))) continue;
                id = computedPcrId;
            }
            catch (Exception ex) {
                this.atsApi.getLogger().error((Throwable)ex, "Error with provider %s", new Object[]{provider.toString()});
            }
        }
        if (Strings.isInValid((String)id)) {
            String legacyPcrId = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, (Object)"");
            if (Strings.isValid((String)legacyPcrId)) {
                return String.format("%s - %s", workItem.getAtsId(), legacyPcrId);
            }
            id = workItem.getAtsId();
        }
        return id;
    }

    public IAtsStateNoteService getStateNoteService() {
        if (this.stateNoteService == null) {
            this.stateNoteService = new AtsStateNoteServiceImpl(this.atsApi);
        }
        return this.stateNoteService;
    }

    public ITeamWorkflowProvidersLazy getTeamWorkflowProviders() {
        return this.teamWorkflowProvidersLazy;
    }

    public void clearAssignees(IAtsWorkItem workItem, IAtsChangeSet changes) {
        workItem.getStateMgr().clearAssignees();
        changes.add((Object)workItem);
    }

    public void setAssignees(IAtsWorkItem workItem, Set<AtsUser> assignees, IAtsChangeSet changes) {
        workItem.getStateMgr().setAssignees(assignees);
        changes.add((Object)workItem);
    }

    public IAtsWorkItem getWorkItemByAnyId(String actionId) {
        IAtsWorkItem workItem = null;
        ArtifactToken artifact = ArtifactToken.SENTINEL;
        artifact = GUID.isValid((String)actionId) ? this.atsApi.getQueryService().getArtifactByGuidOrSentinel(actionId) : (Strings.isNumeric((String)actionId) ? this.atsApi.getQueryService().getArtifact(Long.valueOf(actionId)) : this.atsApi.getQueryService().getArtifactByAtsId(actionId));
        if (artifact.isValid()) {
            workItem = this.atsApi.getWorkItemService().getWorkItem(artifact);
        }
        return workItem;
    }

    public Collection<IAtsWorkItem> getWorkItems(Collection<? extends ArtifactToken> artifacts) {
        LinkedList<IAtsWorkItem> workItems = new LinkedList<IAtsWorkItem>();
        for (ArtifactToken artifactToken : artifacts) {
            IAtsWorkItem workItem = this.getWorkItem(artifactToken);
            if (workItem == null) continue;
            workItems.add(workItem);
        }
        return workItems;
    }

    public IAtsWorkItem getWorkItem(Long id) {
        ArtifactToken art = this.atsApi.getQueryService().getArtifact(id);
        if (art == null || art.isInvalid() || !art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            return null;
        }
        return this.getWorkItem(art);
    }

    public IAtsWorkItem getWorkItem(ArtifactToken artifact) {
        IAtsTeamWorkflow workItem;
        block8: {
            workItem = null;
            try {
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                    workItem = this.getTeamWf(artifact);
                    break block8;
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.PeerToPeerReview}) || artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.DecisionReview})) {
                    workItem = this.getReview(artifact);
                    break block8;
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) {
                    workItem = this.getTask(artifact);
                    break block8;
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog})) {
                    workItem = this.getAgileBacklog(artifact);
                    break block8;
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                    workItem = this.getGoal(artifact);
                    break block8;
                }
                if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileSprint})) {
                    workItem = this.getAgileSprint(artifact);
                    break block8;
                }
                throw new OseeArgumentException("Artifact %s must be of type IAtsWorkItem", new Object[]{artifact.toStringWithId()});
            }
            catch (OseeCoreException ex) {
                this.atsApi.getLogger().error((Throwable)ex, "Error getting work item for [%s]", new Object[]{artifact});
            }
        }
        return workItem;
    }

    public IAtsTeamWorkflow getTeamWfNoCache(ArtifactToken artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            return new TeamWorkflow(this.atsApi.getLogger(), this.atsApi, artifact);
        }
        return null;
    }

    public IAtsTeamWorkflow getTeamWf(ArtifactToken artifact) {
        IAtsTeamWorkflow teamWf = null;
        if (artifact instanceof IAtsTeamWorkflow) {
            teamWf = (IAtsTeamWorkflow)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            teamWf = new TeamWorkflow(this.atsApi.getLogger(), this.atsApi, artifact);
        } else {
            artifact = this.atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            teamWf = new TeamWorkflow(this.atsApi.getLogger(), this.atsApi, artifact);
        }
        return teamWf;
    }

    public String getCancelUrl(IAtsWorkItem workItem, AtsApi atsApi) {
        String cancelActionUrl = atsApi.getConfigValue(CANCEL_HYPERLINK_URL_CONFIG_KEY);
        if (Strings.isValid((String)cancelActionUrl)) {
            return cancelActionUrl.replaceFirst("ID", workItem.getIdString());
        }
        return null;
    }

    public IAgileSprint getAgileSprint(ArtifactToken artifact) {
        Object sprint = null;
        sprint = artifact instanceof IAgileSprint ? (IAgileSprint)artifact : new AgileSprint(this.atsApi.getLogger(), this.atsApi, artifact);
        return sprint;
    }

    public IAgileBacklog getAgileBacklog(ArtifactToken artifact) {
        Object backlog = null;
        backlog = artifact instanceof IAgileBacklog ? (IAgileBacklog)artifact : new AgileBacklog(this.atsApi.getLogger(), this.atsApi, artifact);
        return backlog;
    }

    public IAgileItem getAgileItem(ArtifactToken artifact) {
        AgileItem item = null;
        try {
            ArtifactToken art = this.atsApi.getQueryService().getArtifact((ArtifactId)artifact);
            if (art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
                item = new AgileItem(this.atsApi.getLogger(), this.atsApi, art);
            }
        }
        catch (Exception ex) {
            this.atsApi.getLogger().error("Exception loading agile item %s: %s", new Object[]{artifact.getId(), Lib.exceptionToString((Exception)ex)});
        }
        return item;
    }

    public IAtsWorkItem getWorkItemByAtsId(String atsId) {
        return (IAtsWorkItem)this.atsApi.getQueryService().createQuery(WorkItemType.WorkItem, new WorkItemType[0]).andAttr((AttributeTypeId)AtsAttributeTypes.AtsId, atsId, new QueryOption[0]).getResults().getOneOrDefault((Object)IAtsWorkItem.SENTINEL);
    }

    public IAtsGoal getGoal(ArtifactToken artifact) {
        IAtsGoal goal = null;
        if (artifact instanceof IAtsGoal) {
            goal = (IAtsGoal)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
            goal = new Goal(this.atsApi.getLogger(), this.atsApi, artifact);
        }
        return goal;
    }

    public IAtsTask getTask(ArtifactToken artifact) {
        return this.atsApi.getTaskService().getTask(artifact);
    }

    public IAtsAbstractReview getReview(ArtifactToken artifact) {
        return this.atsApi.getReviewService().getReview(artifact);
    }

    public IAtsAction getAction(ArtifactToken artifact) {
        IAtsAction action = null;
        if (artifact instanceof IAtsAction) {
            action = (IAtsAction)artifact;
        } else if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            action = new Action(this.atsApi, artifact);
        }
        return action;
    }

    public String getHtmlUrl(IAtsWorkItem workItem, AtsApi atsApi) {
        String actionUrl = atsApi.getConfigValue("ActionUrl_26_0");
        if (Strings.isValid((String)actionUrl)) {
            return actionUrl.replaceFirst("ID", workItem.getIdString());
        }
        return null;
    }

    public boolean isCancelHyperlinkConfigured() {
        return Strings.isValid((String)this.atsApi.getConfigValue(CANCEL_HYPERLINK_URL_CONFIG_KEY));
    }

    public Collection<IAtsTeamWorkflow> getSiblings(IAtsTeamWorkflow teamWf, IAtsTeamDefinition fromTeamDef) {
        ArrayList<IAtsTeamWorkflow> siblings = new ArrayList<IAtsTeamWorkflow>();
        IAtsAction action = teamWf.getParentAction();
        for (IAtsTeamWorkflow child : action.getTeamWorkflows()) {
            if (!child.getTeamDefinition().equals(fromTeamDef)) continue;
            siblings.add(child);
        }
        return siblings;
    }

    public Collection<IAtsTeamWorkflow> getSiblings(IAtsTeamWorkflow teamWf) {
        ArrayList<IAtsTeamWorkflow> siblings = new ArrayList<IAtsTeamWorkflow>();
        IAtsAction action = teamWf.getParentAction();
        for (IAtsTeamWorkflow child : action.getTeamWorkflows()) {
            if (child.equals(teamWf)) continue;
            siblings.add(child);
        }
        return siblings;
    }

    public String getChangeTypeStr(IAtsWorkItem workItem) {
        return ChangeTypeColumn.getChangeTypeStr(workItem, this.atsApi);
    }

    public Collection<IAtsWorkItemHook> getWorkItemHooks() {
        if (workflowHooks.isEmpty()) {
            workflowHooks.add(new ConfirmPlarbApprovalHook());
        }
        return workflowHooks;
    }

    public void removeListener(IAtsTransitionHook hook) {
        if (transitionHooks != null) {
            transitionHooks.remove(hook);
        }
    }

    public StateDefinition getStateByName(IAtsWorkItem workItem, String name) {
        for (StateDefinition stateDef : workItem.getWorkDefinition().getStates()) {
            if (!stateDef.getName().equals(name)) continue;
            return stateDef;
        }
        return null;
    }

    public TransitionResults transition(TransitionData transData) {
        IAtsChangeSet changes = this.atsApi.createChangeSet(transData.getName(), transData.getTransitionUser());
        TransitionHelper helper = new TransitionHelper(transData, changes, this.atsApi);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleAllAndPersist();
        return results;
    }

    public TransitionResults transitionValidate(TransitionData transData) {
        TransitionHelper helper = new TransitionHelper(transData, null, this.atsApi);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleTransitionValidation(new TransitionResults());
        return results;
    }

    public TransitionResults transition(ITransitionHelper helper) {
        helper.setAtsApi(this.atsApi);
        TransitionManager transitionMgr = new TransitionManager(helper);
        TransitionResults results = transitionMgr.handleAllAndPersist();
        return results;
    }

    public List<StateDefinition> getAllToStates(IAtsWorkItem workItem) {
        ArrayList<StateDefinition> allPages = new ArrayList<StateDefinition>();
        StateDefinition currState = workItem.getStateDefinition();
        if (currState == null) {
            return allPages;
        }
        if (currState.getToStates().isEmpty()) {
            StateDefinition cancelledFromState;
            StateDefinition completedFromState;
            if (currState.getStateType().isCompletedState() && (completedFromState = workItem.getWorkDefinition().getStateByName(workItem.getCompletedFromState())) != null && !allPages.contains(completedFromState)) {
                allPages.add(completedFromState);
            }
            if (currState.getStateType().isCancelledState() && (cancelledFromState = workItem.getWorkDefinition().getStateByName(workItem.getCancelledFromState())) != null && !allPages.contains(cancelledFromState)) {
                allPages.add(cancelledFromState);
            }
        } else {
            allPages.add((StateDefinition)currState.getToStates().iterator().next());
        }
        block0: for (String visitedStateName : workItem.getStateMgr().getVisitedStateNames()) {
            for (StateDefinition state : workItem.getWorkDefinition().getStates()) {
                if (!state.getName().equals(visitedStateName)) continue;
                if (allPages.contains(state)) continue block0;
                allPages.add(state);
                continue block0;
            }
        }
        for (StateDefinition toState : currState.getToStates()) {
            if (allPages.contains(toState)) continue;
            allPages.add(toState);
        }
        allPages.remove(currState);
        return allPages;
    }

    public StateDefinition getDefaultToState(IAtsWorkItem workItem) {
        List<StateDefinition> states = this.getAllToStates(workItem);
        if (!states.isEmpty()) {
            return states.iterator().next();
        }
        return null;
    }

    public JournalData getJournalData(String atsId) {
        JournalData journalData = new JournalData();
        IAtsWorkItem workItem = this.atsApi.getWorkItemService().getWorkItemByAtsId(atsId);
        if (workItem == null) {
            journalData.getResults().errorf("Invalid ATS Id [%s]", new Object[]{atsId});
            return journalData;
        }
        this.getJournalData(workItem, journalData);
        return journalData;
    }

    public JournalData getJournalData(IAtsWorkItem workItem, JournalData journalData) {
        String journalStr = this.atsApi.getAttributeResolver().getSoleAttributeValueAsString((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.Journal, "");
        journalData.setCurrentMsg(journalStr);
        this.getJournalSubscribed(workItem, journalData);
        return journalData;
    }

    public JournalData getJournalSubscribed(IAtsWorkItem workItem, JournalData journalData) {
        journalData.getSubscribed().clear();
        Collection userArts = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.JournalSubscriber);
        for (ArtifactId userArt : userArts) {
            AtsUser user = this.atsApi.getConfigService().getUser(userArt);
            if (user == null) continue;
            journalData.getSubscribed().add(user);
        }
        return journalData;
    }

    public static String getJournalUrl(String atsIdOrid, String userId, AtsApi atsApi) {
        String journalUrl = String.valueOf(System.getProperty("osee.application.server")) + ATS_DEFAULT_JOURNAL_URL;
        journalUrl = journalUrl.replaceFirst("ID", atsIdOrid);
        journalUrl = journalUrl.replaceFirst("USERID", userId);
        return journalUrl;
    }

    public boolean isBlocked(IAtsWorkItem workItem) {
        return Strings.isValid((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workItem.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.BlockedReason, (Object)"")));
    }

    public boolean isOnHold(IAtsWorkItem workItem) {
        return Strings.isValid((String)((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)workItem.getStoreObject(), (AttributeTypeToken)AtsAttributeTypes.HoldReason, (Object)"")));
    }

    public String getCopyActionDetails(IAtsWorkItem workItem) {
        CopyActionDetails cad = new CopyActionDetails(workItem, this.atsApi);
        return cad.getDetailsString();
    }

    public List<ChangeTypes> getChangeTypeOptions(IAtsObject atsObject) {
        List cTypes;
        WorkDefinition workDef = null;
        if (atsObject instanceof IAtsActionableItem) {
            IAtsActionableItem ai = (IAtsActionableItem)atsObject;
            IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getImpactedTeamDef(ai);
            ArtifactId workDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, ArtifactId.SENTINEL);
            if (workDefId.isValid()) {
                workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId);
            }
        } else if (atsObject instanceof IAtsTeamDefinition) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)atsObject;
            ArtifactId workDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, ArtifactId.SENTINEL);
            if (workDefId.isValid()) {
                workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId);
            }
        } else if (atsObject instanceof IAtsTeamWorkflow) {
            workDef = ((IAtsTeamWorkflow)atsObject).getWorkDefinition();
        }
        List changeTypes = null;
        if (workDef != null && !(cTypes = workDef.getChangeTypes()).isEmpty()) {
            changeTypes = cTypes;
        }
        if (changeTypes == null) {
            changeTypes = ChangeTypes.DEFAULT_CHANGE_TYPES;
        }
        return changeTypes;
    }

    public Pair<Boolean, Collection<ChangeTypes>> hasSameChangeTypes(Collection<IAtsTeamWorkflow> teamWfs) {
        boolean sameChangeTypes = true;
        List<ChangeTypes> changeTypes = null;
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            List<ChangeTypes> cTypes = this.getChangeTypeOptions((IAtsObject)teamWf);
            if (changeTypes == null) {
                changeTypes = cTypes;
                continue;
            }
            if (Collections.isEqual(changeTypes, cTypes)) continue;
            sameChangeTypes = false;
            break;
        }
        return new Pair((Object)sameChangeTypes, changeTypes);
    }

    public List<Priorities> getPrioritiesOptions(IAtsObject atsObject) {
        List pris;
        WorkDefinition workDef = null;
        if (atsObject instanceof IAtsActionableItem) {
            IAtsActionableItem ai = (IAtsActionableItem)atsObject;
            IAtsTeamDefinition teamDef = this.atsApi.getTeamDefinitionService().getImpactedTeamDef(ai);
            ArtifactId workDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, ArtifactId.SENTINEL);
            if (workDefId.isValid()) {
                workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId);
            }
        } else if (atsObject instanceof IAtsTeamDefinition) {
            IAtsTeamDefinition teamDef = (IAtsTeamDefinition)atsObject;
            ArtifactId workDefId = this.atsApi.getAttributeResolver().getSoleArtifactIdReference((IAtsObject)teamDef, (AttributeTypeToken)AtsAttributeTypes.WorkflowDefinitionReference, ArtifactId.SENTINEL);
            if (workDefId.isValid()) {
                workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)workDefId);
            }
        } else if (atsObject instanceof IAtsTeamWorkflow) {
            workDef = ((IAtsTeamWorkflow)atsObject).getWorkDefinition();
        }
        List priorities = null;
        if (workDef != null && !(pris = workDef.getPriorities()).isEmpty()) {
            priorities = pris;
        }
        if (priorities == null) {
            priorities = Priorities.DEFAULT_PRIORITIES;
        }
        return priorities;
    }

    public Pair<Boolean, Collection<Priorities>> hasSamePriorities(Collection<IAtsTeamWorkflow> teamWfs) {
        boolean samePriorities = true;
        List<Priorities> priorities = null;
        for (IAtsTeamWorkflow teamWf : teamWfs) {
            List<Priorities> pris = this.getPrioritiesOptions((IAtsObject)teamWf);
            if (priorities == null) {
                priorities = pris;
                continue;
            }
            if (Collections.isEqual(priorities, pris)) continue;
            samePriorities = false;
            break;
        }
        return new Pair((Object)samePriorities, priorities);
    }

    public String getCurrentStateName(IAtsWorkItem workItem) {
        return workItem.getStateMgr().getCurrentStateNameInternal();
    }
}

