/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.workflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.review.DecisionReviewState;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.PeerToPeerReviewState;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsImplementerService;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class AtsImplementersService
implements IAtsImplementerService {
    public String getImplementersStr(IAtsObject atsObject) {
        List<AtsUser> implementers = this.getImplementers(atsObject);
        return implementers.isEmpty() ? "" : AtsObjects.toString("; ", implementers);
    }

    public List<AtsUser> getImplementers(IAtsObject atsObject) {
        LinkedList<AtsUser> implementers = new LinkedList<AtsUser>();
        if (atsObject instanceof IAtsAction) {
            implementers.addAll(this.getActionGroupImplementers((IAtsAction)atsObject));
        } else if (atsObject instanceof IAtsWorkItem) {
            implementers.addAll(this.getWorkItemImplementers((IAtsWorkItem)atsObject));
        }
        implementers.remove(AtsCoreUsers.UNASSIGNED_USER);
        Collections.sort(implementers);
        return implementers;
    }

    public List<AtsUser> getWorkItemImplementers(IAtsWorkItem workItem) {
        ArrayList<AtsUser> implementers = new ArrayList<AtsUser>();
        if (workItem.isReview()) {
            this.getImplementers_fromReviews(workItem, implementers);
        }
        this.getImplementers_fromCompletedCancelledBy(workItem, implementers);
        this.getImplementers_fromCompletedCancelledFrom(workItem, implementers);
        return implementers;
    }

    public void getImplementers_fromCompletedCancelledFrom(IAtsWorkItem workItem, List<AtsUser> implementers) {
        String fromStateName = null;
        if (workItem.getCurrentStateType().isCompleted()) {
            fromStateName = workItem.getCompletedFromState();
        } else if (workItem.getCurrentStateType().isCancelled()) {
            fromStateName = workItem.getCancelledFromState();
        }
        if (Strings.isValid((String)fromStateName)) {
            for (AtsUser user : workItem.getStateMgr().getAssigneesForState(fromStateName)) {
                if (implementers.contains(user)) continue;
                implementers.add(user);
            }
        }
    }

    public void getImplementers_fromCompletedCancelledBy(IAtsWorkItem workItem, List<AtsUser> implementers) {
        if (workItem.getCurrentStateType().isCompletedOrCancelled()) {
            AtsUser cancelledBy;
            AtsUser completedBy;
            if (workItem.getCurrentStateType().isCompleted() && (completedBy = workItem.getCompletedBy()) != null && !implementers.contains(completedBy)) {
                implementers.add(completedBy);
            }
            if (workItem.getCurrentStateType().isCancelled() && (cancelledBy = workItem.getCancelledBy()) != null && !implementers.contains(cancelledBy)) {
                implementers.add(cancelledBy);
            }
        }
    }

    public void getImplementers_fromReviews(IAtsWorkItem workItem, List<AtsUser> implementers) {
        if (workItem.isDecisionReview()) {
            implementers.addAll(this.getImplementersByState(workItem, (IStateToken)DecisionReviewState.Decision));
        } else {
            implementers.addAll(this.getImplementersByState(workItem, (IStateToken)PeerToPeerReviewState.Review));
            IAtsPeerReviewRoleManager roleMgr = ((IAtsPeerToPeerReview)workItem).getRoleManager();
            List userRoles = roleMgr.getUserRoles();
            for (AtsUser user : roleMgr.getRoleUsers((Collection)userRoles)) {
                implementers.add(user);
            }
        }
    }

    public List<AtsUser> getActionGroupImplementers(IAtsAction actionGroup) {
        LinkedList<AtsUser> implementers = new LinkedList<AtsUser>();
        for (IAtsWorkItem action : actionGroup.getTeamWorkflows()) {
            if (!action.getCurrentStateType().isCompletedOrCancelled()) continue;
            for (AtsUser user : this.getWorkItemImplementers(action)) {
                if (implementers.contains(user)) continue;
                implementers.add(user);
            }
        }
        return implementers;
    }

    public List<AtsUser> getImplementersByState(IAtsWorkItem workflow, IStateToken state) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        if (workflow.isCancelled()) {
            users.add(workflow.getCancelledBy());
        } else {
            AtsUser user2;
            for (AtsUser user2 : workflow.getStateMgr().getAssignees(state.getName())) {
                if (users.contains(user2)) continue;
                users.add(user2);
            }
            if (workflow.isCompleted() && (user2 = workflow.getCompletedBy()) != null && !users.contains(user2)) {
                users.add(user2);
            }
        }
        return users;
    }
}

