/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.util.chart;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.ILineChart;
import org.eclipse.osee.framework.core.util.OseeInf;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.DateUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class LineChart
implements ILineChart {
    private final Map<String, List<Double>> datasets = new HashMap<String, List<Double>>();
    private final Map<String, String> rgbs = new HashMap<String, String>();
    private String title;
    private String xAxisLabel;
    private String yAxisLabel;
    private List<String> xAxisLabels = new LinkedList<String>();
    private String urlToGet;
    private final AtsApi atsApi;
    private final XResultData results = new XResultData();

    public LineChart(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    @JsonIgnore
    public String getChart() {
        if (!Strings.isValid((String)this.title)) {
            this.results.error("Title must be specified");
        }
        if (!Strings.isValid((String)this.xAxisLabel)) {
            this.results.error("XAxisLabel must be specified");
        }
        if (!Strings.isValid((String)this.yAxisLabel)) {
            this.results.error("YAxisLabel must be specified");
        }
        if (this.datasets.isEmpty()) {
            this.results.error("DataSets can not be empty.");
        }
        try {
            String htmlChart = OseeInf.getResourceContents((String)"web/agilebl/LineChart.html", this.getClass());
            htmlChart = htmlChart.replaceFirst("PUT_TITLE_HERE", this.title);
            htmlChart = htmlChart.replaceFirst("PUT_REPORT_DATE_HERE", DateUtil.getMMDDYYHHMM());
            htmlChart = htmlChart.replaceFirst("PUT_LABELS_HERE", Collections.toString((String)",", this.xAxisLabels));
            LinkedList<String> dataSetStrs = new LinkedList<String>();
            for (Map.Entry<String, List<Double>> entry : this.datasets.entrySet()) {
                String dataSetStr = OseeInf.getResourceContents((String)"web/agilebl/LineDataset.json", this.getClass());
                dataSetStr = dataSetStr.replaceFirst("PUT_LABEL_HERE", entry.getKey());
                LinkedList<String> valueStrs = new LinkedList<String>();
                for (Double value : entry.getValue()) {
                    valueStrs.add("\"" + String.valueOf(value.intValue()) + "\"");
                }
                dataSetStr = dataSetStr.replaceFirst("PUT_DATA_HERE", Collections.toString((String)",", valueStrs));
                dataSetStr = dataSetStr.replaceAll("PUT_RGB_HERE", this.rgbs.get(entry.getKey()));
                dataSetStrs.add(dataSetStr);
            }
            String dataSetStr = Collections.toString((String)",", dataSetStrs);
            htmlChart = htmlChart.replaceFirst("PUT_DATASETS_HERE", dataSetStr);
            htmlChart = htmlChart.replaceFirst("PUT_XAXIS_LABEL_HERE", this.getxAxisLabel());
            htmlChart = htmlChart.replaceFirst("PUT_YAXIS_LABEL_HERE", this.getyAxisLabel());
            htmlChart = htmlChart.replaceFirst("PUT_TITLE_HERE", this.getTitle());
            htmlChart = AtsUtil.resolveAjaxToBaseApplicationServer((String)htmlChart, (AtsApi)this.atsApi);
            return htmlChart;
        }
        catch (Exception ex) {
            this.results.errorf("Exception generating LineChart [%s]", new Object[]{Lib.exceptionToString((Exception)ex)});
            return null;
        }
    }

    public void addLine(String label, List<Double> values, int red, int green, int blue) {
        this.datasets.put(label, values);
        this.rgbs.put(label, String.format("%s, %s, %s", red, green, blue));
    }

    public void addLine(String label, List<Double> values, String rgb) {
        this.datasets.put(label, values);
        this.rgbs.put(label, rgb);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getxAxisLabel() {
        return this.xAxisLabel;
    }

    public void setxAxisLabel(String xAxisLabel) {
        this.xAxisLabel = xAxisLabel;
    }

    public String getyAxisLabel() {
        return this.yAxisLabel;
    }

    public void setyAxisLabel(String yAxisLabel) {
        this.yAxisLabel = yAxisLabel;
    }

    public Map<String, List<Double>> getDatasets() {
        return this.datasets;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getxAxisLabels() {
        return this.xAxisLabels;
    }

    public void setxAxisLabels(List<String> xAxisLabels) {
        this.xAxisLabels = xAxisLabels;
    }

    public String getUrlToGet() {
        return this.urlToGet;
    }

    public void setUrlToGet(String urlToGet) {
        this.urlToGet = urlToGet;
    }

    public XResultData getResults() {
        return this.results;
    }
}

