/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.task.create.CreateTasksDefinition;
import org.eclipse.osee.ats.api.task.create.StaticTaskDefinition;
import org.eclipse.osee.ats.api.workdef.model.WorkDefinition;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.Named;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class CreateTasksRuleRunner {
    private final IAtsTeamWorkflow teamWf;
    private final AtsApi atsApi;
    private XResultData results;
    private final List<CreateTasksDefinition> createTasksDefs;

    public CreateTasksRuleRunner(IAtsTeamWorkflow teamWf, CreateTasksDefinition createTasksDef, AtsApi atsApi) {
        this(teamWf, Arrays.asList(createTasksDef), atsApi);
    }

    public CreateTasksRuleRunner(IAtsTeamWorkflow teamWf, List<CreateTasksDefinition> createTasksDefs, AtsApi atsApi) {
        this.teamWf = teamWf;
        this.createTasksDefs = createTasksDefs;
        this.atsApi = atsApi;
    }

    public XResultData run() {
        this.results = new XResultData();
        for (CreateTasksDefinition tasksDef : this.createTasksDefs) {
            if (tasksDef.getStaticTaskDefs().isEmpty()) {
                this.results.error("StaticTaskDefs can not be empty");
                return this.results;
            }
            if (Strings.isInValid((String)tasksDef.getComment())) {
                this.results.error("Comment can not be null or empty");
                return this.results;
            }
            List<String> existingTaskNames = this.getExistingTaskNames();
            List<StaticTaskDefinition> missingTasks = this.getMissingTasks(tasksDef, existingTaskNames);
            this.createMissingTasks(this.teamWf, tasksDef, missingTasks, this.results);
        }
        return this.results;
    }

    private void createMissingTasks(IAtsTeamWorkflow teamWf, CreateTasksDefinition tasksDef, List<StaticTaskDefinition> missingTasks, XResultData results) {
        NewTaskSet newTaskSet = NewTaskSet.create((String)"CreateTasksRuleRunner", (String)this.atsApi.getUserService().getCurrentUserId());
        NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)teamWf);
        Date createdDate = new Date();
        for (StaticTaskDefinition createTaskDef : missingTasks) {
            WorkDefinition workDef;
            JaxAtsTask jTask = new JaxAtsTask();
            newTaskData.getTasks().add(jTask);
            jTask.setName(createTaskDef.getName());
            jTask.setCreatedByUserId(this.atsApi.getUserService().getCurrentUserId());
            jTask.setDescription(createTaskDef.getDescription());
            jTask.setRelatedToState(createTaskDef.getRelatedToState());
            jTask.setCreatedDate(createdDate);
            for (Long accountId : createTaskDef.getAssigneeAccountIds()) {
                jTask.getAssigneeAccountIds().add(ArtifactId.valueOf((Long)accountId));
            }
            if (!createTaskDef.getWorkDefTok().isValid() || (workDef = this.atsApi.getWorkDefinitionService().getWorkDefinition((Id)createTaskDef.getWorkDefTok())) == null) continue;
            jTask.setWorkDef(workDef.getIdString());
        }
        for (NewTaskData ntd : this.atsApi.getTaskService().createTasks(newTaskSet).getNewTaskDatas()) {
            for (JaxAtsTask task : ntd.getTasks()) {
                results.getIds().add(task.getIdString());
            }
        }
    }

    private List<StaticTaskDefinition> getMissingTasks(CreateTasksDefinition tasksDef, List<String> existingTaskNames) {
        ArrayList<StaticTaskDefinition> missingTasks = new ArrayList<StaticTaskDefinition>();
        for (StaticTaskDefinition createTaskDef : tasksDef.getStaticTaskDefs()) {
            if (existingTaskNames.contains(createTaskDef.getName())) continue;
            missingTasks.add(createTaskDef);
        }
        return missingTasks;
    }

    private List<String> getExistingTaskNames() {
        return Named.getNames((Collection)this.atsApi.getTaskService().getTasks(this.teamWf));
    }
}

