/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.rule.validate;

import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.rule.validation.AbstractValidationRule;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;

public final class AttributeFormatRule
extends AbstractValidationRule {
    private final ArtifactTypeToken baseArtifactType;
    private final AttributeTypeToken attributeType;
    private final Integer minimumValues;
    private final String regex;

    public AttributeFormatRule(AtsApi atsApi, ArtifactTypeToken artifactType, AttributeTypeToken attributeType, Integer minimumValues, String regex) {
        super(atsApi);
        this.baseArtifactType = artifactType;
        this.attributeType = attributeType;
        this.minimumValues = minimumValues;
        this.regex = regex;
    }

    public boolean hasArtifactType(ArtifactTypeToken artifactType) {
        return artifactType.equals(this.baseArtifactType);
    }

    public void validate(ArtifactToken artifact, XResultData rd) {
        if (this.hasArtifactType(this.atsApi.getStoreService().getArtifactType((ArtifactId)artifact))) {
            List attributeValues = this.atsApi.getAttributeResolver().getAttributesToStringList((ArtifactId)artifact, this.attributeType);
            int validValueFound = 0;
            for (String attributeValue : attributeValues) {
                if (this.regex != null && !attributeValue.matches(this.regex)) {
                    String errStr = "\"" + attributeValue + "\"" + " needs to be of format: (" + this.regex + ")";
                    this.logError(artifact, errStr, rd);
                    continue;
                }
                ++validValueFound;
            }
            if (validValueFound < this.minimumValues) {
                String errStr = "has less than minimum " + this.minimumValues + " values set for attribute \"" + this.attributeType + "\"";
                this.logError(artifact, errStr, rd);
            }
        }
    }

    public String getRuleDescription() {
        return "For \"" + this.baseArtifactType + "\", ensure \"" + this.attributeType + "\" attribute has at least " + this.minimumValues + " value(s)" + (this.regex != null ? " and is of format: " + this.regex : "");
    }

    public String getRuleTitle() {
        return "Attribute Format Check:";
    }
}

