/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.query.IAtsConfigCacheQuery;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.Collections;

public class AtsConfigCacheQueryImpl
implements IAtsConfigCacheQuery {
    protected List<ArtifactTypeToken> artifactTypes;
    protected final AtsApi atsApi;
    private Boolean active = null;
    private List<WorkType> workTypes = null;

    public AtsConfigCacheQueryImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public <T extends IAtsConfigObject> Collection<T> get(Class<T> clazz) {
        HashSet<TeamDefinition> results = new HashSet<TeamDefinition>();
        if (this.artifactTypes.contains(AtsArtifactTypes.TeamDefinition)) {
            for (TeamDefinition teamDef : this.atsApi.getConfigService().getConfigurations().getIdToTeamDef().values()) {
                if (this.active != null && !this.active.equals(teamDef.isActive()) || this.workTypes != null && !this.workTypes.isEmpty() && Collections.setIntersection(this.workTypes, (Collection)teamDef.getWorkTypes()).size() == 0) continue;
                results.add(teamDef);
            }
        }
        return results;
    }

    public IAtsConfigCacheQuery isOfType(ArtifactTypeToken ... artifactType) {
        if (this.artifactTypes != null) {
            throw new OseeArgumentException("Can only specify one artifact type", new Object[0]);
        }
        this.artifactTypes = new LinkedList<ArtifactTypeToken>();
        ArtifactTypeToken[] artifactTypeTokenArray = artifactType;
        int n = artifactType.length;
        int n2 = 0;
        while (n2 < n) {
            ArtifactTypeToken type = artifactTypeTokenArray[n2];
            this.artifactTypes.add(type);
            ++n2;
        }
        return this;
    }

    public IAtsConfigCacheQuery andWorkType(WorkType workType, WorkType ... wts) {
        this.workTypes = new LinkedList<WorkType>();
        this.workTypes.add(workType);
        WorkType[] workTypeArray = wts;
        int n = wts.length;
        int n2 = 0;
        while (n2 < n) {
            WorkType wt = workTypeArray[n2];
            this.workTypes.add(wt);
            ++n2;
        }
        return this;
    }

    public IAtsConfigCacheQuery andActive(boolean active) {
        this.active = active;
        return this;
    }
}

