/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.notify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.notify.AtsNotificationCollector;
import org.eclipse.osee.ats.api.notify.AtsNotificationEvent;
import org.eclipse.osee.ats.api.notify.AtsWorkItemNotificationEvent;
import org.eclipse.osee.ats.api.notify.IAtsNotificationService;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.notify.OseeEmailCreator;
import org.eclipse.osee.ats.core.notify.SendNotificationEvents;
import org.eclipse.osee.ats.core.notify.WorkItemNotificationProcessor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.util.OseeEmail;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.EmailUtil;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public abstract class AbstractAtsNotificationService
implements IAtsNotificationService,
OseeEmailCreator {
    private volatile boolean emailEnabled = true;
    protected AtsApi atsApi;
    WorkItemNotificationProcessor workItemNotificationProcessor;
    boolean loggedNotificationDisabled = false;

    public AbstractAtsNotificationService(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public boolean isNotificationsEnabled() {
        return this.emailEnabled;
    }

    public void setNotificationsEnabled(boolean enabled) {
        this.emailEnabled = enabled;
    }

    public Collection<AtsUser> getJournalSubscribedUsers(IAtsWorkItem workItem) {
        HashSet<AtsUser> users = new HashSet<AtsUser>();
        Collection userArts = this.atsApi.getAttributeResolver().getAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.JournalSubscriber);
        for (ArtifactId userArt : userArts) {
            AtsUser user = this.atsApi.getConfigService().getUser(userArt);
            if (user == null) continue;
            users.add(user);
        }
        return users;
    }

    public void setJournalSubscribedUsers(IAtsWorkItem workItem, Collection<AtsUser> users) {
        ArrayList<ArtifactId> userIds = new ArrayList<ArtifactId>();
        for (AtsUser user : users) {
            userIds.add(user.getArtifactId());
        }
        IAtsChangeSet changes = this.atsApi.createChangeSet("Set Journal Subscribers");
        changes.setAttributeValues((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.JournalSubscriber, userIds);
        changes.executeIfNeeded();
    }

    public synchronized void sendNotifications(final AtsNotificationCollector notifications) {
        this.workItemNotificationProcessor = new WorkItemNotificationProcessor(this.atsApi);
        for (AtsWorkItemNotificationEvent workItemEvent : notifications.getWorkItemNotificationEvents()) {
            this.workItemNotificationProcessor.run(notifications, workItemEvent);
        }
        if (this.isNotificationsEnabled()) {
            Thread send = new Thread("Send Notifications"){

                @Override
                public void run() {
                    if (AbstractAtsNotificationService.this.isNotificationsEnabled()) {
                        if (!AbstractAtsNotificationService.this.atsApi.getStoreService().isProductionDb()) {
                            if (!AbstractAtsNotificationService.this.loggedNotificationDisabled) {
                                AbstractAtsNotificationService.this.atsApi.getLogger().info("Osee Notification Disabled", new Object[0]);
                                AbstractAtsNotificationService.this.loggedNotificationDisabled = true;
                            }
                        } else {
                            if (notifications.isIncludeCancelHyperlink() && !AbstractAtsNotificationService.this.atsApi.getWorkItemService().isCancelHyperlinkConfigured()) {
                                throw new OseeArgumentException("Cancel Hyperlink URl not configured", new Object[0]);
                            }
                            Thread thread = new Thread("ATS Notification Sender"){

                                @Override
                                public void run() {
                                    super.run();
                                    String testingUserEmail = "";
                                    String fromUserEmail = AbstractAtsNotificationService.this.getFromUserEmail(notifications);
                                    AbstractAtsNotificationService.this.sendNotifications(fromUserEmail, testingUserEmail, notifications.getSubject(), notifications.getBody(), notifications.getNotificationEvents());
                                }
                            };
                            thread.start();
                        }
                    }
                }
            };
            send.start();
        }
    }

    public void sendNotifications(String fromUserEmail, String testingUserEmail, String subject, String body, Collection<? extends AtsNotificationEvent> notificationEvents) {
        SendNotificationEvents job = new SendNotificationEvents(this, this.atsApi, fromUserEmail, testingUserEmail, subject, body, notificationEvents, this.atsApi.getUserService());
        job.run();
    }

    public void sendNotifications(final String fromUserEmail, final Collection<String> toUserEmails, final String subject, final String htmlBody) {
        if (this.isNotificationsEnabled()) {
            Thread thread = new Thread("ATS Emailer"){

                @Override
                public void run() {
                    try {
                        OseeEmail msg = AbstractAtsNotificationService.this.createOseeEmail();
                        msg.setFrom(fromUserEmail);
                        msg.setRecipients(toUserEmails.toArray(new String[toUserEmails.size()]));
                        msg.setSubject(subject);
                        msg.setHTMLBody(htmlBody);
                        msg.send();
                    }
                    catch (Exception ex) {
                        System.err.println(Lib.exceptionToString((Exception)ex));
                    }
                }
            };
            thread.start();
        }
    }

    @Override
    public abstract OseeEmail createOseeEmail();

    private String getFromUserEmail(AtsNotificationCollector notifications) {
        String email = this.atsApi.getConfigValue("NoReplyEmail");
        for (AtsNotificationEvent event : notifications.getNotificationEvents()) {
            AtsUser userById;
            if (!Strings.isValid((String)event.getFromUserId()) || !EmailUtil.isEmailValid((String)(userById = this.atsApi.getUserService().getUserByUserId(event.getFromUserId())).getEmail())) continue;
            email = userById.getEmail();
            break;
        }
        return email;
    }
}

