/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal.column.ev;

import java.util.Collections;
import java.util.Map;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IWorkPackageColumn;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.ev.IAtsEarnedValueServiceProvider;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.column.IWorkPackageUtility;
import org.eclipse.osee.ats.core.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class WorkPackageColumn
implements IWorkPackageUtility,
IWorkPackageColumn {
    private final IAtsEarnedValueServiceProvider earnedValueServiceProvider;
    private Map<ArtifactId, ArtifactToken> idToWorkPackage;
    private final AtsApi atsApi;

    public WorkPackageColumn(IAtsEarnedValueServiceProvider earnedValueServiceProvider) {
        this.earnedValueServiceProvider = earnedValueServiceProvider;
        this.atsApi = AtsApiService.get();
    }

    @Override
    public ArtifactId getWorkPackageId(Object object) {
        return this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)object);
    }

    public void setIdToWorkPackageCache(Map<ArtifactId, ArtifactToken> idToWorkPackage) {
        this.idToWorkPackage = idToWorkPackage;
    }

    public String getColumnText(IAtsObject atsObject) {
        String result = "";
        try {
            if (atsObject instanceof IAtsTeamWorkflow && this.atsApi.getEarnedValueService().isUseTextWorkPackages(Collections.singleton((IAtsTeamWorkflow)atsObject))) {
                result = (String)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)((IAtsTeamWorkflow)atsObject), (AttributeTypeToken)AtsAttributeTypes.WorkPackage, (Object)"");
            } else {
                IAtsWorkPackage workPackage = null;
                if (atsObject instanceof IAtsWorkItem) {
                    ArtifactId workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject);
                    if (this.idToWorkPackage != null && workPackageId.isValid()) {
                        ArtifactToken wpArt = this.idToWorkPackage.get(workPackageId);
                        workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((ArtifactId)wpArt);
                    }
                    if (workPackage == null && (workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject)) != null && this.idToWorkPackage != null) {
                        this.idToWorkPackage.put(workPackageId, workPackage.getStoreObject());
                    }
                    if (workPackage != null) {
                        result = this.getText(workPackage);
                    }
                }
            }
        }
        catch (OseeCoreException ex) {
            return "!Error - " + ex.getLocalizedMessage();
        }
        return result;
    }

    private String getText(IAtsWorkPackage workPackage) {
        String result = "";
        if (workPackage != null) {
            String activityId = Strings.isValid((String)workPackage.getActivityId()) ? workPackage.getActivityId() : "";
            String activityName = Strings.isValid((String)workPackage.getActivityName()) ? workPackage.getActivityName() : "";
            result = String.format("%s - %s", activityId, activityName);
        }
        return result;
    }

    @Override
    public String getColumnText(IAtsWorkPackage workPackage) {
        return this.getText(workPackage);
    }

    @Override
    public IAtsWorkPackage getWorkPackage(IAtsObject atsObject) {
        IAtsWorkPackage workPackage = null;
        ArtifactId workPackageId = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackageId((IAtsWorkItem)atsObject);
        if (this.idToWorkPackage != null && workPackageId.isValid()) {
            ArtifactToken wpArt = this.idToWorkPackage.get(workPackageId);
            workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((ArtifactId)wpArt);
            if (workPackage != null) {
                return workPackage;
            }
        }
        if (atsObject instanceof IAtsWorkItem) {
            workPackage = this.earnedValueServiceProvider.getEarnedValueService().getWorkPackage((IAtsWorkItem)atsObject);
        }
        return workPackage;
    }
}

