/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.internal;

import java.util.Collection;
import java.util.Date;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.IAtsWorkItemMetricsService;
import org.eclipse.osee.ats.api.workflow.log.IAtsLogItem;
import org.eclipse.osee.ats.api.workflow.log.LogType;
import org.eclipse.osee.ats.core.workflow.state.TeamState;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;

public class AtsWorkItemMetricsServiceImpl
implements IAtsWorkItemMetricsService {
    private final AtsApi atsApi;

    public AtsWorkItemMetricsServiceImpl(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public void logMetrics(IAtsWorkItem workItem, IStateToken state, AtsUser user, Date date, IAtsChangeSet changes) {
        String hoursSpent = AtsUtil.doubleToI18nString((double)this.getHoursSpentTotal((IAtsObject)workItem));
        this.logMetrics(workItem, String.valueOf(this.getPercentCompleteTotal((IAtsObject)workItem)), hoursSpent, state, user, date, changes);
    }

    public void logMetrics(IAtsWorkItem workItem, String percent, String hours, IStateToken state, AtsUser user, Date date, IAtsChangeSet changes) {
        IAtsLogItem logItem = this.atsApi.getLogFactory().newLogItem(LogType.Metrics, date, user, state.getName(), String.format("Percent %s Hours %s", this.getPercentCompleteTotal((IAtsObject)workItem), Double.parseDouble(hours)));
        workItem.getLog().addLogItem(logItem);
    }

    public void updateMetrics(IAtsWorkItem workItem, IStateToken state, double additionalHours, int percentComplete, boolean logMetrics, AtsUser user, IAtsChangeSet changes) {
        double hoursSpent = this.getHoursSpent(workItem);
        double totalHours = hoursSpent + additionalHours;
        if (totalHours < 0.0) {
            totalHours = 0.0;
        }
        this.setHoursSpent(workItem, totalHours, changes);
        this.setPercentComplete(workItem, percentComplete, changes);
        if (logMetrics) {
            this.logMetrics(workItem, workItem.getStateMgr().getCurrentState(), user, new Date(), changes);
        }
    }

    public double getHoursSpent(IAtsWorkItem workItem) {
        return (Double)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.HoursSpent, (Object)0.0);
    }

    public void setMetrics(IAtsWorkItem workItem, double hoursSpent, int percentComplete, boolean logMetrics, AtsUser user, Date date, IAtsChangeSet changes) {
        this.setHoursSpent(workItem, hoursSpent, changes);
        this.setPercentComplete(workItem, percentComplete, changes);
        if (logMetrics) {
            this.logMetrics(workItem, String.valueOf(percentComplete), String.valueOf(hoursSpent), (IStateToken)TeamState.valueOf(workItem.getCurrentStateName()), user, new Date(), changes);
        }
    }

    public void setHoursSpent(IAtsWorkItem workItem, double hoursSpent, IAtsChangeSet changes) {
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.HoursSpent, (Object)hoursSpent);
    }

    public void setPercentComplete(IAtsWorkItem workItem, Integer percentComplete, IAtsChangeSet changes) {
        changes.setSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)percentComplete);
    }

    public Integer getPercentComplete(IAtsWorkItem workItem) {
        return (Integer)this.atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)0);
    }

    public double getHoursSpentTotal(IAtsObject atsObject) {
        double hours = 0.0;
        if (atsObject instanceof IAtsAction) {
            for (IAtsTeamWorkflow team : ((IAtsAction)atsObject).getTeamWorkflows()) {
                if (team.getCurrentStateType().isCancelled()) continue;
                hours += this.getHoursSpentTotal((IAtsObject)team);
            }
        } else if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            hours = this.atsApi.getWorkItemMetricsService().getHoursSpent(workItem) + this.getHoursSpentFromTasks(atsObject) + this.getHoursSpentReview(atsObject);
        }
        return hours;
    }

    public double getHoursSpentReview(IAtsObject atsObject) {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsAbstractReview review : this.atsApi.getWorkItemService().getReviews((IAtsTeamWorkflow)atsObject)) {
                hours += this.getHoursSpentTotal((IAtsObject)review);
            }
        }
        return hours;
    }

    public double getHoursSpentFromTasks(IAtsObject atsObject) {
        double hours = 0.0;
        if (atsObject instanceof IAtsTeamWorkflow) {
            for (IAtsTask taskArt : this.atsApi.getTaskService().getTasks((IAtsTeamWorkflow)atsObject)) {
                hours += this.getHoursSpentTotal((IAtsObject)taskArt);
            }
        }
        return hours;
    }

    public int getPercentCompleteTotal(IAtsObject atsObject) {
        int percent = 0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            percent = workItem.getCurrentStateType().isCompletedOrCancelled() ? 100 : this.getPercentCompleteSMASinglePercent((IAtsObject)workItem, this.atsApi);
        }
        return percent;
    }

    private int getPercentCompleteSMASinglePercent(IAtsObject atsObject, AtsApi atsApi) {
        int percent = 0;
        if (atsObject instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
            int numObjects = 1;
            percent = (Integer)atsApi.getAttributeResolver().getSoleAttributeValue((IAtsObject)workItem, (AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)0);
            if (workItem instanceof IAtsTeamWorkflow) {
                for (IAtsAbstractReview revArt : atsApi.getWorkItemService().getReviews((IAtsTeamWorkflow)workItem)) {
                    percent += this.getPercentCompleteTotal((IAtsObject)revArt);
                    ++numObjects;
                }
            }
            if (workItem instanceof IAtsTeamWorkflow) {
                for (IAtsTask taskArt : atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem)) {
                    percent += this.getPercentCompleteTotal((IAtsObject)taskArt);
                    ++numObjects;
                }
            }
            if (percent > 0 && numObjects > 0) {
                percent /= numObjects;
            }
        }
        return percent;
    }

    public int getPercentCompleteSMAStateTotal(IAtsObject atsObject, IStateToken state, AtsApi atsApi) {
        if (this.getStateMetricsData(atsObject, state, atsApi) == null) {
            return 0;
        }
        return this.getStateMetricsData(atsObject, state, atsApi).getResultingPercent();
    }

    private StateMetricsData getStateMetricsData(IAtsObject atsObject, IStateToken teamState, AtsApi atsApi) {
        if (!(atsObject instanceof IAtsWorkItem)) {
            return null;
        }
        IAtsWorkItem workItem = (IAtsWorkItem)atsObject;
        int percent = 0;
        int numObjects = 0;
        if (workItem instanceof IAtsTeamWorkflow) {
            Collection tasks = atsApi.getTaskService().getTasks((IAtsTeamWorkflow)workItem, teamState);
            for (IAtsTask taskArt : tasks) {
                percent += this.getPercentCompleteTotal((IAtsObject)taskArt);
            }
            numObjects += tasks.size();
        }
        if (workItem instanceof IAtsTeamWorkflow) {
            Collection reviews = atsApi.getWorkItemService().getReviews((IAtsTeamWorkflow)workItem, teamState);
            for (IAtsAbstractReview reviewArt : reviews) {
                percent += this.getPercentCompleteTotal((IAtsObject)reviewArt);
            }
            numObjects += reviews.size();
        }
        return new StateMetricsData(percent, numObjects);
    }

    private static class StateMetricsData {
        public int numObjects = 0;
        public int percent = 0;

        public StateMetricsData(int percent, int numObjects) {
            this.numObjects = numObjects;
            this.percent = percent;
        }

        public int getResultingPercent() {
            return this.percent / this.numObjects;
        }

        public String toString() {
            return "Percent: " + this.getResultingPercent() + "  NumObjs: " + this.numObjects + "  Total Percent: " + this.percent;
        }
    }
}

