/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.column;

import java.util.Collection;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;

public class BacklogColumn {
    public static String getColumnText(Object element, AtsApi atsApi, boolean forBacklog) {
        if (element instanceof IAtsWorkItem) {
            IAtsWorkItem workItem = (IAtsWorkItem)element;
            Collection related = atsApi.getRelationResolver().getRelated((IAtsObject)workItem, AtsRelationTypes.Goal_Goal, IAtsWorkItem.class);
            if (!related.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (IAtsWorkItem relatedWorkItem : related) {
                    if (forBacklog) {
                        if (!BacklogColumn.isBacklog(relatedWorkItem, atsApi)) continue;
                        sb.append(relatedWorkItem.getName());
                        sb.append("; ");
                        continue;
                    }
                    if (BacklogColumn.isBacklog(relatedWorkItem, atsApi)) continue;
                    sb.append(relatedWorkItem.getName());
                    sb.append("; ");
                }
                return sb.toString().replaceFirst("; $", "");
            }
        }
        return "";
    }

    public static boolean isBacklog(IAtsWorkItem workItem, AtsApi atsApi) {
        return workItem.getStoreObject().isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AgileBacklog}) || atsApi.getRelationResolver().getRelatedCount(workItem, AtsRelationTypes.AgileTeamToBacklog_AgileTeam) == 1;
    }
}

