/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.core.agile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workdef.StateType;
import org.eclipse.osee.ats.core.model.impl.AtsConfigObject;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.logger.Log;

public class AgileTeam
extends AtsConfigObject
implements IAgileTeam {
    public AgileTeam(Log logger, AtsApi atsApi, ArtifactToken artifact) {
        super(logger, atsApi, artifact, AtsArtifactTypes.AgileTeam);
    }

    public List<Long> getAtsTeamIds() {
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ArtifactId atsTeam : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToAtsTeam_AtsTeam)) {
            ids.add(atsTeam.getId());
        }
        return ids;
    }

    public ArtifactId getBacklogId() {
        ArtifactId backlogId = ArtifactId.SENTINEL;
        try {
            backlogId = this.atsApi.getRelationResolver().getRelatedOrNull((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToBacklog_Backlog);
        }
        catch (Exception exception) {}
        return backlogId;
    }

    public ArtifactId getSprintId() {
        ArtifactId sprintId = ArtifactId.SENTINEL;
        try {
            for (ArtifactToken sprint : this.atsApi.getRelationResolver().getRelated((ArtifactId)this.artifact, AtsRelationTypes.AgileTeamToSprint_Sprint)) {
                if (!((String)this.atsApi.getAttributeResolver().getSoleAttributeValue((ArtifactId)sprint, (AttributeTypeToken)AtsAttributeTypes.CurrentStateType, (Object)"")).equals(StateType.Working.name())) continue;
                sprintId = sprint;
                break;
            }
        }
        catch (Exception exception) {}
        return sprintId;
    }
}

