/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal.bytebuddy.utility;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import org.assertj.core.internal.bytebuddy.utility.JavaDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FileSystem {
    INSTANCE;

    private static final Dispatcher DISPATCHER;
    private static final Files FILES;
    private static final StandardCopyOption STANDARD_COPY_OPTION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(File source, File target) throws IOException {
        block8: {
            Object[] option = STANDARD_COPY_OPTION.toArray(1);
            if (option.length == 0) {
                FileInputStream inputStream = new FileInputStream(source);
                try {
                    FileOutputStream outputStream = new FileOutputStream(target);
                    try {
                        int length;
                        byte[] buffer = new byte[1024];
                        while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                            ((OutputStream)outputStream).write(buffer, 0, length);
                        }
                        break block8;
                    }
                    finally {
                        ((OutputStream)outputStream).close();
                    }
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            FILES.copy(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(File source, File target) throws IOException {
        Object[] option = STANDARD_COPY_OPTION.toArray(1);
        if (option.length == 0) {
            FileInputStream inputStream = new FileInputStream(source);
            try {
                FileOutputStream outputStream = new FileOutputStream(target);
                try {
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = ((InputStream)inputStream).read(buffer)) != -1) {
                        ((OutputStream)outputStream).write(buffer, 0, length);
                    }
                }
                finally {
                    ((OutputStream)outputStream).close();
                }
            }
            finally {
                ((InputStream)inputStream).close();
            }
            if (!source.delete()) {
                source.deleteOnExit();
            }
        } else {
            option[0] = STANDARD_COPY_OPTION.valueOf("REPLACE_EXISTING");
            FILES.move(DISPATCHER.toPath(source), DISPATCHER.toPath(target), option);
        }
    }

    static {
        DISPATCHER = AccessController.doPrivileged(JavaDispatcher.of(Dispatcher.class));
        FILES = AccessController.doPrivileged(JavaDispatcher.of(Files.class));
        STANDARD_COPY_OPTION = AccessController.doPrivileged(JavaDispatcher.of(StandardCopyOption.class));
    }

    @JavaDispatcher.Proxied(value="java.io.File")
    protected static interface Dispatcher {
        public Object toPath(File var1) throws IOException;
    }

    @JavaDispatcher.Proxied(value="java.nio.file.Files")
    protected static interface Files {
        @JavaDispatcher.IsStatic
        public Object copy(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1, @JavaDispatcher.Proxied(value="java.nio.file.Path") Object var2, @JavaDispatcher.Proxied(value="java.nio.file.CopyOption") Object[] var3) throws IOException;

        @JavaDispatcher.IsStatic
        public Object move(@JavaDispatcher.Proxied(value="java.nio.file.Path") Object var1, @JavaDispatcher.Proxied(value="java.nio.file.Path") Object var2, @JavaDispatcher.Proxied(value="java.nio.file.CopyOption") Object[] var3) throws IOException;
    }

    @JavaDispatcher.Proxied(value="java.nio.file.StandardCopyOption")
    protected static interface StandardCopyOption {
        @JavaDispatcher.Defaults
        @JavaDispatcher.Container
        public Object[] toArray(int var1);

        @JavaDispatcher.IsStatic
        public Object valueOf(String var1);
    }
}

