/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.internal.bytebuddy.description.type.TypeDescription;
import org.assertj.core.internal.bytebuddy.dynamic.loading.ClassInjector;
import org.assertj.core.internal.bytebuddy.dynamic.loading.ClassLoadingStrategy;

class ClassLoadingStrategyFactory {
    private static final MethodHandles.Lookup LOOKUP;
    private static final Method PRIVATE_LOOKUP_IN;
    static final ClassLoader ASSERTJ_CLASS_LOADER;

    ClassLoadingStrategyFactory() {
    }

    static ClassLoadingStrategyPair classLoadingStrategy(Class<?> assertClass) {
        ClassLoader assertClassLoader = assertClass.getClassLoader();
        if (assertClassLoader != ASSERTJ_CLASS_LOADER) {
            CompositeClassLoader compositeClassLoader = new CompositeClassLoader(assertClassLoader);
            return new ClassLoadingStrategyPair(compositeClassLoader, compositeClassLoader);
        }
        if (ClassInjector.UsingReflection.isAvailable()) {
            return new ClassLoadingStrategyPair(assertClassLoader, ClassLoadingStrategy.Default.INJECTION);
        }
        if (ClassInjector.UsingLookup.isAvailable()) {
            try {
                return new ClassLoadingStrategyPair(assertClassLoader, ClassLoadingStrategy.UsingLookup.of(PRIVATE_LOOKUP_IN.invoke(null, assertClass, LOOKUP)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not access package of " + assertClass, e);
            }
        }
        throw new IllegalStateException("No code generation strategy available");
    }

    static {
        Method privateLookupIn;
        LOOKUP = MethodHandles.lookup();
        ASSERTJ_CLASS_LOADER = ClassLoadingStrategyFactory.class.getClassLoader();
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (Exception e) {
            privateLookupIn = null;
        }
        PRIVATE_LOOKUP_IN = privateLookupIn;
    }

    static class ClassLoadingStrategyPair {
        private final ClassLoader classLoader;
        private final ClassLoadingStrategy<ClassLoader> classLoadingStrategy;

        ClassLoadingStrategyPair(ClassLoader classLoader, ClassLoadingStrategy<ClassLoader> classLoadingStrategy) {
            this.classLoader = classLoader;
            this.classLoadingStrategy = classLoadingStrategy;
        }

        ClassLoader getClassLoader() {
            return this.classLoader;
        }

        ClassLoadingStrategy<ClassLoader> getClassLoadingStrategy() {
            return this.classLoadingStrategy;
        }
    }

    static class CompositeClassLoader
    extends ClassLoader
    implements ClassLoadingStrategy<ClassLoader> {
        CompositeClassLoader(ClassLoader parent) {
            super(parent);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            return ASSERTJ_CLASS_LOADER.loadClass(name);
        }

        @Override
        protected URL findResource(String name) {
            return ASSERTJ_CLASS_LOADER.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return ASSERTJ_CLASS_LOADER.getResources(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
            LinkedHashMap result = new LinkedHashMap();
            for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
                TypeDescription typeDescription = entry.getKey();
                String name = typeDescription.getName();
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    Class<?> type = this.findLoadedClass(name);
                    if (type != null) {
                        throw new IllegalStateException("Cannot define already loaded type: " + type);
                    }
                    byte[] typeDefinition = entry.getValue();
                    type = this.defineClass(name, typeDefinition, 0, typeDefinition.length);
                    result.put(typeDescription, type);
                }
            }
            return result;
        }
    }
}

