/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Comparator;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.StringAssert;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ByteArrays;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.Hexadecimals;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractByteArrayAssert<SELF extends AbstractByteArrayAssert<SELF>>
extends AbstractArrayAssert<SELF, byte[], Byte> {
    @VisibleForTesting
    protected ByteArrays arrays = ByteArrays.instance();

    protected AbstractByteArrayAssert(byte[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public SELF isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (byte[])this.actual);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (byte[])this.actual, expected);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThan(int boundary) {
        this.arrays.assertHasSizeGreaterThan(this.info, (byte[])this.actual, boundary);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeGreaterThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeGreaterThanOrEqualTo(this.info, (byte[])this.actual, boundary);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThan(int boundary) {
        this.arrays.assertHasSizeLessThan(this.info, (byte[])this.actual, boundary);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeLessThanOrEqualTo(int boundary) {
        this.arrays.assertHasSizeLessThanOrEqualTo(this.info, (byte[])this.actual, boundary);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSizeBetween(int lowerBoundary, int higherBoundary) {
        this.arrays.assertHasSizeBetween(this.info, (byte[])this.actual, lowerBoundary, higherBoundary);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(this.info, (byte[])this.actual, other);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF contains(byte ... values) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF contains(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF contains(int ... values) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnly(byte ... values) {
        this.arrays.assertContainsOnly((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnly(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnly((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnly(int ... values) {
        this.arrays.assertContainsOnly((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(byte ... values) {
        this.arrays.assertContainsOnlyOnce((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsOnlyOnce((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSequence(byte ... sequence) {
        this.arrays.assertContainsSequence((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSequence(Byte[] sequence) {
        AbstractByteArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertContainsSequence((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(sequence));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSubsequence(byte ... subsequence) {
        this.arrays.assertContainsSubsequence((AssertionInfo)this.info, (byte[])this.actual, subsequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSubsequence(Byte[] subsequence) {
        AbstractByteArrayAssert.requireNonNullParameter(subsequence, "subsequence");
        this.arrays.assertContainsSubsequence((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(subsequence));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsSubsequence(int ... subsequence) {
        this.arrays.assertContainsSubsequence((AssertionInfo)this.info, (byte[])this.actual, subsequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF contains(byte value, Index index) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF contains(int value, Index index) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotContain(byte ... values) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotContain(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotContain(byte value, Index index) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (byte[])this.actual);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF startsWith(byte ... sequence) {
        this.arrays.assertStartsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF startsWith(Byte[] sequence) {
        AbstractByteArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertStartsWith((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(sequence));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF startsWith(int ... sequence) {
        this.arrays.assertStartsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF endsWith(byte ... sequence) {
        this.arrays.assertEndsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF endsWith(Byte[] sequence) {
        AbstractByteArrayAssert.requireNonNullParameter(sequence, "sequence");
        this.arrays.assertEndsWith((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(sequence));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF endsWith(int ... sequence) {
        this.arrays.assertEndsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF isSorted() {
        this.arrays.assertIsSorted(this.info, (byte[])this.actual);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public SELF isSortedAccordingTo(Comparator<? super Byte> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (byte[])this.actual, comparator);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingElementComparator(Comparator<? super Byte> customComparator) {
        this.arrays = new ByteArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultElementComparator() {
        this.arrays = ByteArrays.instance();
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactly(byte ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactly(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.objects.assertEqual(this.info, this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactly(int ... values) {
        this.arrays.assertContainsExactly((AssertionInfo)this.info, (byte[])this.actual, this.arrays.toByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(byte ... values) {
        this.arrays.assertContainsExactlyInAnyOrder((AssertionInfo)this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsExactlyInAnyOrder((AssertionInfo)this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsExactlyInAnyOrder(int ... values) {
        this.arrays.assertContainsExactlyInAnyOrder((AssertionInfo)this.info, (byte[])this.actual, this.arrays.toByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsAnyOf(byte ... values) {
        this.arrays.assertContainsAnyOf(this.info, (byte[])this.actual, values);
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsAnyOf(Byte[] values) {
        AbstractByteArrayAssert.requireNonNullParameter(values, "values");
        this.arrays.assertContainsAnyOf(this.info, (byte[])this.actual, AbstractByteArrayAssert.toPrimitiveByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    public SELF containsAnyOf(int ... values) {
        this.arrays.assertContainsAnyOf(this.info, (byte[])this.actual, this.arrays.toByteArray(values));
        return (SELF)((AbstractByteArrayAssert)this.myself);
    }

    @CheckReturnValue
    public AbstractStringAssert<?> asHexString() {
        this.objects.assertNotNull(this.info, this.actual);
        return Assertions.assertThat(Hexadecimals.toHexString((byte[])this.actual));
    }

    @Override
    @CheckReturnValue
    public AbstractStringAssert<?> asString() {
        this.objects.assertNotNull(this.info, this.actual);
        String actualAsString = new String((byte[])this.actual);
        return Assertions.assertThat(actualAsString);
    }

    @CheckReturnValue
    public AbstractStringAssert<?> asString(Charset charset) {
        this.objects.assertNotNull(this.info, this.actual);
        String actualAsString = new String((byte[])this.actual, charset);
        return Assertions.assertThat(actualAsString);
    }

    @CheckReturnValue
    public AbstractStringAssert<?> encodedAsBase64() {
        this.objects.assertNotNull(this.info, this.actual);
        return (AbstractStringAssert)new StringAssert(Base64.getEncoder().encodeToString((byte[])this.actual)).withAssertionState(this.myself);
    }

    private static byte[] toPrimitiveByteArray(Byte[] values) {
        byte[] bytes = new byte[values.length];
        IntStream.range(0, values.length).forEach(i -> {
            bytes[i] = values[i];
        });
        return bytes;
    }
}

