/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.console.admin.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osee.console.admin.ConsoleCommand;
import org.eclipse.osee.console.admin.ConsoleParameters;
import org.eclipse.osee.console.admin.internal.ConsoleParametersImpl;
import org.eclipse.osee.framework.jdk.core.type.PropertyStore;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osgi.framework.console.CommandInterpreter;

public final class ConsoleAdminUtils {
    private ConsoleAdminUtils() {
    }

    public static String getContextName(Map<String, String> props) {
        String contextName = props.get("context.name");
        if (!ConsoleAdminUtils.isValid(contextName)) {
            contextName = ConsoleAdminUtils.getComponentName(props);
        }
        return ConsoleAdminUtils.normalize(contextName);
    }

    public static String getComponentName(Map<String, String> props) {
        return props.get("component.name");
    }

    private static String normalize(String contextName) {
        return contextName != null && !contextName.startsWith("/") ? "/" + contextName : contextName;
    }

    private static boolean isValid(String value) {
        return value != null && value.length() > 0;
    }

    public static Map<String, String> toMap(String componentName, String contextName) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("component.name", componentName);
        data.put("context.name", contextName);
        return data;
    }

    public static List<ConsoleCommand> sort(Collection<ConsoleCommand> origCommands) {
        ArrayList<ConsoleCommand> cmds = new ArrayList<ConsoleCommand>(origCommands);
        Collections.sort(cmds, new Comparator<ConsoleCommand>(){

            @Override
            public int compare(ConsoleCommand o1, ConsoleCommand o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return cmds;
    }

    private static String removeQuotes(String value) {
        String toReturn = value;
        int stringLength = toReturn.length();
        if (stringLength > 1 && (toReturn.startsWith("\"") && toReturn.endsWith("\"") || toReturn.startsWith("'") && toReturn.endsWith("'"))) {
            toReturn = toReturn.substring(1, stringLength - 1);
        }
        return toReturn;
    }

    public static ConsoleParameters parse(CommandInterpreter ci) {
        String commandName = "";
        StringBuilder rawString = new StringBuilder();
        PropertyStore store = new PropertyStore();
        HashSet<String> options = new HashSet<String>();
        int count = 0;
        String arg = ci.nextArgument();
        while (arg != null) {
            if (Strings.isValid((String)arg)) {
                rawString.append(arg);
                if (count == 0) {
                    commandName = arg.toLowerCase();
                } else {
                    String[] entries = arg.split("=");
                    if (entries.length == 2) {
                        String key = entries[0];
                        String value = entries[1];
                        if (Strings.isValid((String)key) && Strings.isValid((String)value)) {
                            value = ConsoleAdminUtils.removeQuotes(value);
                            store.put(key, value);
                            String[] arrayVal = value.split("[,;& ]\\s*");
                            if (arrayVal != null && arrayVal.length > 0) {
                                store.put(key, arrayVal);
                            }
                        }
                    } else if (arg.startsWith("-")) {
                        options.add(arg.substring(1));
                    }
                }
            }
            arg = ci.nextArgument();
            ++count;
            if (!Strings.isValid((String)arg)) continue;
            rawString.append(" ");
        }
        return new ConsoleParametersImpl(commandName, rawString.toString(), store, options);
    }

    public static void checkNotNull(Object object, String objectName) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(String.format("%s cannot be null", objectName));
        }
    }

    public static void checkNotNull(Object object, String objectName, String details, Object ... data) throws IllegalArgumentException {
        if (object == null) {
            String message = String.format(details, data);
            throw new IllegalArgumentException(String.format("%s cannot be null - %s", objectName, message));
        }
    }

    public static void checkNotNullOrEmpty(String object, String objectName) throws IllegalArgumentException {
        ConsoleAdminUtils.checkNotNull(object, objectName);
        if (object.length() == 0) {
            throw new IllegalArgumentException(String.format("%s cannot be empty", objectName));
        }
    }
}

