/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.model;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.TransactionDetailsType;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.IdJoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.framework.ui.branch.graph.Activator;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.model.TxData;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;
import org.eclipse.osee.framework.ui.branch.graph.operation.IProgressListener;
import org.eclipse.osee.jdbc.JdbcStatement;

public class GraphLoader {
    private static final String GET_TRANSACTION_DATA = "SELECT otd.* FROM osee_join_id ojt, osee_tx_details otd WHERE ojt.id = otd.transaction_id and ojt.query_id = ? ORDER BY otd.transaction_id desc";

    private GraphLoader() {
    }

    public static void load(GraphCache graphCache, IProgressListener progress) {
        GraphLoader.load(graphCache, graphCache.getRootModel(), true, progress);
    }

    protected static void load(GraphCache graphCache, BranchModel modelToLoad, boolean recurse, IProgressListener progress) {
        GraphLoader.loadBranches(graphCache, modelToLoad, recurse, progress);
        GraphLoader.addParentTxData(graphCache, modelToLoad, recurse, progress);
        GraphLoader.updateConnections(graphCache, modelToLoad, recurse, progress);
    }

    protected static void loadBranches(GraphCache graphCache, BranchModel current, boolean recurse, IProgressListener listener) {
        for (BranchId child : BranchManager.getChildBranches((BranchId)current.getBranch(), (boolean)false)) {
            BranchModel childModel = graphCache.getOrCreateBranchModel(child);
            childModel.setDepth(current.getDepth() + 1);
            if (recurse) {
                GraphLoader.loadBranches(graphCache, childModel, true, listener);
            }
            current.addChildBranchModel(childModel);
            listener.worked();
        }
    }

    private static void addParentTxData(GraphCache graphCache, BranchModel current, boolean recurse, IProgressListener listener) {
        Throwable throwable = null;
        Object var5_6 = null;
        try (IdJoinQuery joinQuery = JoinUtility.createIdJoinQuery();){
            ArrayList<BranchId> branches = new ArrayList<BranchId>(BranchManager.getChildBranches((BranchId)current.getBranch(), (boolean)recurse));
            branches.add(current.getBranch());
            for (BranchId branch : branches) {
                TransactionRecord tr = BranchManager.getSourceTransaction((BranchId)branch);
                if (tr == null) continue;
                joinQuery.add((Id)tr);
            }
            joinQuery.store();
            for (TxData txData : GraphLoader.getTxData(joinQuery.getQueryId())) {
                BranchModel branchModel = graphCache.getOrCreateBranchModel(txData.getBranch());
                branchModel.addTx(graphCache.getOrCreateTxModel(txData));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void updateConnections(GraphCache graphCache, BranchModel current, boolean recurse, IProgressListener listener) {
        TxModel systemRootTx = null;
        ArrayList<BranchModel> models = new ArrayList<BranchModel>();
        models.addAll(current.getAllChildrenBelow());
        models.add(current);
        for (BranchModel branchModel : models) {
            TxModel txModel;
            if (BranchManager.getType((BranchId)branchModel.getBranch()).isSystemRootBranch()) {
                systemRootTx = branchModel.getFirstTx();
                continue;
            }
            long parentTxId = 0L;
            try {
                TransactionRecord tr = BranchManager.getSourceTransaction((BranchId)branchModel.getBranch());
                if (tr != null) {
                    parentTxId = tr.getId();
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
            if (parentTxId <= 0L || (txModel = branchModel.getFirstTx()) == null) continue;
            TxModel source = graphCache.getTxModel(parentTxId);
            if (source != null) {
                GraphLoader.connect(source, txModel);
                continue;
            }
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (String)"Invalid parent transaction id of [%s] for branch [%s]", (Object[])new Object[]{parentTxId, branchModel.getBranch()});
        }
        if (systemRootTx != null) {
            for (BranchModel branchModel : models) {
                try {
                    TxModel txModel;
                    BranchId branch = branchModel.getBranch();
                    if (!BranchManager.isParentSystemRoot((BranchId)branch) || (txModel = branchModel.getFirstTx()) == null) continue;
                    GraphLoader.connect(systemRootTx, txModel);
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void connect(TxModel source, TxModel target) {
        target.setSourceTx(source);
    }

    private static List<TxData> getTxData(Long queryId) {
        ArrayList<TxData> txDatas = new ArrayList<TxData>();
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            chStmt.runPreparedQuery(GET_TRANSACTION_DATA, new Object[]{queryId});
            while (chStmt.next()) {
                BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                TxData txData = new TxData(branch, UserId.valueOf((Long)chStmt.getLong("author")), chStmt.getTimestamp("time"), chStmt.getString("osee_comment"), TransactionDetailsType.valueOf((int)chStmt.getInt("tx_type")), chStmt.getLong("transaction_id"));
                txDatas.add(txData);
            }
        }
        return txDatas;
    }
}

