/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.figure;

import java.util.Date;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.branch.graph.figure.BranchFigure;
import org.eclipse.osee.framework.ui.branch.graph.figure.FrameFigure;
import org.eclipse.osee.framework.ui.branch.graph.figure.TxFigure;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.TxData;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;
import org.eclipse.osee.framework.ui.branch.graph.utility.GraphColorConstants;
import org.eclipse.osee.framework.ui.branch.graph.utility.GraphImageConstants;
import org.eclipse.osee.framework.ui.branch.graph.utility.GraphTextFormat;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class FigureFactory {
    private FigureFactory() {
    }

    public static PolylineConnection createConnection(IFigure contents, IFigure source, IFigure target, String toolTip, boolean hasEndPoint, Color color) {
        PolylineConnection connection = new PolylineConnection();
        ChopboxAnchor targetAnchor = new ChopboxAnchor(target);
        connection.setTargetAnchor((ConnectionAnchor)targetAnchor);
        connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(source));
        if (hasEndPoint) {
            PolygonDecoration decoration = new PolygonDecoration();
            decoration.setTemplate(PolygonDecoration.TRIANGLE_TIP);
            connection.setTargetDecoration((RotatableDecoration)decoration);
        }
        if (toolTip != null) {
            connection.setToolTip((IFigure)new Label(toolTip));
        }
        connection.setForegroundColor(color);
        contents.add((IFigure)connection);
        return connection;
    }

    public static BranchFigure createBranchLabelFigure(BranchModel branchModel) {
        Color bgcolor = GraphColorConstants.getBranchColor(branchModel);
        Color fgcolor = GraphColorConstants.FONT_COLOR;
        BranchId branch = branchModel.getBranch();
        String branchName = BranchManager.getBranchName((BranchId)branch);
        Image image = GraphImageConstants.getImage(branch);
        return new BranchFigure(branchName, image, FigureFactory.createBranchNoteFigure(branchModel), bgcolor, fgcolor);
    }

    public static TxFigure createTxFigure(TxModel txModel) {
        Color bgcolor = GraphColorConstants.getBranchColor(txModel.getParentBranchModel());
        Color fgcolor = GraphColorConstants.FONT_COLOR;
        return new TxFigure(txModel.getRevision(), FigureFactory.createTxNoteFigure(txModel), bgcolor, fgcolor);
    }

    public static IFigure createTxNoteFigure(TxModel txModel) {
        TxData txData = txModel.getTxData();
        BranchToken branch = BranchManager.getBranchToken((BranchId)txData.getBranch());
        String title = String.format("Tx: %s Name: %s", txData.getTxId(), branch.getShortName());
        return FigureFactory.createNoteFigure(title, branch.getName(), txData.getAuthor(), txData.getTimeStamp(), txData.getComment());
    }

    public static IFigure createBranchNoteFigure(BranchModel branchModel) {
        BranchToken branch = BranchManager.getBranchToken((BranchId)branchModel.getBranch());
        if (branchModel.getFirstTx() == null) {
            throw new RuntimeException("getFirstTx returns null");
        }
        String title = String.format("Tx: %s Name: %s", branchModel.getFirstTx().getRevision(), branch.getShortName());
        TxData txData = branchModel.getFirstTx().getTxData();
        return FigureFactory.createNoteFigure(title, branch.getName(), txData.getAuthor(), txData.getTimeStamp(), txData.getComment());
    }

    private static IFigure createNoteFigure(String shortName, String name, String author, Date date, String comment) {
        FrameFigure contents = new FrameFigure();
        contents.setLayoutManager((LayoutManager)new GridLayout(2, false));
        contents.setBackgroundColor(GraphColorConstants.BGCOLOR);
        Font labelFont = JFaceResources.getTextFont();
        Font textFont = JFaceResources.getDefaultFont();
        contents.setLabel(" " + shortName + " ");
        contents.setLabelFont(JFaceResources.getTextFont());
        contents.setFont(textFont);
        contents.add((IFigure)FigureFactory.createLabel("Branch", labelFont, GraphColorConstants.FONT_COLOR));
        contents.add((IFigure)FigureFactory.createLabel(name, textFont));
        contents.add((IFigure)FigureFactory.createLabel("Author", labelFont, GraphColorConstants.FONT_COLOR));
        contents.add((IFigure)FigureFactory.createLabel(author, textFont));
        contents.add((IFigure)FigureFactory.createLabel("Date", labelFont, GraphColorConstants.FONT_COLOR));
        contents.add((IFigure)FigureFactory.createLabel(GraphTextFormat.formatDate(date), textFont));
        contents.add((IFigure)FigureFactory.createLabel("Message", labelFont, GraphColorConstants.FONT_COLOR));
        contents.add((IFigure)FigureFactory.createLabel(comment, textFont));
        contents.setPreferredSize(contents.getPreferredSize());
        return contents;
    }

    public static Label createLabel(String text, Font font) {
        return FigureFactory.createLabel(text, font, 1);
    }

    public static Label createLabel(String text, Font font, Color fgColor) {
        return FigureFactory.createLabel(text, font, 1, fgColor);
    }

    public static Label createLabel(String text, Font font, int position) {
        Label label = new Label(text);
        label.setFont(font);
        label.setTextAlignment(position);
        return label;
    }

    public static Label createLabel(String text, Font font, int position, Color fgColor) {
        Label label = new Label(text);
        label.setFont(font);
        label.setTextAlignment(position);
        label.setForegroundColor(fgColor);
        return label;
    }

    public static Label createLabel(String text, Font font, int alignment, Color fgColor, Color bgColor) {
        Label label = new Label(text);
        label.setFont(font);
        label.setTextAlignment(alignment);
        label.setForegroundColor(fgColor);
        label.setBackgroundColor(bgColor);
        return label;
    }
}

