/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.project.IBundleClasspathEntry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IHostDescription;
import org.eclipse.pde.core.project.IPackageExportDescription;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.pde.core.project.IRequiredBundleDescription;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.project.ProjectModifyOperation;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleProjectDescription
implements IBundleProjectDescription {
    private final IProject fProject;
    private IPath fRoot;
    private String fSymbolicName;
    private String fBundleName;
    private String fBundleVendor;
    private IHostDescription fHost;
    private URI fUri;
    private Version fVersion;
    private boolean fSingleton = false;
    private IPath fLocalization = null;
    private IPath fDefaultOuputFolder = null;
    private String[] fEEs;
    private String[] fNatures;
    private IBundleClasspathEntry[] fBundleClasspath = null;
    private String fActivator = null;
    private String fTargetVersion;
    private boolean fIsEquinox = false;
    private boolean fIsExtensionRegistry = false;
    private String fActivationPolicy;
    private IRequiredBundleDescription[] fRequiredBundles;
    private IPackageImportDescription[] fImports;
    private IPackageExportDescription[] fExports;
    private IPath[] fBinIncludes;
    private IBundleProjectService fService;
    private String[] fLaunchShortcuts;
    private String fExportWizard;
    private final Map<String, String> fHeaders = new HashMap<String, String>();
    private Map<?, ?> fReadHeaders = null;

    public BundleProjectDescription(IProject project) throws CoreException {
        this.fProject = project;
        if (project.exists() && project.isOpen()) {
            this.initialize(project);
        }
    }

    IBundleProjectService getBundleProjectService() {
        if (this.fService == null) {
            this.fService = PDECore.getDefault().acquireService(IBundleProjectService.class);
        }
        return this.fService;
    }

    private IBuild getBuildModel(IProject project) {
        IFile buildFile = PDEProject.getBuildProperties(project);
        if (buildFile.exists()) {
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildFile);
            buildModel.load();
            return buildModel.getBuild();
        }
        return null;
    }

    private String getHeaderValue(Map<?, ?> headers, String key) throws CoreException {
        ManifestElement[] elements = this.parseHeader(headers, key);
        if (elements != null && elements.length > 0) {
            return elements[0].getValue();
        }
        return null;
    }

    private ManifestElement[] parseHeader(Map<?, ?> headers, String key) throws CoreException {
        String value = (String)headers.get(key);
        if (value != null) {
            if (value.trim().length() > 0) {
                try {
                    return ManifestElement.parseHeader((String)key, (String)value);
                }
                catch (BundleException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", e.getMessage(), (Throwable)e));
                }
            }
            return new ManifestElement[0];
        }
        return null;
    }

    private void initialize(IProject project) throws CoreException {
        IEclipsePreferences node;
        IContainer root = PDEProject.getBundleRoot(project);
        if (root != project) {
            this.setBundleRoot(root.getProjectRelativePath());
        }
        if ((node = new ProjectScope(project).getNode("org.eclipse.pde.core")) != null) {
            this.setExtensionRegistry(node.getBoolean("pluginProject.extensions", true));
            this.setEquinox(node.getBoolean("pluginProject.equinox", true));
        }
        this.setExportWizardId(PDEProject.getExportWizard(project));
        this.setLaunchShortcuts(PDEProject.getLaunchShortcuts(project));
        this.setLocationURI(project.getDescription().getLocationURI());
        this.setNatureIds(project.getDescription().getNatureIds());
        IFile manifest = PDEProject.getManifest(project);
        if (manifest.exists()) {
            String[] tokens;
            IBuildEntry entry;
            IPluginBase base;
            String tv;
            String lazy;
            String value;
            ManifestElement[] elements;
            IJavaProject jp;
            Map headers;
            try {
                this.fReadHeaders = headers = ManifestElement.parseBundleManifest((InputStream)manifest.getContents(), null);
            }
            catch (IOException | BundleException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", e.getMessage(), e));
            }
            this.setActivator(this.getHeaderValue(headers, "Bundle-Activator"));
            this.setBundleName(this.getHeaderValue(headers, "Bundle-Name"));
            this.setBundleVendor(this.getHeaderValue(headers, "Bundle-Vendor"));
            String version = this.getHeaderValue(headers, "Bundle-Version");
            if (version != null) {
                this.setBundleVersion(new Version(version));
            }
            if ((jp = JavaCore.create((IProject)project)).exists()) {
                this.setDefaultOutputFolder(jp.getOutputLocation().removeFirstSegments(1));
            }
            if ((elements = this.parseHeader(headers, "Fragment-Host")) != null && elements.length > 0) {
                this.setHost(this.getBundleProjectService().newHost(elements[0].getValue(), this.getRange(elements[0].getAttribute("bundle-version"))));
            }
            if ((value = this.getHeaderValue(headers, "Bundle-Localization")) != null) {
                this.setLocalization((IPath)new Path(value));
            }
            if ((elements = this.parseHeader(headers, "Bundle-RequiredExecutionEnvironment")) != null && elements.length > 0) {
                String[] keys = new String[elements.length];
                int i = 0;
                while (i < elements.length) {
                    keys[i] = elements[i].getValue();
                    ++i;
                }
                this.setExecutionEnvironments(keys);
            }
            IBuild build = this.getBuildModel(project);
            elements = this.parseHeader(headers, "Bundle-ClassPath");
            IBundleClasspathEntry[] classpath = null;
            if (elements != null && elements.length > 0) {
                ArrayList collect = new ArrayList();
                ManifestElement[] manifestElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    ManifestElement element = manifestElementArray[n2];
                    String libName = element.getValue();
                    IBundleClasspathEntry[] entries = this.getClasspathEntries(project, build, libName);
                    if (entries != null) {
                        Collections.addAll(collect, entries);
                    }
                    ++n2;
                }
                classpath = collect.toArray(new IBundleClasspathEntry[collect.size()]);
            } else if (elements == null) {
                classpath = this.getClasspathEntries(project, build, ".");
            }
            this.setBundleClasspath(classpath);
            elements = this.parseHeader(headers, "Bundle-SymbolicName");
            if (elements != null && elements.length > 0) {
                this.setSymbolicName(elements[0].getValue());
                String directive = elements[0].getDirective("singleton");
                if (directive == null) {
                    directive = elements[0].getAttribute("singleton");
                }
                this.setSingleton("true".equals(directive));
            }
            if ((elements = this.parseHeader(headers, "Import-Package")) != null) {
                if (elements.length > 0) {
                    IPackageImportDescription[] imports = new IPackageImportDescription[elements.length];
                    int i = 0;
                    while (i < elements.length) {
                        boolean optional = "optional".equals(elements[i].getDirective("resolution")) || "true".equals(elements[i].getAttribute("optional"));
                        String pv = elements[i].getAttribute("specification-version");
                        if (pv == null) {
                            pv = elements[i].getAttribute("version");
                        }
                        imports[i] = this.getBundleProjectService().newPackageImport(elements[i].getValue(), this.getRange(pv), optional);
                        ++i;
                    }
                    this.setPackageImports(imports);
                } else {
                    this.setHeader("Import-Package", "");
                }
            }
            if ((elements = this.parseHeader(headers, "Export-Package")) != null && elements.length > 0) {
                IPackageExportDescription[] exports = new IPackageExportDescription[elements.length];
                int i = 0;
                while (i < elements.length) {
                    ManifestElement exp = elements[i];
                    String pv = exp.getAttribute("specification-version");
                    if (pv == null) {
                        pv = exp.getAttribute("version");
                    }
                    String directive = exp.getDirective("x-friends");
                    boolean internal = "true".equals(exp.getDirective("x-internal")) || directive != null;
                    String[] friends = null;
                    if (directive != null) {
                        friends = ManifestElement.getArrayFromList((String)directive);
                    }
                    exports[i] = this.getBundleProjectService().newPackageExport(exp.getValue(), this.getVersion(pv), !internal, friends);
                    ++i;
                }
                this.setPackageExports(exports);
            }
            if ((elements = this.parseHeader(headers, "Require-Bundle")) != null && elements.length > 0) {
                IRequiredBundleDescription[] req = new IRequiredBundleDescription[elements.length];
                int i = 0;
                while (i < elements.length) {
                    ManifestElement rb = elements[i];
                    boolean reexport = "reexport".equals(rb.getDirective("visibility")) || "true".equals(rb.getAttribute("reprovide"));
                    boolean optional = "optional".equals(rb.getDirective("resolution")) || "true".equals(rb.getAttribute("optional"));
                    req[i] = this.getBundleProjectService().newRequiredBundle(rb.getValue(), this.getRange(rb.getAttribute("bundle-version")), optional, reexport);
                    ++i;
                }
                this.setRequiredBundles(req);
            }
            if ((lazy = this.getHeaderValue(headers, "Eclipse-AutoStart")) == null && (lazy = this.getHeaderValue(headers, "Eclipse-LazyStart")) == null) {
                this.setActivationPolicy(this.getHeaderValue(headers, "Bundle-ActivationPolicy"));
            }
            if ("true".equals(lazy)) {
                this.setActivationPolicy("lazy");
            }
            String latest = TargetPlatformHelper.getTargetVersionString();
            IPluginModelBase model = PluginRegistry.findModel(project);
            if (model != null && !(tv = TargetPlatformHelper.getTargetVersionForSchemaVersion((base = model.getPluginBase()).getSchemaVersion())).equals(latest)) {
                this.setTargetVersion(tv);
            }
            if (build != null && (entry = build.getEntry("bin.includes")) != null && (tokens = entry.getTokens()) != null && tokens.length > 0) {
                ArrayList strings = new ArrayList();
                Collections.addAll(strings, tokens);
                strings.remove("META-INF/");
                String[] names = ProjectModifyOperation.getLibraryNames(this);
                if (names != null) {
                    String[] stringArray = names;
                    int n = names.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String name = stringArray[n3];
                        strings.remove(name);
                        Path path = new Path(name);
                        if (path.getFileExtension() == null) {
                            strings.remove(String.valueOf(name) + "/");
                        }
                        ++n3;
                    }
                }
                if (!strings.isEmpty()) {
                    IPath[] paths = new IPath[strings.size()];
                    int i = 0;
                    while (i < strings.size()) {
                        paths[i] = new Path((String)strings.get(i));
                        ++i;
                    }
                    this.setBinIncludes(paths);
                }
            }
        }
    }

    private IBundleClasspathEntry[] getClasspathEntries(IProject project, IBuild build, String libraryName) throws CoreException {
        if (build != null) {
            IBuildEntry entry = build.getEntry("source." + libraryName);
            if (entry == null) {
                entry = build.getEntry("output." + libraryName);
                if (entry == null) {
                    return new IBundleClasspathEntry[]{this.getBundleProjectService().newBundleClasspathEntry(null, null, (IPath)new Path(libraryName))};
                }
                return this.getClasspathEntries(project, entry, true);
            }
            return this.getClasspathEntries(project, entry, false);
        }
        return null;
    }

    private IBundleClasspathEntry[] getClasspathEntries(IProject project, IBuildEntry entry, boolean binary) throws CoreException {
        String[] tokens = entry.getTokens();
        Path lib = null;
        lib = binary ? new Path(entry.getName().substring("output.".length())) : new Path(entry.getName().substring("source.".length()));
        if (tokens != null && tokens.length > 0) {
            IBundleClasspathEntry[] bces = new IBundleClasspathEntry[tokens.length];
            int i = 0;
            while (i < tokens.length) {
                Path path = new Path(tokens[i]);
                IBundleClasspathEntry spec = null;
                if (binary) {
                    spec = this.getBundleProjectService().newBundleClasspathEntry(null, (IPath)path, (IPath)lib);
                } else {
                    IJavaProject jp = JavaCore.create((IProject)project);
                    IPath output = null;
                    if (jp.exists()) {
                        IClasspathEntry[] rawClasspath;
                        IClasspathEntry[] iClasspathEntryArray = rawClasspath = jp.getRawClasspath();
                        int n = rawClasspath.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IClasspathEntry cpe = iClasspathEntryArray[n2];
                            if (cpe.getEntryKind() == 3 && cpe.getPath().removeFirstSegments(1).equals((Object)path)) {
                                output = cpe.getOutputLocation();
                                if (output == null) break;
                                output = output.removeFirstSegments(1);
                                break;
                            }
                            ++n2;
                        }
                    }
                    spec = this.getBundleProjectService().newBundleClasspathEntry((IPath)path, output, (IPath)lib);
                }
                bces[i] = spec;
                ++i;
            }
            return bces;
        }
        return null;
    }

    private VersionRange getRange(String version) {
        if (version != null) {
            return new VersionRange(version);
        }
        return null;
    }

    private Version getVersion(String version) {
        if (version != null) {
            return new Version(version);
        }
        return null;
    }

    @Override
    public void apply(IProgressMonitor monitor) throws CoreException {
        ProjectModifyOperation operation = new ProjectModifyOperation();
        operation.execute(monitor, this);
        this.fService = null;
    }

    @Override
    public void setSymbolicName(String name) {
        this.fSymbolicName = name;
    }

    @Override
    public String getSymbolicName() {
        return this.fSymbolicName;
    }

    @Override
    public void setLocationURI(URI location) {
        this.fUri = location;
    }

    @Override
    public URI getLocationURI() {
        return this.fUri;
    }

    @Override
    public void setBundleName(String name) {
        this.fBundleName = name;
    }

    @Override
    public String getBundleName() {
        return this.fBundleName;
    }

    @Override
    public void setBundleVendor(String name) {
        this.fBundleVendor = name;
    }

    @Override
    public String getBundleVendor() {
        return this.fBundleVendor;
    }

    @Override
    public void setBundleVersion(Version version) {
        this.fVersion = version;
    }

    @Override
    public Version getBundleVersion() {
        return this.fVersion;
    }

    @Override
    public void setSingleton(boolean singleton) {
        this.fSingleton = singleton;
    }

    @Override
    public boolean isSingleton() {
        return this.fSingleton;
    }

    @Override
    public void setLocalization(IPath path) {
        this.fLocalization = path;
    }

    @Override
    public IPath getLocalization() {
        return this.fLocalization;
    }

    @Override
    public String[] getNatureIds() {
        if (this.fNatures == null) {
            return new String[0];
        }
        String[] copy = new String[this.fNatures.length];
        System.arraycopy(this.fNatures, 0, copy, 0, this.fNatures.length);
        return copy;
    }

    @Override
    public void setNatureIds(String[] natures) {
        String[] copy = null;
        if (natures != null) {
            copy = new String[natures.length];
            System.arraycopy(natures, 0, copy, 0, natures.length);
        }
        this.fNatures = copy;
    }

    @Override
    public boolean hasNature(String natureId) {
        if (this.fNatures != null) {
            String[] stringArray = this.fNatures;
            int n = this.fNatures.length;
            int n2 = 0;
            while (n2 < n) {
                String nature = stringArray[n2];
                if (nature.equals(natureId)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public void setHost(IHostDescription host) {
        this.fHost = host;
    }

    @Override
    public IHostDescription getHost() {
        return this.fHost;
    }

    @Override
    public void setDefaultOutputFolder(IPath output) {
        this.fDefaultOuputFolder = output;
    }

    @Override
    public IPath getDefaultOutputFolder() {
        return this.fDefaultOuputFolder;
    }

    @Override
    public void setExecutionEnvironments(String[] environments) {
        this.fEEs = environments;
    }

    @Override
    public String[] getExecutionEnvironments() {
        return this.fEEs;
    }

    @Override
    public IBundleClasspathEntry[] getBundleClasspath() {
        return this.fBundleClasspath;
    }

    @Override
    public void setActivator(String className) {
        this.fActivator = className;
    }

    @Override
    public String getActivator() {
        return this.fActivator;
    }

    @Override
    public void setTargetVersion(String version) {
        this.fTargetVersion = version;
    }

    @Override
    public String getTargetVersion() {
        return this.fTargetVersion;
    }

    @Override
    public void setEquinox(boolean equinox) {
        this.fIsEquinox = equinox;
    }

    @Override
    public boolean isEquinox() {
        return this.fIsEquinox;
    }

    @Override
    public void setRequiredBundles(IRequiredBundleDescription[] bundles) {
        this.fRequiredBundles = bundles;
    }

    @Override
    public IRequiredBundleDescription[] getRequiredBundles() {
        return this.fRequiredBundles;
    }

    @Override
    public void setPackageImports(IPackageImportDescription[] imports) {
        this.fImports = imports;
    }

    @Override
    public IPackageImportDescription[] getPackageImports() {
        return this.fImports;
    }

    @Override
    public void setPackageExports(IPackageExportDescription[] exports) {
        this.fExports = exports;
    }

    @Override
    public IPackageExportDescription[] getPackageExports() {
        return this.fExports;
    }

    @Override
    public IProject getProject() {
        return this.fProject;
    }

    @Override
    @Deprecated
    public void setBundleClassath(IBundleClasspathEntry[] entries) {
        this.setBundleClasspath(entries);
    }

    @Override
    public void setBundleClasspath(IBundleClasspathEntry[] entries) {
        this.fBundleClasspath = entries;
    }

    @Override
    public void setBinIncludes(IPath[] paths) {
        this.fBinIncludes = paths;
    }

    @Override
    public IPath[] getBinIncludes() {
        return this.fBinIncludes;
    }

    @Override
    public void setBundleRoot(IPath path) {
        this.fRoot = path;
    }

    @Override
    public IPath getBundleRoot() {
        return this.fRoot;
    }

    @Override
    public boolean isExtensionRegistry() {
        return this.fIsExtensionRegistry;
    }

    @Override
    public void setExtensionRegistry(boolean supportExtensions) {
        this.fIsExtensionRegistry = supportExtensions;
    }

    @Override
    public String[] getLaunchShortcuts() {
        return this.fLaunchShortcuts;
    }

    @Override
    public void setLaunchShortcuts(String[] ids) {
        this.fLaunchShortcuts = ids;
    }

    @Override
    public String getExportWizardId() {
        return this.fExportWizard;
    }

    @Override
    public void setExportWizardId(String id) {
        this.fExportWizard = id;
    }

    @Override
    public void setActivationPolicy(String policy) {
        this.fActivationPolicy = "lazy".equals(policy) ? policy : null;
    }

    @Override
    public String getActivationPolicy() {
        return this.fActivationPolicy;
    }

    @Override
    public void setHeader(String header, String value) {
        this.fHeaders.put(header, value);
    }

    @Override
    public String getHeader(String header) {
        if (this.fHeaders.containsKey(header)) {
            return this.fHeaders.get(header);
        }
        if (this.fReadHeaders != null && this.fReadHeaders.containsKey(header)) {
            String value = (String)this.fReadHeaders.get(header);
            if (value == null) {
                return "";
            }
            return value;
        }
        return null;
    }

    Map<String, String> getExtraHeaders() {
        return this.fHeaders;
    }
}

