/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.wizards.tools.ConvertProjectToPluginOperation;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ConvertedProjectsPage
extends WizardPage {
    private CheckboxTableViewer fProjectViewer;
    private Button fSelectButton;
    private Button fDeselectButton;
    private Button fApiAnalysisButton;
    private static final String S_API_ANALYSIS = "apiAnalysis";
    private IProject[] fInitialSelection;
    private IProject[] fAllUnconvertedProjects;

    public ConvertedProjectsPage(IProject[] projects, Vector<?> initialSelection) {
        super("convertedProjects");
        this.setTitle(PDEUIMessages.ConvertedProjectWizard_title);
        this.setDescription(PDEUIMessages.ConvertedProjectWizard_desc);
        this.fAllUnconvertedProjects = projects != null ? projects : new IProject[]{};
        this.fInitialSelection = initialSelection.toArray(new IProject[initialSelection.size()]);
    }

    public void createControl(Composite parent) {
        Composite container = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createLabel(container, PDEUIMessages.ConvertedProjectWizard_projectList, 2);
        this.fProjectViewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2048);
        this.fProjectViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fProjectViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.fProjectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.fProjectViewer.setInput((Object)this.fAllUnconvertedProjects);
        this.fProjectViewer.setCheckedElements((Object[])this.fInitialSelection);
        this.fProjectViewer.addCheckStateListener(event -> this.updateButtons());
        Composite buttonContainer = SWTFactory.createComposite(container, 1, 1, 1040, 0, 0);
        this.fSelectButton = SWTFactory.createPushButton(buttonContainer, PDEUIMessages.ConvertedProjectsPage_SelectAll, null);
        this.fSelectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fProjectViewer.setAllChecked(true);
            this.updateButtons();
        }));
        this.fDeselectButton = SWTFactory.createPushButton(buttonContainer, PDEUIMessages.ConvertedProjectsPage_DeselectAll, null);
        this.fDeselectButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.fProjectViewer.setAllChecked(false);
            this.updateButtons();
        }));
        this.updateButtons();
        this.fApiAnalysisButton = SWTFactory.createCheckButton(container, PDEUIMessages.PluginContentPage_enable_api_analysis, null, false, 2);
        this.loadSettings();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.converted_projects");
    }

    private void updateButtons() {
        int count = this.fProjectViewer.getCheckedElements().length;
        this.fSelectButton.setEnabled(count < this.fAllUnconvertedProjects.length);
        this.fDeselectButton.setEnabled(count > 0);
    }

    private void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(S_API_ANALYSIS, Boolean.toString(this.fApiAnalysisButton.getSelection()));
        }
    }

    private void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.fApiAnalysisButton.setSelection(settings.getBoolean(S_API_ANALYSIS));
        }
    }

    public boolean finish() {
        this.storeSettings();
        Object[] selected = this.fProjectViewer.getCheckedElements();
        IProject[] projects = new IProject[selected.length];
        int i = 0;
        while (i < selected.length) {
            projects[i] = (IProject)selected[i];
            ++i;
        }
        try {
            ConvertProjectToPluginOperation convertOperation = new ConvertProjectToPluginOperation(projects, this.fApiAnalysisButton.getSelection());
            this.getContainer().run(false, true, (IRunnableWithProgress)convertOperation);
        }
        catch (InterruptedException | InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    public class ProjectLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }

        public String getText(Object element) {
            return ((IProject)element).getName();
        }
    }
}

