/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.icteam.reqif.dialogs;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ExportReqIfDialog
extends TitleAreaDialog {
    private Combo fileText;
    private Combo fileTypeCombo;
    private Button browseButton;
    private String sDirName = "";
    private String sFileName = "";

    public ExportReqIfDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle("Export Requirments into REQIF format");
        parent.getShell().setText("Export Requirments");
        this.getButton(0).setEnabled(false);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        fileSelectionArea.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        fileSelectionArea.setLayoutData((Object)layoutData);
        Label label1 = new Label(fileSelectionArea, 0);
        label1.setText("Name");
        this.fileText = new Combo(fileSelectionArea, 0);
        GridData gridData1 = new GridData(768);
        this.fileText.setLayoutData((Object)gridData1);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportReqIfDialog.this.validateCombo();
            }
        });
        Label dummyLabel = new Label(fileSelectionArea, 0);
        dummyLabel.setText("");
        Label label2 = new Label(fileSelectionArea, 0);
        label2.setText("To Directory:");
        this.fileTypeCombo = new Combo(fileSelectionArea, 0);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.fileTypeCombo.setLayoutData((Object)gridData);
        this.fileTypeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportReqIfDialog.this.validateCombo();
            }
        });
        this.browseButton = new Button(fileSelectionArea, 8);
        this.browseButton.setText("Browse");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dlg = new DirectoryDialog(Displays.getActiveShell());
                dlg.setText("Select the export directory");
                dlg.setMessage("Select the export directory");
                String dir = dlg.open();
                if (dir != null) {
                    ExportReqIfDialog.this.fileTypeCombo.setText(dir);
                }
                ExportReqIfDialog.this.validateCombo();
            }
        });
        return fileSelectionArea;
    }

    private void validateCombo() {
        boolean isPageComplete = true;
        String fileNameString = this.fileText.getText();
        if (fileNameString == null || fileNameString.length() == 0) {
            this.setMessage("Please enter a fileName");
            isPageComplete = false;
            if (this.validateString(fileNameString)) {
                this.setMessage("Please enter a valid fileName");
                isPageComplete = false;
            } else {
                isPageComplete = true;
            }
        } else if (isPageComplete) {
            String selectedFile = this.fileTypeCombo.getText();
            if (selectedFile != null && !"".equals(selectedFile)) {
                File f = new File(selectedFile);
                if (f.exists() && f.isDirectory()) {
                    this.setMessage(null);
                } else {
                    this.setMessage("Directory does not exist");
                    isPageComplete = false;
                }
            } else {
                this.setMessage("Select the export directory");
                isPageComplete = false;
            }
        }
        if (isPageComplete) {
            this.setMessage("");
        }
        this.getButton(0).setEnabled(isPageComplete);
    }

    private boolean validateString(String selectedPrj) {
        char[] charArray = selectedPrj.toCharArray();
        boolean isValid = Character.isJavaIdentifierStart(charArray[0]);
        if (isValid) {
            int i = 1;
            while (i < charArray.length) {
                if (!Character.isJavaIdentifierPart(charArray[i])) {
                    return false;
                }
                ++i;
            }
        }
        return isValid;
    }

    public String getDirName() {
        return this.sDirName;
    }

    public String getFileName() {
        return this.sFileName;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    private void saveInput() {
        this.sFileName = this.fileText.getText();
        this.sDirName = this.fileTypeCombo.getText();
    }
}

