/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.enums;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.jdk.core.type.BaseId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.IdSerializer;

@JsonSerialize(using=IdSerializer.class)
public interface TxCurrent
extends Id {
    public static final TxCurrent SENTINEL = TxCurrent.internalCreate(Id.SENTINEL);
    public static final TxCurrent NOT_CURRENT = TxCurrent.internalCreate(0L);
    public static final TxCurrent CURRENT = TxCurrent.internalCreate(1L);
    public static final TxCurrent DELETED = TxCurrent.internalCreate(2L);
    public static final TxCurrent ARTIFACT_DELETED = TxCurrent.internalCreate(3L);

    public static TxCurrent valueOf(int id) {
        switch (id) {
            case 0: {
                return NOT_CURRENT;
            }
            case 1: {
                return CURRENT;
            }
            case 2: {
                return DELETED;
            }
            case 3: {
                return ARTIFACT_DELETED;
            }
        }
        return SENTINEL;
    }

    public static TxCurrent internalCreate(Long id) {
        final class TxChangeImpl
        extends BaseId
        implements TxCurrent,
        Comparable<TxCurrent> {
            public TxChangeImpl(Long id) {
                super(id);
            }

            @Override
            public int compareTo(TxCurrent o) {
                return this.getId().compareTo(o.getId());
            }
        }
        return new TxChangeImpl(id);
    }

    public static TxCurrent getCurrent(ModificationType type) {
        TxCurrent txChange = type == ModificationType.DELETED ? DELETED : (type == ModificationType.ARTIFACT_DELETED ? ARTIFACT_DELETED : CURRENT);
        return txChange;
    }

    default public boolean isDeleted() {
        return this == DELETED || this == ARTIFACT_DELETED;
    }

    default public boolean isCurrent() {
        return this != NOT_CURRENT;
    }
}

