/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.core.UriInfo;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.text.change.ChangeSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.IOInputThread;
import org.eclipse.osee.framework.jdk.core.util.io.IOOutputThread;
import org.eclipse.osee.framework.jdk.core.util.io.InputBufferThread;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;

public final class Lib {
    private static final Random RANDOM = new Random();
    private static final String INVALID_URI_CHARACTERS_REGEX = "[<>]";
    @Deprecated
    public static final Runtime runtime = Runtime.getRuntime();
    public static final String jarPath = Lib.getJarPath(Lib.class);
    public static final String basePath = Lib.getBasePath();
    public static final String lineSeparator = System.getProperty("line.separator");
    public static final Pattern numberListPattern = Pattern.compile("\\d+");
    private static final double EPSILON = 1.0E-7;

    public static String getFileAtsClass(String filename, Class<?> clazz) {
        URL url = clazz.getResource(filename);
        File file = new File(url.getPath());
        try {
            return Lib.fileToString(file);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static String toFirstCharUpperCase(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = str.toCharArray();
        chars[0] = Character.toUpperCase(str.charAt(0));
        return new String(chars);
    }

    public static int numOccurances(String str, String regex) {
        int x = 0;
        Matcher m = Pattern.compile(regex).matcher(str);
        while (m.find()) {
            ++x;
        }
        return x;
    }

    public static String exceptionToString(Throwable ex) {
        StringBuilder sb = new StringBuilder();
        Lib.exceptionToString(ex, sb);
        return sb.toString();
    }

    public static boolean validateEmail(String toValidate) {
        Pattern pattern = Pattern.compile("^[a-z0-9\\._-]+@([a-z0-9][a-z0-9-]*[a-z0-9]\\.)+([a-z]+\\.)?([a-z]+)$", 2);
        Matcher matcher = pattern.matcher(toValidate);
        return matcher.find();
    }

    private static void exceptionToString(Throwable ex, StringBuilder sb) {
        if (ex == null) {
            sb.append("Exception == null; can't display stack");
            return;
        }
        sb.append(ex.getClass().getName());
        sb.append("\n");
        if (ex.getMessage() != null && !ex.getMessage().isEmpty()) {
            sb.append("   \"");
            sb.append(ex.getMessage());
            sb.append("\"\n");
        }
        StackTraceElement[] st = ex.getStackTrace();
        int i = 0;
        while (i < st.length) {
            StackTraceElement ste = st[i];
            sb.append("   at " + ste.toString() + "\n");
            ++i;
        }
        Throwable cause = ex.getCause();
        if (cause != null) {
            sb.append("   caused by ");
            Lib.exceptionToString(cause, sb);
        }
    }

    public static String changeExtension(String str, String newExt) {
        int pos = str.lastIndexOf(46);
        if (pos == -1) {
            return String.valueOf(str) + "." + newExt;
        }
        return String.valueOf(str.substring(0, pos + 1)) + newExt;
    }

    public static String changeExtension(String str, String oldExt, String newExt) {
        int pos = str.lastIndexOf(oldExt);
        if (pos == -1) {
            return String.valueOf(str) + "." + newExt;
        }
        return String.valueOf(str.substring(0, pos)) + newExt;
    }

    public static boolean moveBack(ArrayList<Object> list, Object obj) {
        int index;
        if (list.contains(obj) && (index = list.indexOf(obj)) > 0) {
            list.remove(index);
            list.add(index - 1, obj);
            return true;
        }
        return false;
    }

    public static boolean moveForward(ArrayList<Object> list, Object obj) {
        int index;
        int size = list.size();
        if (list.contains(obj) && (index = list.indexOf(obj)) < size - 1) {
            list.remove(index);
            list.add(index + 1, obj);
            return true;
        }
        return false;
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        File[] files = source.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    File dir = new File(destination, files[i].getName());
                    dir.mkdir();
                    Lib.copyDirectory(files[i], dir);
                } else {
                    Lib.copyFile(files[i], destination);
                }
                ++i;
            }
        }
    }

    public static String exceptionToString(Exception ex) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ex.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileChannel in = new FileInputStream(source).getChannel();
        try {
            FileChannel out;
            if (destination.isDirectory()) {
                out = new FileOutputStream(new File(destination, source.getName())).getChannel();
            } else {
                if (destination.exists()) {
                    destination.delete();
                }
                out = new FileOutputStream(destination).getChannel();
            }
            try {
                long position = 0L;
                long size = in.size();
                while (position < size) {
                    position += in.transferTo(position, size, out);
                }
            }
            finally {
                Lib.close(out);
            }
        }
        finally {
            Lib.close(in);
        }
    }

    public static void copyFiles(File source, File destination) throws IOException {
        Lib.copyFiles(source, null, destination);
    }

    public static void copyFiles(File source, FilenameFilter filter, File destination) throws IOException {
        File[] files = source.listFiles(filter);
        if (!source.exists()) {
            throw new IllegalArgumentException("the directory " + source + " does not exist.");
        }
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    Lib.copyFile(files[i], destination);
                }
                ++i;
            }
        }
    }

    public static void deleteDir(File directory) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Lib.deleteDir(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        directory.delete();
    }

    public static void deleteContents(File directory) {
        Lib.deleteContents(directory, null);
    }

    public static void deleteContents(File directory, FilenameFilter filter) {
        File[] files = directory.listFiles(filter);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Lib.deleteContents(files[i]);
                }
                files[i].delete();
                ++i;
            }
        }
    }

    public static boolean deleteFileAndEmptyParents(String stopAt, File file) {
        boolean result = true;
        if (file != null) {
            if (file.isDirectory()) {
                if (file.list().length == 0) {
                    File parent = file.getParentFile();
                    if (parent != null && !parent.getAbsolutePath().equals(stopAt)) {
                        result &= Lib.deleteFileAndEmptyParents(stopAt, parent);
                    }
                    result &= file.delete();
                }
            } else {
                File parent = file.getParentFile();
                if (parent != null && !parent.getAbsolutePath().equals(stopAt)) {
                    result &= Lib.deleteFileAndEmptyParents(stopAt, parent);
                }
                result &= file.delete();
            }
        }
        return result;
    }

    public static void emptyDirectory(File directory) {
        File[] children = directory.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                if (child.isDirectory()) {
                    Lib.emptyDirectory(child);
                } else {
                    child.delete();
                }
                ++n2;
            }
        }
    }

    public static void inputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream was null");
        }
        if (outputStream == null) {
            throw new IllegalArgumentException("outputStream was null");
        }
        byte[] buf = new byte[10000];
        int count = -1;
        while ((count = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, count);
        }
    }

    public static int getMatcherCount(Pattern p, String str) {
        return Lib.getMatcherCount(p.matcher(str));
    }

    public static int getMatcherCount(Matcher m) {
        int count = 0;
        while (m.find()) {
            ++count;
        }
        return count;
    }

    public static String inputStreamToString(InputStream in) throws IOException {
        return Lib.inputStreamToChangeSet(in).toString();
    }

    public static ChangeSet inputStreamToChangeSet(InputStream in, String charset) throws IOException {
        InputStreamReader reader = new InputStreamReader(in, charset);
        try {
            ChangeSet set = new ChangeSet();
            char[] chars = new char[8000];
            int readCount = 0;
            while ((readCount = reader.read(chars)) != -1) {
                set.insertBefore(0, chars, 0, readCount, true);
            }
            ChangeSet changeSet = set;
            return changeSet;
        }
        finally {
            Lib.close(reader);
        }
    }

    public static StringBuilder inputStreamToStringBuilder(InputStream inputStream, String charset, StringBuilder builder) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        try {
            char[] chars = new char[8000];
            int readCount = 0;
            while ((readCount = reader.read(chars)) != -1) {
                builder.append(chars, 0, readCount);
            }
            StringBuilder stringBuilder = builder;
            return stringBuilder;
        }
        finally {
            Lib.close(reader);
        }
    }

    public static StringBuilder inputStreamToStringBuilder(InputStream inputStream, StringBuilder builder) throws IOException {
        return Lib.inputStreamToStringBuilder(inputStream, "UTF-8", builder);
    }

    public static ChangeSet inputStreamToChangeSet(InputStream in) throws IOException {
        return Lib.inputStreamToChangeSet(in, "UTF-8");
    }

    public static byte[] inputStreamToBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            Lib.inputStreamToOutputStream(inputStream, outputStream);
        }
        finally {
            Lib.close(inputStream);
        }
        return outputStream.toByteArray();
    }

    public static void inputStreamToFile(InputStream inputStream, File outFile) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(outFile);
            Lib.inputStreamToOutputStream(inputStream, outputStream);
        }
        finally {
            Lib.close(inputStream);
            Lib.close(outputStream);
        }
    }

    public static CharBuffer inputStreamToCharBuffer(InputStream in) throws IOException {
        return CharBuffer.wrap(Lib.inputStreamToChangeSet(in).toCharArray());
    }

    public static InputStream stringToInputStream(String value) throws UnsupportedEncodingException {
        ByteArrayInputStream stream = null;
        if (value != null) {
            String data = value.trim();
            stream = new ByteArrayInputStream(data.getBytes("UTF-8"));
        }
        return stream;
    }

    public static InputStream byteBufferToInputStream(final ByteBuffer byteBuffer) {
        return new InputStream(){

            @Override
            public synchronized int read() {
                if (!byteBuffer.hasRemaining()) {
                    return -1;
                }
                return byteBuffer.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) {
                if (off != (len = Math.min(len, byteBuffer.remaining()))) {
                    byteBuffer.get(bytes, off, len);
                } else {
                    len = -1;
                }
                return len;
            }

            @Override
            public synchronized void reset() {
                byteBuffer.rewind();
            }
        };
    }

    public static OutputStream byteBufferToOutputStream(final ByteBuffer byteBuffer) {
        return new OutputStream(){

            @Override
            public synchronized void write(int b) {
                byteBuffer.put((byte)b);
            }

            @Override
            public synchronized void write(byte[] bytes, int off, int len) {
                byteBuffer.put(bytes, off, len);
            }
        };
    }

    public static String fileToString(File file) throws IOException {
        return new String(Lib.fileToChars(file, "UTF-8"));
    }

    public static String fileToString(Class<?> clazz, String relativePath) throws IOException {
        InputStream stream = null;
        try {
            stream = clazz.getResourceAsStream(relativePath);
            String string = Lib.inputStreamToString(stream);
            return string;
        }
        finally {
            Lib.close(stream);
        }
    }

    public static byte[] fileToBytes(File file) throws IOException {
        byte[] bytes = new byte[(int)file.length()];
        try (FileInputStream inputStream = null;){
            inputStream = new FileInputStream(file);
            ((InputStream)inputStream).read(bytes);
        }
        return bytes;
    }

    public static char[] fileToChars(File file, char[] buf) throws IOException {
        FileReader inputReader = new FileReader(file);
        try {
            int size = (int)file.length();
            if (buf == null) {
                buf = new char[size];
            } else if (size > buf.length) {
                buf = null;
                System.gc();
                buf = new char[size];
            }
            inputReader.read(buf);
        }
        finally {
            Lib.close(inputReader);
        }
        return buf;
    }

    public static CharBuffer fileToCharBuffer(File file) throws IOException {
        return Lib.fileToCharBuffer(file, "UTF-8");
    }

    public static CharBuffer fileToCharBuffer(File file, String charset) throws IOException {
        return CharBuffer.wrap(Lib.fileToChars(file, charset));
    }

    public static char[] fileToChars(File file, String charset) throws IOException {
        return Lib.inputStreamToChangeSet(new FileInputStream(file), charset).toCharArray();
    }

    public static String fillString(char c, int n) {
        char[] chars = new char[n];
        int i = 0;
        while (i < n) {
            chars[i++] = c;
        }
        return new String(chars);
    }

    public static String getExtension(String filepath) {
        String toReturn = "";
        if (Strings.isValid(filepath)) {
            String toProcess = filepath.trim();
            String[] pathsArray = (toProcess = toProcess.replaceAll("\\\\", "/")).split("/");
            if (pathsArray.length > 0) {
                int index;
                String fileName = pathsArray[0];
                if (pathsArray.length > 0) {
                    fileName = pathsArray[pathsArray.length - 1];
                }
                if ((index = fileName.lastIndexOf(46)) >= 0 && index + 1 < fileName.length()) {
                    toReturn = fileName.substring(index + 1);
                }
            }
        }
        return toReturn;
    }

    public static Thread[] handleMinicomProcess(Process proc, Writer output, Reader input) {
        IOOutputThread errThread = new IOOutputThread(output, new BufferedReader(new InputStreamReader(proc.getErrorStream())));
        InputBufferThread outThread = new InputBufferThread(proc.getInputStream());
        errThread.setName("err");
        outThread.setName("out");
        errThread.start();
        outThread.start();
        if (input != null) {
            IOInputThread inThread = new IOInputThread(input, new BufferedWriter(new OutputStreamWriter(proc.getOutputStream())));
            inThread.setName("in");
            inThread.start();
            return new Thread[]{errThread, outThread, inThread};
        }
        return new Thread[]{errThread, outThread};
    }

    public static Thread[] handleProcessNoWait(Process proc, Writer output) {
        return Lib.handleProcessNoWait(proc, output, output, null);
    }

    public static Thread[] handleProcessNoWait(Process proc, Writer output, Writer errorWriter, Reader reader) {
        return Lib.handleProcessNoWait(proc, output, errorWriter, reader, "err", "out");
    }

    public static Thread[] handleProcessNoWait(Process proc, Writer outputWriter, Writer errorWriter, Reader reader, String errName, String outName) {
        IOOutputThread errThread = new IOOutputThread(errorWriter, new BufferedReader(new InputStreamReader(proc.getErrorStream())));
        IOOutputThread outThread = new IOOutputThread(outputWriter, new BufferedReader(new InputStreamReader(proc.getInputStream())));
        errThread.setName(errName);
        outThread.setName(outName);
        errThread.start();
        outThread.start();
        if (reader != null) {
            IOInputThread inThread = new IOInputThread(reader, new BufferedWriter(new OutputStreamWriter(proc.getOutputStream())));
            inThread.setName("in");
            inThread.start();
            return new Thread[]{errThread, outThread, inThread};
        }
        return new Thread[]{errThread, outThread};
    }

    public static void makeDirClean(File directory) {
        if (directory.exists()) {
            Lib.deleteContents(directory);
        } else {
            directory.mkdir();
        }
    }

    public static void moveFiles(File source, File destination) {
        Lib.moveFiles(source, null, destination);
    }

    public static void moveFiles(File source, FilenameFilter filter, File destination) {
        File[] files = source.listFiles(filter);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    files[i].renameTo(new File(destination, files[i].getName()));
                }
                ++i;
            }
        }
    }

    public static String getSpace(int length) {
        return Lib.getCharacter(' ', length);
    }

    public static String getCharacter(char c, int length) {
        StringBuilder out = new StringBuilder();
        int i = 0;
        while (i < length) {
            out.append(c);
            ++i;
        }
        return out.toString();
    }

    public static String padLeading(String str, char c, int n) {
        char[] chars = new char[n];
        int pos = Math.min(n, str.length());
        str.getChars(0, pos, chars, n - pos);
        int i = 0;
        while (i < n - pos) {
            chars[i++] = c;
        }
        return new String(chars);
    }

    public static String padTrailing(String str, char c, int n) {
        char[] chars = new char[n];
        int pos = Math.min(n, str.length());
        str.getChars(0, pos, chars, 0);
        int i = pos;
        while (i < n) {
            chars[i++] = c;
        }
        return new String(chars);
    }

    public static ArrayList<String> readListFromDir(File directory, FilenameFilter filter, boolean keepExtension) {
        ArrayList<String> list = new ArrayList<String>(400);
        if (directory == null) {
            System.out.println("Invalid path: " + directory);
            return list;
        }
        Object[] files = directory.listFiles(filter);
        if (files == null) {
            System.out.println("Invalid path: " + directory);
            return list;
        }
        if (files.length > 0) {
            Arrays.sort(files);
        }
        if (keepExtension) {
            int i = 0;
            while (i < files.length) {
                list.add(((File)files[i]).getName());
                ++i;
            }
        } else {
            int i = 0;
            while (i < files.length) {
                list.add(Lib.removeExtension(((File)files[i]).getName()));
                ++i;
            }
        }
        return list;
    }

    public static ArrayList<String> readListFromDir(String directory, FilenameFilter filter) {
        return Lib.readListFromDir(new File(directory), filter, false);
    }

    public static ArrayList<String> readListFromFile(File file, boolean keepExtension) throws IOException {
        ArrayList<String> list = new ArrayList<String>(120);
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (!keepExtension) {
                    line = Lib.removeExtension(line);
                }
                if (!Strings.isValid(line)) continue;
                list.add(line);
            }
        }
        catch (Throwable throwable) {
            Lib.close(in);
            throw throwable;
        }
        Lib.close(in);
        return list;
    }

    public static ArrayList<String> readListFromFile(String file) throws IOException {
        return Lib.readListFromFile(new File(file), true);
    }

    public static boolean isLink(File file) {
        if (!file.exists()) {
            return true;
        }
        try {
            return !file.getAbsolutePath().equals(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static List<File> recursivelyListFilesAndDirectories(ArrayList<File> fileList, File rootPath, Pattern filePathP, boolean includeDirectories) {
        LinkedList<File> dirList = new LinkedList<File>();
        dirList.add(rootPath);
        Matcher fileNameM = null;
        if (filePathP != null) {
            fileNameM = filePathP.matcher("");
        }
        while (!dirList.isEmpty()) {
            File parent = (File)dirList.removeFirst();
            if (parent == null) {
                System.out.println("Invalid path.");
                continue;
            }
            if (parent.getName().startsWith(".Rational")) continue;
            File[] files = parent.listFiles();
            if (files == null) {
                System.out.println("Invalid path: " + parent);
                continue;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    dirList.add(files[i]);
                    if (includeDirectories) {
                        fileList.add(files[i]);
                    }
                } else if (fileNameM == null) {
                    fileList.add(files[i]);
                } else {
                    fileNameM.reset(files[i].getPath());
                    if (fileNameM.matches()) {
                        fileList.add(files[i]);
                    }
                }
                ++i;
            }
        }
        return fileList;
    }

    public static List<File> recursivelyListFiles(ArrayList<File> fileList, File rootPath, Pattern filePathP) {
        return Lib.recursivelyListFilesAndDirectories(fileList, rootPath, filePathP, false);
    }

    public static List<File> recursivelyListFiles(File rootPath, Pattern fileNameP) {
        return Lib.recursivelyListFiles(new ArrayList<File>(400), rootPath, fileNameP);
    }

    public static List<File> recursivelyListFiles(File rootPath) {
        return Lib.recursivelyListFiles(new ArrayList<File>(400), rootPath, null);
    }

    public static CharBuffer stripBlockComments(CharBuffer charBuf) {
        char[] chars = charBuf.array();
        int i = 0;
        int k = 0;
        try {
            while (i < chars.length) {
                if (chars[i] == '/' && chars[i + 1] == '*') {
                    i += 2;
                    while (chars[i++] != '*' || chars[i] != '/') {
                    }
                    ++i;
                    continue;
                }
                chars[k++] = chars[i++];
            }
            charBuf.limit(k);
            return charBuf;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Incorrectly formatted comments.");
        }
    }

    public static String removeExtension(String filepath) {
        String ext = Lib.getExtension(filepath);
        if (ext != null && ext.length() > 0) {
            filepath = filepath.substring(0, filepath.length() - (ext.length() + 1));
        }
        return filepath;
    }

    public static String removeExtension(File file) {
        return Lib.removeExtension(file.getName());
    }

    public static boolean isCompressed(File file) {
        boolean toReturn = false;
        String ext = Lib.getExtension(file.getAbsolutePath());
        if (ext.equals("zip")) {
            toReturn = true;
        }
        return toReturn;
    }

    public static boolean updateFile(File fileToModify, Pattern pattern, CharSequence replaceSeq) throws IOException {
        CharBuffer modifyBuf = Lib.fileToCharBuffer(fileToModify);
        Matcher matcher = pattern.matcher(modifyBuf);
        if (!matcher.find()) {
            System.out.println(String.valueOf(fileToModify.getPath()) + " does not contain the pattern: " + pattern.pattern());
            return false;
        }
        CharBuffer topSection = modifyBuf.subSequence(0, matcher.start(1));
        CharBuffer bottomSection = null;
        int bottomLen = 0;
        if (matcher.end(1) != modifyBuf.length()) {
            bottomSection = modifyBuf.subSequence(matcher.end(1), modifyBuf.length());
            bottomLen = bottomSection.length();
        }
        CharBuffer outBuf = CharBuffer.allocate(topSection.length() + replaceSeq.length() + bottomLen);
        outBuf.put(topSection);
        if (replaceSeq instanceof String) {
            outBuf.put((String)replaceSeq);
        } else if (replaceSeq instanceof CharBuffer) {
            outBuf.put((CharBuffer)replaceSeq);
        } else {
            outBuf.put(replaceSeq.toString());
        }
        if (bottomSection != null) {
            outBuf.put(bottomSection);
        }
        Lib.writeCharBufferToFile(outBuf, fileToModify);
        return true;
    }

    public static boolean updateFile(File fileToModify, Pattern pattern, File original) throws IOException {
        return Lib.updateFile(fileToModify, pattern, Lib.fileToCharBuffer(original));
    }

    public static void writeCharBufferToFile(CharBuffer charBuf, File outFile) throws IOException {
        Lib.writeCharsToFile(charBuf.array(), outFile);
    }

    public static void writeCharsToFile(char[] chars, File outFile) throws IOException {
        FileWriter out = null;
        try {
            out = new FileWriter(outFile);
            out.write(chars, 0, chars.length);
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
    }

    public static void writeStringToFile(String str, File outFile) throws IOException {
        OutputStreamWriter out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            char[] chars = str.toCharArray();
            out.write(chars, 0, chars.length);
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
    }

    public static String getBasePath() {
        return Lib.getBasePath(Lib.class);
    }

    public static String getDateTimeString() {
        SimpleDateFormat filenameDateFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm");
        return filenameDateFormat.format(new Date());
    }

    public static String getJarPath(Class<Lib> base) {
        String className = "/" + base.getName().replace('.', '/') + ".class";
        String path = base.getResource(className).getPath();
        int pos = path.lastIndexOf("!");
        if (pos == -1) {
            return null;
        }
        String jarpath = path.substring("file:".length(), pos);
        return jarpath.replaceAll("%20", " ");
    }

    public static String getClassLoadPath(Class<?> base) {
        ProtectionDomain pd = base.getProtectionDomain();
        CodeSource cs = pd.getCodeSource();
        URL csLoc = cs.getLocation();
        String path = csLoc.getPath();
        path = path.replaceAll("%20", " ");
        return path;
    }

    public static String getBasePath(Class<?> base) {
        String path = Lib.getClassLoadPath(base);
        if ((path = path.replaceAll("%20", " ")).endsWith(".jar")) {
            int end = path.lastIndexOf(47);
            path = path.substring(0, end);
        }
        return path;
    }

    public static URL resolveToUrl(String path) {
        URL url = null;
        System.out.println("resolveToUrl: " + path);
        if (Strings.isValid(path)) {
            if (path.indexOf("://") == -1) {
                if (!path.startsWith("/")) {
                    try {
                        path = new File(String.valueOf(basePath) + "/" + path).getCanonicalPath();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                path = "file://" + path;
            }
            try {
                url = new URL(path);
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
            }
        }
        return url;
    }

    public static String escapeForRegex(String text) {
        char[] chars = text.toCharArray();
        StringBuffer strB = new StringBuffer(chars.length + 5);
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '$': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    strB.append('\\');
                }
            }
            strB.append(chars[i]);
            ++i;
        }
        return strB.toString();
    }

    public static String determineGroup() {
        String toReturn = "no group";
        Process process = null;
        try {
            try {
                String[] cmd = new String[]{"/usr/bin/bash", "-c", "groups | awk '{print $1}'"};
                ProcessBuilder builder = new ProcessBuilder(cmd);
                builder.redirectErrorStream(true);
                process = builder.start();
                try (InputStream inputStream = null;){
                    inputStream = process.getInputStream();
                    toReturn = Lib.inputStreamToString(inputStream);
                    if (toReturn != null) {
                        toReturn = toReturn.trim();
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                if (process != null) {
                    process.destroy();
                }
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return toReturn;
    }

    public static String[] getArguments(String source) {
        ArrayList<String> theResults;
        block15: {
            theResults = new ArrayList<String>();
            if (source.charAt(0) == '(') break block15;
            return null;
        }
        try {
            int currentArg = 1;
            int startPos = 1;
            int parens = 0;
            boolean foundValidChar = false;
            int i = 1;
            while (i < source.length()) {
                char theChar = source.charAt(i);
                if (theChar == '(') {
                    ++parens;
                } else if (theChar == ')') {
                    if (--parens < 0) {
                        theResults.add(source.substring(startPos, i));
                        break;
                    }
                } else if (theChar == ',' && parens == 0) {
                    theResults.add(source.substring(startPos, i));
                    startPos = i + 1;
                    ++currentArg;
                    foundValidChar = false;
                } else if (!foundValidChar) {
                    if (Character.isWhitespace(theChar)) {
                        ++startPos;
                    } else {
                        foundValidChar = true;
                    }
                }
                ++i;
            }
            String[] theTrueResults = new String[theResults.size()];
            theResults.toArray(theTrueResults);
            if (theTrueResults.length != currentArg) {
                XConsoleLogger.err("In getArguments, number of argument mismatch.", new Object[0]);
            }
            return theTrueResults;
        }
        catch (Exception e) {
            XConsoleLogger.err(Lib.exceptionToString(e), new Object[0]);
            return null;
        }
    }

    public static int getArgsLength(String source) {
        block7: {
            if (source.charAt(0) == '(') break block7;
            XConsoleLogger.err("In getArguments, first char must be '('.", new Object[0]);
            return -1;
        }
        try {
            int parens = 0;
            int i = 1;
            while (i < source.length()) {
                char theChar = source.charAt(i);
                if (theChar == '(') {
                    ++parens;
                } else if (theChar == ')' && --parens < 0) {
                    return i - 1;
                }
                ++i;
            }
            XConsoleLogger.err("In getArguments, problem occurred.", new Object[0]);
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static String[] getCommaSeparatedItems(String source) {
        ArrayList<String> theResults = new ArrayList<String>();
        int startPos = 0;
        int parensCount = 0;
        int i = 0;
        while (i < source.length()) {
            char theChar = source.charAt(i);
            if (theChar == '(' || theChar == '{') {
                ++parensCount;
            } else if (theChar == ')' || theChar == '}') {
                --parensCount;
            } else if (parensCount == 0 && theChar == ',') {
                theResults.add(source.substring(startPos, i).trim());
                startPos = i + 1;
            }
            ++i;
        }
        theResults.add(source.substring(startPos).trim());
        String[] results = new String[theResults.size()];
        theResults.toArray(results);
        return results;
    }

    public static int findTheEnd(int start, CharSequence seq) {
        int stack = 1;
        char[] array = seq.subSequence(start, seq.length()).toString().toCharArray();
        int i = 0;
        while (i < array.length) {
            if (array[i] == '/' && array[i + 1] == '*') {
                while (array[i] != '*' || array[i + 1] != '/') {
                    ++i;
                }
            }
            if (array[i] == '\"') {
                ++i;
                while (array[i] != '\"' || array[i - 1] == '\\') {
                    ++i;
                }
            }
            if (array[i] == '{') {
                ++stack;
            } else if (array[i] == '}') {
                --stack;
            }
            if (stack == 0) {
                return start + i - 1;
            }
            ++i;
        }
        return start + i - 1;
    }

    public static final URL getUrlFromString(String path) throws MalformedURLException {
        if (!path.matches("(file:/|file://|http://|C:).*")) {
            return new URL("file://" + path);
        }
        return new URL(path);
    }

    public static final URL[] getUrlFromString(String[] path) throws MalformedURLException {
        URL[] urls = new URL[path.length];
        int i = 0;
        while (i < urls.length) {
            urls[i] = Lib.getUrlFromString(path[i]);
            ++i;
        }
        return urls;
    }

    public static final String convertToJavaClassName(String name) {
        ChangeSet changeSet = new ChangeSet(name);
        Matcher matcher = Pattern.compile("_([a-zA-Z])").matcher(changeSet.toString());
        changeSet.replace(0, 1, Character.toUpperCase(name.charAt(0)));
        while (matcher.find()) {
            changeSet.replace(matcher.start(), matcher.end(), Character.toUpperCase(matcher.group(1).charAt(0)));
        }
        return changeSet.applyChangesToSelf().toString();
    }

    public static final String convertToJavaVariableName(String name) {
        name = name.toLowerCase();
        StringBuffer sb = new StringBuffer();
        char[] chars = name.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '_') {
                if (chars.length > i + 1 && chars[i + 1] != '_') {
                    sb.append(Character.toUpperCase(chars[i + 1]));
                    ++i;
                }
            } else {
                sb.append(chars[i]);
            }
            ++i;
        }
        return sb.toString();
    }

    public static URL getJarFileURL(File directory, String title, String version) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(directory.getPath()) + " is not a valid directory.");
        }
        File[] jars = directory.listFiles(new MatchFilter(".*\\.jar"));
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                JarFile jar = new JarFile(jars[i]);
                Attributes attributes = jar.getManifest().getMainAttributes();
                jar.close();
                String jarTitle = attributes.getValue("Implementation-Title");
                String jarVersion = attributes.getValue("Implementation-Version");
                if (jarTitle != null && jarVersion != null && jarTitle.equals(title) && jarVersion.equals(version)) {
                    return jars[i].toURI().toURL();
                }
                ++i;
            }
        }
        throw new IllegalArgumentException("The specified version: " + version + " for " + title + " was not found.");
    }

    public static URL[] getClasspath() throws MalformedURLException {
        String[] strPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        URL[] urlPaths = new URL[strPaths.length];
        int i = 0;
        while (i < strPaths.length) {
            urlPaths[i] = new File(strPaths[i]).toURI().toURL();
            ++i;
        }
        return urlPaths;
    }

    public static String getJarFileVersion(String jarFilePath) throws IOException {
        Manifest manifest;
        File jarFile = new File(jarFilePath);
        if (!jarFile.isFile()) {
            JarInputStream jis = null;
            try {
                try {
                    URL u = new URL(jarFilePath);
                    URLConnection uc = u.openConnection();
                    jis = new JarInputStream(uc.getInputStream());
                    manifest = jis.getManifest();
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException(String.valueOf(jarFilePath) + " is not a valid file or URL.");
                }
            }
            catch (Throwable throwable) {
                Lib.close(jis);
                throw throwable;
            }
            Lib.close(jis);
        } else {
            JarFile jf = new JarFile(jarFile);
            manifest = jf.getManifest();
            jf.close();
        }
        return manifest.getMainAttributes().getValue("Implementation-Version");
    }

    public static String getElapseString(long startTime) {
        return Lib.asTimeString(System.currentTimeMillis() - startTime);
    }

    public static String asTimeString(long value) {
        long leftOverMs = value % 1000L;
        long seconds = value / 1000L;
        long leftOverSeconds = seconds % 60L;
        long minutes = seconds / 60L;
        long leftOverMinutes = minutes % 60L;
        long hours = minutes / 60L;
        return String.format("%d:%02d:%02d.%03d", hours, leftOverMinutes, leftOverSeconds, leftOverMs);
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").indexOf("indows") != -1;
    }

    public static void writeBytesToFile(byte[] data, File file) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream os = new FileOutputStream(file);){
            ((OutputStream)os).write(data);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void extractJarEntry(File jarFile, File destination, String entry) throws IOException {
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        BufferedInputStream inputStream = null;
        BufferedOutputStream outputStream = null;
        try {
            try {
                JarFile jarfile = new JarFile(jarFile.getAbsolutePath());
                JarEntry jarEntry = jarfile.getJarEntry(entry);
                inputStream = new BufferedInputStream(jarfile.getInputStream(jarEntry));
                outputStream = new BufferedOutputStream(new FileOutputStream(destination));
                Lib.inputStreamToOutputStream(inputStream, outputStream);
                ((OutputStream)outputStream).flush();
            }
            catch (Exception ex) {
                String information = String.format("JarFile: %s\nEntry: %s\nDestination: %s\n", jarFile.getAbsolutePath(), entry, destination.getAbsolutePath());
                throw new IOException(String.valueOf(information) + ex.getMessage());
            }
        }
        catch (Throwable throwable) {
            Lib.close(outputStream);
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close(outputStream);
        Lib.close(inputStream);
    }

    public static byte[] compressStream(InputStream in, String name) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(bos);
            out.putNextEntry(new ZipEntry(name));
            Lib.inputStreamToOutputStream(in, out);
            out.closeEntry();
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
        return bos.toByteArray();
    }

    public static byte[] compressFile(File file) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(bos);
            Lib.compressFile(null, file, outputStream);
            outputStream.closeEntry();
        }
        catch (Throwable throwable) {
            Lib.close(outputStream);
            Lib.close(bos);
            throw throwable;
        }
        Lib.close(outputStream);
        Lib.close(bos);
        return bos.toByteArray();
    }

    public static void compressFiles(String basePath, Collection<File> files, String zipTarget) throws IOException {
        if (!Strings.isValid(zipTarget)) {
            throw new IllegalArgumentException("Error target zip filename is invalid");
        }
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(new FileOutputStream(zipTarget));
            for (File file : files) {
                if (file.isDirectory()) continue;
                Lib.compressFile(basePath, file, out);
            }
        }
        catch (Throwable throwable) {
            Lib.close(out);
            throw throwable;
        }
        Lib.close(out);
    }

    private static void compressFile(String basePath, File file, ZipOutputStream outputStream) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            String entryName = file.getPath();
            if (Strings.isValid(basePath) && entryName.startsWith(basePath)) {
                if (!basePath.endsWith(File.separator)) {
                    basePath = String.valueOf(basePath) + File.separator;
                }
                entryName = entryName.replace(basePath, "");
            }
            ZipEntry entry = new ZipEntry(entryName);
            outputStream.putNextEntry(entry);
            Lib.inputStreamToOutputStream(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            Lib.close(inputStream);
            throw throwable;
        }
        Lib.close(inputStream);
    }

    private static void compressDirectory(String basePath, File source, ZipOutputStream outputStream, boolean includeSubDirectories) throws IOException {
        File[] children = source.listFiles();
        if (children != null) {
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!file.isDirectory()) {
                    Lib.compressFile(basePath, file, outputStream);
                } else if (includeSubDirectories) {
                    Lib.compressDirectory(basePath, file, outputStream, includeSubDirectories);
                }
                ++n2;
            }
        }
    }

    public static void compressDirectory(File directory, String zipTarget, boolean includeSubDirectories) throws IOException, IllegalArgumentException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.format("Error source is not a directory: [%s]", directory));
        }
        if (!Strings.isValid(zipTarget)) {
            throw new IllegalArgumentException("Error target zip filename is invalid");
        }
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(new FileOutputStream(zipTarget));
            Lib.compressDirectory(directory.getPath(), directory, outputStream, includeSubDirectories);
        }
        catch (Throwable throwable) {
            Lib.close(outputStream);
            throw throwable;
        }
        Lib.close(outputStream);
    }

    public static String decompressStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        String zipEntryName = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry entry = zipInputStream.getNextEntry();
            zipEntryName = entry.getName();
            Lib.inputStreamToOutputStream(zipInputStream, outputStream);
        }
        catch (Throwable throwable) {
            Lib.close(zipInputStream);
            throw throwable;
        }
        Lib.close(zipInputStream);
        return zipEntryName;
    }

    public static void decompressStream(InputStream inputStream, File targetDirectory) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            if (!targetDirectory.exists()) {
                targetDirectory.mkdirs();
            }
            ZipEntry entry = null;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String zipEntryName = entry.getName();
                BufferedOutputStream outputStream = null;
                try {
                    File target = new File(targetDirectory, zipEntryName);
                    if (entry.isDirectory()) continue;
                    File parent = target.getParentFile();
                    if (parent != null && !parent.exists()) {
                        parent.mkdirs();
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(target));
                    Lib.inputStreamToOutputStream(zipInputStream, outputStream);
                }
                finally {
                    Lib.close(outputStream);
                }
            }
        }
        catch (Throwable throwable) {
            Lib.close(zipInputStream);
            throw throwable;
        }
        Lib.close(zipInputStream);
    }

    public static byte[] decompressBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ZipInputStream in = null;
        try {
            in = new ZipInputStream(inputStream);
            in.getNextEntry();
            Lib.inputStreamToOutputStream(in, out);
        }
        catch (Throwable throwable) {
            Lib.close(in);
            Lib.close(out);
            throw throwable;
        }
        Lib.close(in);
        Lib.close(out);
        return out.toByteArray();
    }

    public static String getSortedJavaArrayInitializer(String[] strings) {
        Arrays.sort(strings);
        StringBuilder strB = new StringBuilder();
        strB.append("new String[] {\"");
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            strB.append(element);
            strB.append("\", \"");
            ++n2;
        }
        strB.replace(strB.length() - 3, strB.length(), "};");
        return strB.toString();
    }

    public static boolean isWordML(InputStream inputStream) {
        boolean toReturn;
        block13: {
            toReturn = false;
            try {
                try {
                    String header;
                    inputStream.mark(250);
                    byte[] buffer = new byte[200];
                    int index = 0;
                    while (index < buffer.length) {
                        if (inputStream.available() <= 0) break;
                        buffer[index] = (byte)inputStream.read();
                        ++index;
                    }
                    if (index > 0 && ((header = new String(buffer).toLowerCase()).contains("word.document") || header.contains("worddocument") || header.contains("<w:"))) {
                        toReturn = true;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        inputStream.reset();
                    }
                    catch (IOException iOException) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {}
        }
        return toReturn;
    }

    public static void close(AutoCloseable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String toMBytes(long valInBytes) {
        NumberFormat format = NumberFormat.getInstance();
        return String.format("%s MBytes", format.format((double)valInBytes / 1024.0 / 1024.0));
    }

    public static Long generateId() {
        return Lib.generateUuid();
    }

    public static Long generateUuid() {
        long id = ThreadLocalRandom.current().nextLong(Long.MAX_VALUE);
        if (id == 0L) {
            return Lib.generateUuid();
        }
        return id;
    }

    public static Long generateArtifactIdAsInt() {
        return (long)RANDOM.nextInt(Integer.MAX_VALUE) + 1L;
    }

    public static String toCamelCaseFromStringsWithSpaces(String str) {
        return Lib.toCamelCase(str.replaceAll(" ", "_"));
    }

    public static String toCamelCase(String str) {
        String[] words = str.split("_");
        String result = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            result = String.valueOf(result) + word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase();
            ++n2;
        }
        String firstChar = result.substring(0, 1);
        return result.replaceFirst(firstChar, firstChar.toLowerCase());
    }

    public static String toCamelCaseWithSpaces(String str) {
        String[] words = str.split("_");
        String result = "";
        String[] stringArray = words;
        int n = words.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            result = String.valueOf(result) + word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase() + " ";
            ++n2;
        }
        return result;
    }

    public static boolean isCollectionOfType(Class<?> type, Type genericType, Class<?> ofType) {
        Type t;
        ParameterizedType parameterizedType;
        Type[] actualTypeArgs;
        boolean isWriteable = false;
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType && (actualTypeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 1 && (t = actualTypeArgs[0]) instanceof Class) {
            Class clazz = (Class)t;
            isWriteable = ofType.isAssignableFrom(clazz);
        }
        return isWriteable;
    }

    public static boolean lessThan(double d1, double d2) {
        return d1 + 1.0E-7 < d2;
    }

    public static boolean greaterThan(double d1, double d2) {
        return d1 > d2 + 1.0E-7;
    }

    public static String getURIAbsolutePath(UriInfo uriInfo) {
        String uriPath = uriInfo.getPath();
        if (uriPath.startsWith("/")) {
            uriPath = uriPath.replaceFirst("\\/+", "");
        }
        uriPath = uriPath.replaceAll(INVALID_URI_CHARACTERS_REGEX, "");
        URI baseUri = uriInfo.getBaseUri();
        String basePath = baseUri.toString();
        if (!basePath.endsWith("/")) {
            basePath = String.valueOf(basePath) + "/";
            try {
                baseUri = URI.create(basePath);
            }
            catch (Exception exception) {
                basePath = basePath.replace(" ", "");
                baseUri = URI.create(basePath);
            }
        }
        try {
            uriPath = URLEncoder.encode(uriPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new OseeCoreException("Cant Encode", new Object[0]);
        }
        uriPath = uriPath.replace(" ", "");
        uriPath = uriPath.replaceAll("%2F", "/");
        uriPath = uriPath.replaceAll("%3F", "?");
        uriPath = uriPath.replaceAll("%3A", ":");
        return baseUri.resolve(uriPath).getPath();
    }
}

