/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osee.ats.api.branch.BranchStatus;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactTopicEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IBranchEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.swt.widgets.Control;

public abstract class XWorkingBranchWidgetAbstract
extends GenericXWidget
implements ArtifactWidget,
IArtifactEventListener,
IArtifactTopicEventListener,
IBranchEventListener {
    private TeamWorkFlowArtifact teamArt;
    private boolean workingBranchCreationInProgress = false;
    private boolean workingBranchCommitInProgress = false;
    private boolean workingBranchCommitWithMergeInProgress = false;
    private boolean workingBranchInWork = false;
    private boolean committedBranchExists = false;
    protected boolean disableAll = false;
    private BranchToken workingBranch = null;

    public XWorkingBranchWidgetAbstract() {
        OseeEventManager.addListener((IEventListener)this);
    }

    public TeamWorkFlowArtifact getArtifact() {
        return this.teamArt;
    }

    public void dispose() {
        OseeEventManager.removeListener((IEventListener)this);
    }

    public Control getControl() {
        return this.labelWidget;
    }

    public IStatus isValid() {
        return new Status(0, ((Object)((Object)this)).getClass().getSimpleName(), "");
    }

    protected abstract void refreshWorkingBranchWidget();

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public void saveToArtifact() {
    }

    public void setArtifact(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
            this.teamArt = (TeamWorkFlowArtifact)artifact;
            this.updateBranchState();
        }
    }

    public String toString() {
        return String.format("%s", this.getLabel());
    }

    public List<? extends IEventFilter> getEventFilters() {
        return null;
    }

    public void handleArtifactEvent(ArtifactEvent artifactEvent, Sender sender) {
        this.refreshWorkingBranchWidget();
    }

    public void handleArtifactTopicEvent(ArtifactTopicEvent artifactTopicEvent, Sender sender) {
        this.refreshWorkingBranchWidget();
    }

    public void handleBranchEvent(Sender sender, BranchEvent branchEvent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    XWorkingBranchWidgetAbstract.this.updateBranchState();
                    XWorkingBranchWidgetAbstract.this.refreshWorkingBranchWidget();
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
    }

    private void updateBranchState() {
        if (this.teamArt != null) {
            this.workingBranch = AtsApiService.get().getBranchService().getWorkingBranch((IAtsTeamWorkflow)this.teamArt, true);
            this.workingBranchCreationInProgress = AtsApiService.get().getBranchService().isWorkingBranchCreationInProgress((IAtsTeamWorkflow)this.teamArt);
            this.workingBranchInWork = AtsApiService.get().getBranchService().isWorkingBranchInWork((IAtsTeamWorkflow)this.teamArt);
            if (this.workingBranch.isInvalid()) {
                this.workingBranchCommitInProgress = false;
            } else {
                BranchState state = BranchManager.getState((BranchId)this.workingBranch);
                this.workingBranchCreationInProgress |= state.isCreationInProgress();
                this.workingBranchCommitInProgress = AtsApiService.get().getBranchService().isWorkingBranchCommitInProgress((IAtsTeamWorkflow)this.teamArt) || state.isCommitInProgress();
                this.workingBranchCommitWithMergeInProgress = BranchManager.hasMergeBranches((BranchId)this.workingBranch) && !state.isRebaselineInProgress();
            }
            this.committedBranchExists = AtsApiService.get().getBranchService().isCommittedBranchExists((IAtsTeamWorkflow)this.teamArt);
            this.disableAll = this.workingBranchCommitInProgress;
        }
    }

    protected BranchStatus getStatus() {
        if (this.teamArt != null) {
            if (this.workingBranchCreationInProgress) {
                return BranchStatus.Changes_NotPermitted__CreationInProgress;
            }
            if (this.workingBranchCommitInProgress) {
                return BranchStatus.Changes_NotPermitted__CommitInProgress;
            }
            if (this.committedBranchExists) {
                return BranchStatus.Changes_NotPermitted__BranchCommitted;
            }
            if (this.workingBranchInWork) {
                return BranchStatus.Changes_InProgress;
            }
        }
        return BranchStatus.Not_Started;
    }

    public TeamWorkFlowArtifact getTeamArt() {
        return this.teamArt;
    }

    public BranchToken getWorkingBranch() {
        return this.workingBranch;
    }

    public boolean isWorkingBranchCreationInProgress() {
        return this.workingBranchCreationInProgress;
    }

    public boolean isWorkingBranchCommitWithMergeInProgress() {
        return this.workingBranchCommitWithMergeInProgress;
    }

    public boolean isWorkingBranchCommitInProgress() {
        return this.workingBranchCommitInProgress;
    }

    public boolean isWorkingBranchInWork() {
        return this.workingBranchInWork;
    }

    public boolean isCommittedBranchExists() {
        return this.committedBranchExists;
    }
}

