/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchButtonAbstract;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEvent;
import org.eclipse.osee.framework.skynet.core.event.model.BranchEventType;
import org.eclipse.osee.framework.skynet.core.topic.event.filter.ITopicEventFilter;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class XWorkingBranchButtonFavorites
extends XWorkingBranchButtonAbstract {
    @Override
    protected void initButton(Button button) {
        button.setToolTipText("Toggle Working Branch as Favorite");
        button.setImage(ImageManager.getImage((OseeImage)AtsImage.FAVORITE));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                XWorkingBranchButtonFavorites.this.markWorkingBranchAsFavorite();
            }
        });
    }

    @Override
    protected void refreshEnablement(Button button) {
        button.setEnabled(!this.disableAll && this.isWorkingBranchInWork() && this.isWidgetAllowedInCurrentState());
    }

    private void markWorkingBranchAsFavorite() {
        try {
            User user = UserManager.getUser();
            user.reloadAttributesAndRelations();
            if (user.isSystemUser()) {
                AWorkbench.popup((String)("Can't set preference as System User = " + user));
                return;
            }
            BranchToken branch = this.getTeamArt().getWorkingBranch();
            if (branch.isInvalid()) {
                AWorkbench.popup((String)"Working branch doesn't exist");
                return;
            }
            boolean isFavorite = user.isFavoriteBranch((BranchId)branch);
            String message = String.format("Working branch is currently [%s]\n\nToggle favorite?", isFavorite ? "Favorite" : "NOT Favorite");
            if (MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)"Toggle Branch as Favorite", (String)message)) {
                user.toggleFavoriteBranch((BranchId)branch);
                OseeEventManager.kickBranchEvent((Object)((Object)this), (BranchEvent)new BranchEvent(BranchEventType.FavoritesUpdated, (BranchId)branch));
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    @Override
    protected boolean isWidgetAllowedInCurrentState() {
        return true;
    }

    public List<? extends ITopicEventFilter> getTopicEventFilters() {
        return null;
    }
}

