/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.search.widget;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.osee.ats.api.insertion.IAtsInsertion;
import org.eclipse.osee.ats.api.insertion.IAtsInsertionActivity;
import org.eclipse.osee.ats.api.query.AtsSearchData;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.search.widget.AbstractXComboViewerSearchWidget;
import org.eclipse.osee.ats.ide.search.widget.InsertionSearchWidget;
import org.eclipse.osee.ats.ide.world.WorldEditorParameterSearchItem;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.ui.skynet.widgets.XComboViewer;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidget;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class InsertionActivitySearchWidget
extends AbstractXComboViewerSearchWidget<IAtsInsertionActivity> {
    public static final String INSERTION_ACTIVITY = "Insertion Activity";
    private InsertionSearchWidget insertionWidget;

    public InsertionActivitySearchWidget(WorldEditorParameterSearchItem searchItem) {
        super(INSERTION_ACTIVITY, searchItem);
    }

    @Override
    public void set(AtsSearchData data) {
        if (this.getWidget() != null) {
            this.setup((XWidget)this.getWidget());
            Long insertionActivityId = data.getInsertionActivityId();
            XComboViewer combo = this.getWidget();
            if (insertionActivityId != null && insertionActivityId > 0L) {
                IAtsInsertionActivity insertionActivity = AtsApiService.get().getProgramService().getInsertionActivity(insertionActivityId);
                combo.setSelected(Arrays.asList(insertionActivity));
            }
        }
    }

    @Override
    public Collection<IAtsInsertionActivity> getInput() {
        Object obj;
        if (this.insertionWidget != null && this.insertionWidget.get() != null && (obj = this.insertionWidget.getWidget().getSelected()) != null && obj instanceof IAtsInsertion) {
            return Collections.castAll((Collection)AtsApiService.get().getProgramService().getInsertionActivities((IAtsInsertion)this.insertionWidget.get()));
        }
        return java.util.Collections.emptyList();
    }

    public void setInsertionWidget(InsertionSearchWidget insertionWidget) {
        this.insertionWidget = insertionWidget;
        insertionWidget.getWidget().getCombo().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InsertionActivitySearchWidget.this.setup((XWidget)InsertionActivitySearchWidget.this.getWidget());
            }
        });
    }

    @Override
    public String getInitialText() {
        if (this.insertionWidget == null || this.insertionWidget.get() == null) {
            return "--select insertion--";
        }
        return "";
    }
}

