/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.SubscribeUtility;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionCheckTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class SubscribeByTeamDefinition
extends XNavigateItemAction {
    public SubscribeByTeamDefinition() {
        super("Subscribe by Team Definition", (KeyedImage)FrameworkImage.EMAIL, new XNavItemCat[]{XNavigateItem.EMAIL_NOTIFICATIONS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        TeamDefinitionCheckTreeDialog diag = new TeamDefinitionCheckTreeDialog(this.getName(), "Select Team Definition\n\nEmail will be sent for every Action created against these Teams.", Active.Active, false);
        try {
            ArrayList<IAtsTeamDefinition> objs = new ArrayList<IAtsTeamDefinition>();
            User user = UserManager.getUser();
            for (ArtifactToken art : user.getRelatedArtifacts(AtsRelationTypes.SubscribedUser_Artifact)) {
                if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) continue;
                objs.add((IAtsTeamDefinition)AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)art));
            }
            diag.setInitialTeamDefs(objs);
            if (diag.open() != 0) {
                return;
            }
            Collection<IAtsTeamDefinition> selected = diag.getChecked();
            List arts = Collections.castAll((Collection)AtsApiService.get().getQueryService().getArtifactsFromObjects(selected));
            SubscribeUtility.setSubcriptionsAndPersist((Artifact)user, AtsRelationTypes.SubscribedUser_Artifact, arts, AtsArtifactTypes.TeamDefinition, ((Object)((Object)this)).getClass().getSimpleName());
            AWorkbench.popup((String)this.getName(), (String)"Subscriptions updated.");
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

