/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.members;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.CustomizeData;
import org.eclipse.osee.ats.api.agile.IAgileBacklog;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.actions.OpenNewAtsWorldEditorSelectedAction;
import org.eclipse.osee.ats.ide.actions.SprintReportAction;
import org.eclipse.osee.ats.ide.config.AtsBulkLoad;
import org.eclipse.osee.ats.ide.editor.WorkflowEditor;
import org.eclipse.osee.ats.ide.editor.tab.WfeAbstractTab;
import org.eclipse.osee.ats.ide.editor.tab.members.IMemberProvider;
import org.eclipse.osee.ats.ide.editor.tab.members.WfeMembersTabActions;
import org.eclipse.osee.ats.ide.editor.tab.members.WfeMembersTabDragAndDrop;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.CollectorArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.CloneActionToGoalAction;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.NewActionToGoalAction;
import org.eclipse.osee.ats.ide.workflow.goal.OpenAgileTasksAction;
import org.eclipse.osee.ats.ide.workflow.goal.RemoveFromCollectorAction;
import org.eclipse.osee.ats.ide.workflow.goal.SetCollectorOrderAction;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.world.BacklogContentProvider;
import org.eclipse.osee.ats.ide.world.IMenuActionProvider;
import org.eclipse.osee.ats.ide.world.IWorldEditor;
import org.eclipse.osee.ats.ide.world.IWorldEditorProvider;
import org.eclipse.osee.ats.ide.world.IWorldViewerEventHandler;
import org.eclipse.osee.ats.ide.world.WorkflowMetricsUI;
import org.eclipse.osee.ats.ide.world.WorldComposite;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.ats.ide.world.WorldXViewerEventManager;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.action.CollapseAllAction;
import org.eclipse.osee.framework.ui.skynet.action.ExpandAllAction;
import org.eclipse.osee.framework.ui.skynet.util.FormsUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.XWidgetUtility;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.progress.UIJob;

public class WfeMembersTab
extends WfeAbstractTab
implements IWorldEditor,
ISelectedAtsArtifacts,
IWorldViewerEventHandler,
IMenuActionProvider {
    private IManagedForm managedForm;
    private ScrolledForm scrolledForm;
    private WorldComposite worldComposite;
    public static final String ID = "ats.members.tab";
    private final WorkflowEditor editor;
    private static Map<Long, Integer> idToScrollLocation = new HashMap<Long, Integer>();
    private final ReloadJobChangeAdapter reloadAdapter;
    private final IMemberProvider provider;
    private WorkflowMetricsUI workflowMetricsUi;
    private WfeMembersTabActions wfeMembersTabActions;
    private final WfeMembersTab membersTab;
    private final Control control = null;
    Action setCollectorOrderAction;
    Action removeFromCollectorAction;
    Action printAgileTasksAction;
    private NewActionToGoalAction newActionToGoalAction;
    private CloneActionToGoalAction cloneActionToGoalAction;

    public WfeMembersTab(WorkflowEditor editor, IMemberProvider provider) {
        super(editor, ID, editor.getWorkItem(), provider.getMembersName());
        this.editor = editor;
        this.provider = provider;
        this.reloadAdapter = new ReloadJobChangeAdapter(editor);
        this.membersTab = this;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.managedForm = managedForm;
        this.scrolledForm = managedForm.getForm();
        try {
            this.scrolledForm.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WfeMembersTab.this.storeScrollLocation();
                }
            });
            this.updateTitleBar(managedForm);
            FormsUtil.addHeadingGradient((FormToolkit)this.editor.getToolkit(), (ScrolledForm)managedForm.getForm(), (boolean)true);
            this.bodyComp = this.scrolledForm.getBody();
            GridLayout gridLayout = new GridLayout(1, true);
            this.bodyComp.setLayout((Layout)gridLayout);
            GridData gd = new GridData(16384, 16384, false, false);
            this.bodyComp.setLayoutData((Object)gd);
            this.setLoading(true);
            this.refreshData();
            WorldXViewerEventManager.add(this);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }

    @Override
    public void showBusy(boolean busy) {
        super.showBusy(busy);
        if (this.getManagedForm() != null && Widgets.isAccessible((Widget)this.getManagedForm().getForm())) {
            this.getManagedForm().getForm().getForm().setBusy(busy);
        }
    }

    public void refreshData() {
        if (Widgets.isAccessible((Widget)this.bodyComp)) {
            List<IOperation> ops = AtsBulkLoad.getConfigLoadingOperations();
            IOperation operation = Operations.createBuilder((String)("Load " + this.provider.getMembersName() + " Tab")).addAll(ops).build();
            Operations.executeAsJob((IOperation)operation, (boolean)false, (int)30, (IJobChangeListener)this.reloadAdapter);
        }
    }

    @Override
    protected String getFormTitle(IManagedForm managedForm, String artifactTypeName) {
        String formTitle = super.getFormTitle(managedForm, artifactTypeName);
        formTitle = String.valueOf(formTitle) + " - " + this.editor.getWorkItem().getName();
        return formTitle;
    }

    private boolean createMembersBody() {
        if (!Widgets.isAccessible((Widget)this.worldComposite)) {
            this.worldComposite = new WorldComposite(this, this.provider.getXViewerFactory(this.provider.getArtifact()), this.bodyComp, 2048, false);
            this.worldComposite.getWorldXViewer().setContentProvider((IContentProvider)new BacklogContentProvider(this.worldComposite.getWorldXViewer()));
            new WfeMembersTabDragAndDrop(this.worldComposite, this.provider, "org.eclipse.osee.ats.ide.editor.WorkflowEditor");
            this.worldComposite.setLayout((Layout)ALayout.getZeroMarginLayout());
            if (this.editor.getWorkItem().isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Goal})) {
                this.worldComposite.getXViewer().setParentGoal((GoalArtifact)this.editor.getWorkItem());
            } else {
                this.worldComposite.getXViewer().setParentSprint((SprintArtifact)this.editor.getWorkItem());
            }
            this.worldComposite.getWorldXViewer().addMenuActionProvider(this);
            this.getSite().setSelectionProvider((ISelectionProvider)this.worldComposite.getWorldXViewer());
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 100;
            gd.heightHint = 100;
            this.worldComposite.setLayoutData(gd);
            this.workflowMetricsUi = new WorkflowMetricsUI(this.worldComposite, this.editor.getToolkit());
            this.editor.getToolkit().adapt((Composite)this.worldComposite);
            this.reload();
            this.createActions();
            XWidgetUtility.setLabelFontsBold((Control)this.worldComposite, (Font)FontManager.getDefaultLabelFont());
            this.worldComposite.setShowRemoveMenuItems(false);
            return true;
        }
        return false;
    }

    public void reload() {
        if (this.isTableDisposed()) {
            return;
        }
        String getLoadingString = String.format("Loading %s %s", this.provider.getCollectorName(), this.provider.getMembersName());
        Job job = new Job(getLoadingString){

            protected IStatus run(IProgressMonitor monitor) {
                if (WfeMembersTab.this.isTableDisposed()) {
                    return Status.OK_STATUS;
                }
                try {
                    final List<Artifact> artifacts = WfeMembersTab.this.provider.getMembers();
                    try {
                        AtsBulkLoad.bulkLoadArtifacts(artifacts);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                    Displays.ensureInDisplayThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (WfeMembersTab.this.isTableDisposed()) {
                                return;
                            }
                            (this).WfeMembersTab.this.worldComposite.load((this).WfeMembersTab.this.provider.getCollectorName(), (Collection<? extends Artifact>)artifacts, (CustomizeData)null, XNavigateComposite.TableLoadOption.None);
                        }
                    });
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    return new Status(4, "org.eclipse.osee.ats.ide", String.format("Exception loading %s", WfeMembersTab.this.provider.getCollectorName()), (Throwable)ex);
                }
                return Status.OK_STATUS;
            }
        };
        Jobs.startJob((Job)job, (boolean)false);
    }

    private boolean isTableDisposed() {
        return this.worldComposite == null || this.worldComposite.getXViewer() == null || this.worldComposite.getXViewer().getTree() == null || this.worldComposite.getXViewer().getTree().isDisposed();
    }

    private void jumptoScrollLocation() {
        Integer selection = idToScrollLocation.get(this.provider.getId());
        if (selection != null) {
            JumpScrollbarJob job = new JumpScrollbarJob("");
            job.schedule(500L);
        }
    }

    public void dispose() {
        if (this.worldComposite != null) {
            this.worldComposite.dispose();
        }
    }

    private void storeScrollLocation() {
        if (this.managedForm != null && this.managedForm.getForm() != null) {
            Integer selection = this.managedForm.getForm().getVerticalBar().getSelection();
            idToScrollLocation.put(this.provider.getId(), selection);
        }
    }

    public void refresh() {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (Widgets.isAccessible((Widget)WfeMembersTab.this.worldComposite)) {
                    WfeMembersTab.this.worldComposite.getXViewer().setInput(WfeMembersTab.this.provider.getMembers());
                }
            }
        });
    }

    @Override
    public IToolBarManager createToolbar(IManagedForm managedForm) {
        IToolBarManager toolBarMgr = this.scrolledForm.getToolBarManager();
        toolBarMgr.removeAll();
        if (this.workItem.isBacklog()) {
            IAgileBacklog backlog = AtsApiService.get().getAgileService().getAgileBacklog((ArtifactId)this.workItem.getStoreObject());
            toolBarMgr.add((IAction)new SprintReportAction(backlog));
        }
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new OpenNewAtsWorldEditorSelectedAction(this.worldComposite));
        toolBarMgr.add((IAction)this.getWorldXViewer().getCustomizeAction());
        toolBarMgr.add((IContributionItem)new Separator());
        toolBarMgr.add((IAction)new ExpandAllAction((TreeViewer)this.worldComposite.getXViewer()));
        toolBarMgr.add((IAction)new CollapseAllAction((TreeViewer)this.worldComposite.getXViewer()));
        toolBarMgr.add((IContributionItem)new Separator());
        this.createDropDownMenuActions();
        toolBarMgr.add((IAction)new DropDownAction());
        super.createToolbar(managedForm);
        this.scrolledForm.updateToolBar();
        return toolBarMgr;
    }

    public WorldComposite getMembersSection() {
        return this.worldComposite;
    }

    @Override
    public WorldXViewer getWorldXViewer() {
        if (this.worldComposite == null) {
            return null;
        }
        return this.worldComposite.getWorldXViewer();
    }

    @Override
    public void relationsModifed(Collection<Artifact> relModifiedArts, Collection<Artifact> goalMemberReordered, Collection<Artifact> sprintMemberReordered) {
        if (goalMemberReordered.contains(this.provider.getArtifact()) || sprintMemberReordered.contains(this.provider.getArtifact())) {
            this.reload();
        } else if (relModifiedArts.contains(this.provider.getArtifact())) {
            this.refresh();
        }
    }

    @Override
    public boolean isDisposed() {
        return this.editor.isDisposed();
    }

    private void createActions() {
        this.setCollectorOrderAction = new SetCollectorOrderAction(this.provider, (CollectorArtifact)this.editor.getWorkItem(), this);
        RemoveFromCollectorAction.RemovedFromCollectorHandler handler = new RemoveFromCollectorAction.RemovedFromCollectorHandler(){

            @Override
            public void removedFromCollector(Collection<? extends Artifact> removed) {
                WfeMembersTab.this.worldComposite.getXViewer().setInput(WfeMembersTab.this.provider.getMembers());
            }
        };
        this.removeFromCollectorAction = new RemoveFromCollectorAction(this.provider, (CollectorArtifact)this.editor.getWorkItem(), this, handler);
        this.newActionToGoalAction = new NewActionToGoalAction(this.provider, (CollectorArtifact)this.editor.getWorkItem(), this);
        this.cloneActionToGoalAction = new CloneActionToGoalAction(this.provider, (CollectorArtifact)this.editor.getWorkItem(), this);
        this.printAgileTasksAction = new OpenAgileTasksAction(this);
    }

    @Override
    public void updateMenuActionsForTable() {
        MenuManager mm = this.worldComposite.getXViewer().getMenuManager();
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.setCollectorOrderAction);
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.removeFromCollectorAction);
        this.newActionToGoalAction.refreshText();
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.newActionToGoalAction);
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.cloneActionToGoalAction);
        mm.insertBefore("ATS WORLD EDIT", (IContributionItem)new Separator());
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.printAgileTasksAction);
        mm.insertBefore("ATS WORLD EDIT", (IContributionItem)new Separator());
    }

    @Override
    public Set<Artifact> getSelectedWorkflowArtifacts() {
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        for (Artifact art : this.worldComposite.getSelectedArtifacts()) {
            if (!(art instanceof AbstractWorkflowArtifact)) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<Artifact> getSelectedAtsArtifacts() {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact art : this.worldComposite.getSelectedArtifacts()) {
            if (!art.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AtsArtifact})) continue;
            artifacts.add(art);
        }
        return artifacts;
    }

    @Override
    public List<TaskArtifact> getSelectedTaskArtifacts() {
        ArrayList<TaskArtifact> tasks = new ArrayList<TaskArtifact>();
        for (Artifact art : this.worldComposite.getSelectedArtifacts()) {
            if (!(art instanceof TaskArtifact)) continue;
            tasks.add((TaskArtifact)art);
        }
        return tasks;
    }

    @Override
    public void reflow() {
    }

    @Override
    public void setTableTitle(String title, boolean warning) {
    }

    @Override
    public void reSearch() {
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                WfeMembersTab.this.reload();
            }
        };
        this.provider.deCacheAndReload(false, (IJobChangeListener)listener);
    }

    @Override
    public IWorldEditorProvider getWorldEditorProvider() {
        return null;
    }

    @Override
    public void createToolBarPulldown(Menu menu) {
    }

    @Override
    public String getCurrentTitleLabel() {
        return null;
    }

    protected void createDropDownMenuActions() {
        this.workflowMetricsUi.getOrCreateAction();
    }

    public WorldComposite getWorldComposite() {
        return this.worldComposite;
    }

    @Override
    public void handleColumnEvents(ArtifactEvent artifactEvent, WorldXViewer worldXViewer) {
    }

    public class DropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public DropDownAction() {
            this.setText("Other");
            this.setMenuCreator(this);
            this.setImageDescriptor(ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.GEAR));
            this.addKeyListener();
        }

        public Menu getMenu(Control parent) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(parent);
            this.addActionToMenu(this.fMenu, WfeMembersTab.this.workflowMetricsUi.getOrCreateAction());
            new MenuItem(this.fMenu, 2);
            WfeMembersTab.this.wfeMembersTabActions = new WfeMembersTabActions(WfeMembersTab.this.membersTab);
            WfeMembersTab.this.wfeMembersTabActions.createActions(this.fMenu);
            return this.fMenu;
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, Action action) {
            ActionContributionItem item = new ActionContributionItem((IAction)action);
            item.fill(parent, -1);
        }

        public void run() {
        }

        void clear() {
            this.dispose();
        }

        private void addKeyListener() {
            Tree tree = WfeMembersTab.this.worldComposite.getXViewer().getTree();
            GridData gridData = new GridData(1808);
            gridData.heightHint = 100;
            gridData.widthHint = 100;
            tree.setLayoutData((Object)gridData);
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            WfeMembersTab.this.worldComposite.getXViewer().getTree().addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent event) {
                }

                public void keyReleased(KeyEvent event) {
                    if ((event.stateMask & SWT.MODIFIER_MASK) == 262144) {
                        if (event.keyCode == 97) {
                            ((DropDownAction)DropDownAction.this).WfeMembersTab.this.worldComposite.getXViewer().getTree().setSelection(((DropDownAction)DropDownAction.this).WfeMembersTab.this.worldComposite.getXViewer().getTree().getItems());
                        } else if (event.keyCode == 120) {
                            ((DropDownAction)DropDownAction.this).WfeMembersTab.this.workflowMetricsUi.getOrCreateAction().setChecked(!((DropDownAction)DropDownAction.this).WfeMembersTab.this.workflowMetricsUi.getOrCreateAction().isChecked());
                            ((DropDownAction)DropDownAction.this).WfeMembersTab.this.workflowMetricsUi.getOrCreateAction().run();
                        }
                    }
                }
            });
        }
    }

    private class JumpScrollbarJob
    extends Job {
        public JumpScrollbarJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Displays.ensureInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Integer selection = idToScrollLocation.get(((JumpScrollbarJob)JumpScrollbarJob.this).WfeMembersTab.this.provider.getId());
                    ScrolledComposite sComp = null;
                    if (((JumpScrollbarJob)JumpScrollbarJob.this).WfeMembersTab.this.control == null || ((JumpScrollbarJob)JumpScrollbarJob.this).WfeMembersTab.this.control.isDisposed()) {
                        return;
                    }
                    Composite parent = ((JumpScrollbarJob)JumpScrollbarJob.this).WfeMembersTab.this.control.getParent();
                    while (parent != null) {
                        if (parent instanceof ScrolledComposite) {
                            sComp = (ScrolledComposite)parent;
                            break;
                        }
                        parent = parent.getParent();
                    }
                    if (sComp != null) {
                        sComp.setOrigin(0, selection.intValue());
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    private final class ReloadJobChangeAdapter
    extends JobChangeAdapter {
        private final WorkflowEditor editor;
        boolean firstTime = true;

        private ReloadJobChangeAdapter(WorkflowEditor editor) {
            this.editor = editor;
            WfeMembersTab.this.showBusy(true);
        }

        public void done(IJobChangeEvent event) {
            super.done(event);
            UIJob job = new UIJob("Draw Members Tab"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (ReloadJobChangeAdapter.this.firstTime) {
                        try {
                            try {
                                if (Widgets.isAccessible((Widget)((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeMembersTab.this.scrolledForm)) {
                                    WfeMembersTab.this.setLoading(false);
                                    boolean createdAndLoaded = WfeMembersTab.this.createMembersBody();
                                    if (!createdAndLoaded) {
                                        WfeMembersTab.this.reload();
                                    }
                                    WfeMembersTab.this.createToolbar(((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeMembersTab.this.managedForm);
                                    WfeMembersTab.this.jumptoScrollLocation();
                                    ((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeMembersTab.this.scrolledForm.reflow(true);
                                    ReloadJobChangeAdapter.this.editor.onDirtied();
                                }
                                ReloadJobChangeAdapter.this.firstTime = false;
                            }
                            catch (OseeCoreException ex) {
                                WfeMembersTab.this.handleException((Exception)((Object)ex));
                                WfeMembersTab.this.showBusy(false);
                            }
                        }
                        finally {
                            WfeMembersTab.this.showBusy(false);
                        }
                    } else {
                        WfeMembersTab.this.showBusy(false);
                        if (((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeMembersTab.this.managedForm != null && Widgets.isAccessible((Widget)((ReloadJobChangeAdapter)ReloadJobChangeAdapter.this).WfeMembersTab.this.managedForm.getForm())) {
                            WfeMembersTab.this.refresh();
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            Operations.scheduleJob((Job)job, (boolean)false, (int)20, null);
        }
    }
}

