/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.branch.graph.core.BranchGraphEditor;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphCache;
import org.eclipse.osee.framework.ui.branch.graph.model.GraphLoader;
import org.eclipse.osee.framework.ui.branch.graph.operation.IProgressListener;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class LoadGraphOperation
implements IExceptionableRunnable {
    private BranchId resource;
    private final GraphicalViewer viewer;
    private final BranchGraphEditor editor;
    private GraphCache graph;
    private static final int TOTAL_STEPS = Integer.MAX_VALUE;
    private static final int SHORT_TASK_STEPS = 42949672;
    private static final int VERY_LONG_TASK = 0x3FFFFFFF;
    private static final int TASK_STEPS = 472446404;

    protected LoadGraphOperation(IWorkbenchPart part, GraphicalViewer viewer, BranchGraphEditor editor) {
        this.viewer = viewer;
        this.editor = editor;
    }

    public LoadGraphOperation(IWorkbenchPart part, GraphicalViewer viewer, BranchGraphEditor editor, BranchId resource) {
        this(part, viewer, editor);
        this.resource = resource;
    }

    public String getName() {
        return "Loading graph information";
    }

    public IStatus run(IProgressMonitor monitor) throws Exception {
        block6: {
            boolean error = false;
            monitor.beginTask(this.getName(), Integer.MAX_VALUE);
            monitor.worked(42949672);
            try {
                try {
                    TransactionToken transaction = TransactionManager.getHeadTransaction((BranchId)this.resource);
                    BranchId path = transaction.getBranch();
                    monitor.setTaskName("Initializating cache");
                    monitor.worked(42949672);
                    if (this.editor == null) break block6;
                    if (error || monitor.isCanceled()) {
                        Displays.pendInDisplayThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchWindow window = LoadGraphOperation.this.editor.getEditorSite().getWorkbenchWindow();
                                IWorkbenchPage page = window.getActivePage();
                                page.activate((IWorkbenchPart)LoadGraphOperation.this.editor);
                                page.closeEditor((IEditorPart)LoadGraphOperation.this.editor, false);
                            }
                        });
                        break block6;
                    }
                    this.updateView(monitor, path, (TransactionId)transaction);
                }
                catch (Exception ex) {
                    AWorkbench.popup((String)"Error Calculating Revision Graph Information", (String)Lib.exceptionToString((Exception)ex));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }

    private void updateView(IProgressMonitor monitor, BranchId branch, TransactionId revision) {
        monitor.setTaskName("Finding root node");
        int unitWork = (int)(472446404L / revision.getId());
        if (unitWork < 1) {
            unitWork = 1;
        }
        monitor.setTaskName("Calculating graph");
        this.graph = new GraphCache(branch);
        GraphLoader.load(this.graph, new InternalTaskProgressListener(monitor, unitWork));
        monitor.setTaskName("Drawing graph");
        Displays.pendInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LoadGraphOperation.this.viewer.setContents((Object)LoadGraphOperation.this.graph);
                LoadGraphOperation.this.editor.setOutlineContent(LoadGraphOperation.this.graph);
            }
        });
    }

    private final class InternalTaskProgressListener
    implements IProgressListener {
        private final IProgressMonitor monitor;
        private final int unitWork;

        public InternalTaskProgressListener(IProgressMonitor monitor, int unitWork) {
            this.monitor = monitor;
            this.unitWork = unitWork;
        }

        @Override
        public void worked() {
            this.monitor.worked(this.unitWork);
        }
    }
}

