/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.OseeDataStoreException;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.core.util.OsgiUtil;
import org.eclipse.osee.framework.jdk.core.type.CompositeKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactFactory;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.AttributeLoader;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.ISearchConfirmer;
import org.eclipse.osee.framework.skynet.core.artifact.LoadType;
import org.eclipse.osee.framework.skynet.core.artifact.RelationLoader;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcStatement;

public final class ArtifactLoader {
    private static final ConcurrentHashMap<ArtifactToken, ReentrantLock> loadingActiveMap = new ConcurrentHashMap(1000);
    private static final OrcsTokenService tokenService = (OrcsTokenService)OsgiUtil.getService(ArtifactLoader.class, OrcsTokenService.class);

    public static List<Artifact> loadArtifacts(Collection<? extends ArtifactId> artIds, BranchId branch, LoadLevel loadLevel, LoadType reload, DeletionFlag allowDeleted) {
        return ArtifactLoader.loadArtifacts(artIds, branch, loadLevel, reload, allowDeleted, TransactionId.SENTINEL);
    }

    public static List<Artifact> loadArtifacts(Collection<? extends ArtifactId> artIds, BranchId branch, LoadLevel loadLevel, LoadType reload, DeletionFlag allowDeleted, TransactionId transactionId) {
        LinkedList<ArtifactToken> toLoad = new LinkedList<ArtifactToken>();
        for (ArtifactId artifactId : new HashSet<ArtifactId>(artIds)) {
            toLoad.add(ArtifactToken.valueOf((ArtifactId)artifactId, (BranchToken)BranchManager.getBranchToken(branch)));
        }
        LinkedHashSet<Artifact> linkedHashSet = new LinkedHashSet<Artifact>();
        boolean isArchived = BranchManager.isArchived(branch);
        if (transactionId.isValid()) {
            ArtifactLoader.loadArtifacts(toLoad, loadLevel, transactionId, reload, allowDeleted, linkedHashSet, branch, isArchived);
        } else {
            ArtifactLoader.loadActiveArtifacts(toLoad, linkedHashSet, loadLevel, reload, allowDeleted, branch, isArchived);
        }
        return new LinkedList<Artifact>(linkedHashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void loadActiveArtifacts(List<ArtifactToken> toLoad, Set<Artifact> artifacts, LoadLevel loadLevel, LoadType reload, DeletionFlag allowDeleted, BranchId branch, boolean isArchived) {
        block9: {
            if (toLoad.isEmpty() != false) return;
            numRequested = toLoad.size();
            iterator = toLoad.iterator();
            locks = new ConcurrentHashMap<ArtifactToken, ReentrantLock>();
            while (iterator.hasNext()) {
                artifact = iterator.next();
                active = null;
                if (reload == LoadType.INCLUDE_CACHE) {
                    var12_14 = ArtifactCache.class;
                    // MONITORENTER : org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache.class
                    active = ArtifactCache.getActive(artifact);
                    // MONITOREXIT : var12_14
                }
                if (!(doNotLoad = ArtifactLoader.determineIfIShouldLoad(artifacts, allowDeleted, locks, artifact, active))) continue;
                iterator.remove();
            }
            try {
                ArtifactLoader.loadArtifacts(toLoad, loadLevel, TransactionId.SENTINEL, reload, allowDeleted, artifacts, branch, isArchived);
            }
            finally {
                if (artifacts.size() == numRequested) break block9;
                ** for (artifact : toLoad)
            }
lbl-1000:
            // 1 sources

            {
                ArtifactLoader.removeAndUnlock(artifact);
                locks.remove(artifact);
                continue;
            }
        }
        ArtifactLoader.processLocks(locks, artifacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAndUnlock(ArtifactToken artifact) {
        ReentrantLock lock = null;
        ConcurrentHashMap<ArtifactToken, ReentrantLock> concurrentHashMap = loadingActiveMap;
        synchronized (concurrentHashMap) {
            lock = loadingActiveMap.remove(artifact);
        }
        if (lock != null && lock.isLocked()) {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean determineIfIShouldLoad(Set<Artifact> artifacts, DeletionFlag allowDeleted, ConcurrentHashMap<ArtifactToken, ReentrantLock> locks, ArtifactToken artifact, Artifact active) {
        boolean doNotLoad = false;
        if (active == null) {
            ConcurrentHashMap<ArtifactToken, ReentrantLock> concurrentHashMap = loadingActiveMap;
            synchronized (concurrentHashMap) {
                ReentrantLock lock = loadingActiveMap.get(artifact);
                if (lock == null) {
                    lock = new ReentrantLock();
                    lock.lock();
                    loadingActiveMap.put(artifact, lock);
                } else if (!lock.isHeldByCurrentThread()) {
                    locks.put(artifact, lock);
                    doNotLoad = true;
                }
            }
        } else {
            if (!active.isDeleted() || active.isDeleted() && allowDeleted == DeletionFlag.INCLUDE_DELETED) {
                artifacts.add(active);
            }
            doNotLoad = true;
        }
        return doNotLoad;
    }

    private static void processLocks(ConcurrentHashMap<ArtifactToken, ReentrantLock> locks, Set<Artifact> artifacts) {
        for (Map.Entry<ArtifactToken, ReentrantLock> entry : locks.entrySet()) {
            ArtifactToken artifact = entry.getKey();
            ReentrantLock lock = entry.getValue();
            lock.lock();
            lock.unlock();
            Artifact active = ArtifactCache.getActive(artifact);
            if (active == null) continue;
            artifacts.add(active);
        }
    }

    private static void loadArtifactsFromQueryId(Collection<Artifact> loadedItems, Long queryId, LoadLevel loadLevel, ISearchConfirmer confirmer, int fetchSize, LoadType reload, TransactionId transactionId, DeletionFlag allowDeleted, BranchToken branch, boolean isArchived) {
        boolean historical = transactionId.isValid();
        OseeSql sqlKey = historical && isArchived ? OseeSql.LOAD_HISTORICAL_ARCHIVED_ARTIFACTS : (isArchived ? OseeSql.LOAD_CURRENT_ARCHIVED_ARTIFACTS : (historical ? OseeSql.LOAD_HISTORICAL_ARTIFACTS : (allowDeleted == DeletionFlag.INCLUDE_DELETED ? OseeSql.LOAD_CURRENT_ARTIFACTS_WITH_DELETED : OseeSql.LOAD_CURRENT_ARTIFACTS)));
        String sql = null;
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            try {
                sql = ServiceUtil.getSql(sqlKey);
                chStmt.runPreparedQuery(fetchSize, sql, new Object[]{queryId});
                ArtifactId previousArtId = ArtifactId.SENTINEL;
                BranchId previousBranchId = BranchId.SENTINEL;
                Long previousViewId = -1L;
                while (chStmt.next()) {
                    ArtifactId artId = ArtifactId.valueOf((Long)chStmt.getLong("id2"));
                    Long viewId = chStmt.getLong("id4");
                    if (!(!previousArtId.notEqual((Id)artId) && !previousBranchId.notEqual((Id)branch) && previousViewId.equals(viewId) || historical && allowDeleted != DeletionFlag.INCLUDE_DELETED && ModificationType.valueOf((long)chStmt.getInt("mod_type")) == ModificationType.DELETED)) {
                        Artifact artifact = ArtifactLoader.retrieveShallowArtifact(chStmt, reload, historical, branch, isArchived);
                        loadedItems.add(artifact);
                    }
                    previousArtId = artId;
                    previousBranchId = branch;
                    previousViewId = viewId;
                }
            }
            catch (OseeDataStoreException ex) {
                OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"%s - %s", (Object[])new Object[]{sqlKey, sql == null ? "SQL unknown" : sql});
                throw ex;
            }
        }
        if (confirmer == null || confirmer.canProceed(loadedItems.size())) {
            ArtifactLoader.loadArtifactsData(queryId, loadedItems, loadLevel, reload, transactionId, allowDeleted, isArchived);
        }
    }

    private static void loadArtifacts(List<ArtifactToken> toLoad, LoadLevel loadLevel, TransactionId transactionId, LoadType reload, DeletionFlag allowDeleted, Set<Artifact> artifacts, BranchId branch, boolean isArchived) {
        if (toLoad != null && !toLoad.isEmpty()) {
            Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();
            for (ArtifactToken artifact : toLoad) {
                joinQuery.add((Id)branch, (Id)artifact, (Id)transactionId, (Id)branch.getViewId());
            }
            ArtifactLoader.loadArtifacts(artifacts, joinQuery, loadLevel, null, reload, transactionId, allowDeleted, branch, isArchived);
        }
    }

    private static void loadArtifacts(Collection<Artifact> loadedItems, Id4JoinQuery joinQuery, LoadLevel loadLevel, ISearchConfirmer confirmer, LoadType reload, TransactionId transactionId, DeletionFlag allowDeleted, BranchId branch, boolean isArchived) {
        if (!joinQuery.isEmpty()) {
            Collection<Artifact> data = loadedItems.isEmpty() ? loadedItems : new ArrayList<Artifact>(joinQuery.size());
            long time = System.currentTimeMillis();
            try {
                joinQuery.store();
                ArtifactLoader.loadArtifactsFromQueryId(data, joinQuery.getQueryId(), loadLevel, confirmer, joinQuery.size(), reload, transactionId, allowDeleted, BranchManager.getBranchToken(branch), isArchived);
            }
            catch (Throwable throwable) {
                try {
                    if (data != loadedItems) {
                        loadedItems.addAll(data);
                    }
                    OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"Artifact Load Time [%s] for [%d] artifacts. ", (Object[])new Object[]{Lib.getElapseString((long)time), loadedItems.size()});
                }
                finally {
                    joinQuery.close();
                }
                throw throwable;
            }
            try {
                if (data != loadedItems) {
                    loadedItems.addAll(data);
                }
                OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"Artifact Load Time [%s] for [%d] artifacts. ", (Object[])new Object[]{Lib.getElapseString((long)time), loadedItems.size()});
            }
            finally {
                joinQuery.close();
            }
        }
    }

    public static List<ArtifactId> selectArtifactIds(String sql, Object[] queryParameters, int artifactCountEstimate) {
        JdbcStatement chStmt = ConnectionHandler.getStatement();
        long time = System.currentTimeMillis();
        ArrayList<ArtifactId> toLoad = new ArrayList<ArtifactId>();
        try {
            chStmt.runPreparedQuery(artifactCountEstimate, sql, queryParameters);
            while (chStmt.next()) {
                toLoad.add(ArtifactId.valueOf((Long)chStmt.getLong("art_id")));
            }
        }
        finally {
            chStmt.close();
        }
        OseeLog.logf(Activator.class, (Level)Level.FINE, (String)"Artifact Selection Time [%s], [%d] artifacts selected", (Object[])new Object[]{Lib.getElapseString((long)time), toLoad.size()});
        return toLoad;
    }

    private static Artifact retrieveShallowArtifact(JdbcStatement chStmt, LoadType reload, boolean historical, BranchToken branch, boolean isArchived) {
        Artifact artifact;
        ArtifactId artifactId = ArtifactId.valueOf((Long)chStmt.getLong("id2"));
        TransactionToken transactionId = TransactionToken.SENTINEL;
        ApplicabilityId appId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
        if (historical) {
            transactionId = TransactionToken.valueOf((long)chStmt.getLong("stripe_transaction_id"), (BranchId)branch);
        }
        Artifact artifact2 = artifact = historical ? null : ArtifactCache.getActive(artifactId, (BranchId)branch);
        if (artifact == null) {
            ArtifactTypeToken artifactType = tokenService.getArtifactType(Long.valueOf(chStmt.getLong("art_type_id")));
            ArtifactFactory factory = ArtifactTypeManager.getFactory(artifactType);
            artifact = factory.loadExisitingArtifact(artifactId, chStmt.getString("guid"), artifactType, GammaId.valueOf((Long)chStmt.getLong("gamma_id")), branch, transactionId, ModificationType.valueOf((long)chStmt.getInt("mod_type")), appId, historical);
        }
        if (reload == LoadType.RELOAD_CACHE) {
            artifact.internalSetPersistenceData(GammaId.valueOf((Long)chStmt.getLong("gamma_id")), transactionId, ModificationType.valueOf((long)chStmt.getInt("mod_type")), appId, historical, true);
        }
        return artifact;
    }

    static void loadArtifactData(Artifact artifact, LoadLevel loadLevel, boolean isArchived) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Id4JoinQuery joinQuery = JoinUtility.createId4JoinQuery();){
            joinQuery.add((Id)artifact.getBranch(), (Id)artifact, (Id)TransactionId.SENTINEL, (Id)artifact.getBranch().getViewId());
            joinQuery.store();
            ArrayList<Artifact> artifacts = new ArrayList<Artifact>(1);
            artifacts.add(artifact);
            ArtifactLoader.loadArtifactsData(joinQuery.getQueryId(), artifacts, loadLevel, LoadType.INCLUDE_CACHE, TransactionId.SENTINEL, artifact.isDeleted() ? DeletionFlag.INCLUDE_DELETED : DeletionFlag.EXCLUDE_DELETED, isArchived);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void loadArtifactsData(Long queryId, Collection<Artifact> artifacts, LoadLevel loadLevel, LoadType reload, TransactionId transactionId, DeletionFlag allowDeleted, boolean isArchived) {
        if (reload == LoadType.RELOAD_CACHE) {
            for (Artifact artifact : artifacts) {
                artifact.prepareForReload();
            }
        }
        boolean historical = transactionId.isValid();
        CompositeKeyHashMap tempCache = new CompositeKeyHashMap(artifacts.size(), true);
        for (Artifact artifact : artifacts) {
            TransactionId key2 = historical ? transactionId : artifact.getBranch();
            tempCache.put((Object)artifact, (Object)key2, (Object)artifact);
        }
        AttributeLoader.loadAttributeData(queryId, (CompositeKeyHashMap<ArtifactId, Id, Artifact>)tempCache, historical, allowDeleted, loadLevel, isArchived, tokenService);
        RelationLoader.loadRelationData(queryId, artifacts, historical, loadLevel, tokenService);
        if (!historical) {
            for (Artifact artifact : artifacts) {
                ArtifactLoader.removeAndUnlock(artifact);
            }
        }
    }
}

