/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.reports.output;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.osee.ote.ui.define.reports.html.HtmlActiveTable;
import org.eclipse.osee.ote.ui.define.reports.html.HtmlActiveTableColumnData;
import org.eclipse.osee.ote.ui.define.reports.html.HtmlTableReport;
import org.eclipse.osee.ote.ui.define.reports.output.IReportWriter;

public class HtmlReportWriter
implements IReportWriter {
    private final HtmlTableReport report = new HtmlTableReport();
    private String reportHtml;

    public HtmlReportWriter() {
        this.report.getActiveTable().setTableTitle("Results");
    }

    @Override
    public void writeTitle(String title) {
        this.report.getActiveTable().setElementName("tbl" + new Date().getTime());
        this.report.setReportTitle(title);
    }

    @Override
    public void writeHeader(String[] headers) {
        HtmlActiveTable table = this.report.getActiveTable();
        Object[] metadata = new String[headers.length];
        Arrays.fill(metadata, "");
        int index = 0;
        while (index < headers.length) {
            table.addColumn(new HtmlActiveTableColumnData(headers[index], (String)metadata[index]));
            ++index;
        }
    }

    @Override
    public void writeRow(String ... cellData) {
        this.report.getActiveTable().addDataRow(cellData);
    }

    @Override
    public int length() throws IOException {
        if (this.reportHtml == null) {
            this.generate();
        }
        return this.reportHtml.length();
    }

    @Override
    public String getReport() throws IOException {
        if (this.reportHtml == null) {
            this.generate();
        }
        return this.reportHtml;
    }

    @Override
    public void writeToOutput(OutputStream outputStream) throws IOException {
        outputStream.write(this.getReport().getBytes("UTF-8"));
    }

    private void generate() throws IOException {
        this.reportHtml = this.report.generate();
    }
}

