/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.messaging.internal;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.JMSException;
import javax.jms.Message;
import org.eclipse.osee.framework.messaging.MessageID;
import org.eclipse.osgi.framework.console.CommandInterpreter;

public class ConsoleDebugSupport {
    private boolean printSends;
    private boolean printReceives;
    private final Map<MessageID, Stats> sends = new ConcurrentHashMap<MessageID, Stats>();
    private final Map<String, Stats> receives = new ConcurrentHashMap<String, Stats>();

    protected void setPrintSends(boolean printSends) {
        this.printSends = printSends;
    }

    public boolean getPrintSends() {
        return this.printSends;
    }

    public boolean getPrintReceives() {
        return this.printReceives;
    }

    public void setPrintReceives(boolean printReceives) {
        this.printReceives = printReceives;
    }

    public void addSend(MessageID messageId) {
        Stats stats = this.sends.get(messageId);
        if (stats == null) {
            stats = new Stats();
            this.sends.put(messageId, stats);
        }
        stats.add(messageId);
    }

    public void addReceive(Message jmsMessage) {
        String id = null;
        try {
            id = jmsMessage.getJMSMessageID();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        if (id != null) {
            Stats stats = this.receives.get(id);
            if (stats == null) {
                stats = new Stats();
                this.receives.put(id, stats);
            }
            stats.add(jmsMessage);
        }
    }

    public void printAllStats(CommandInterpreter ci) {
        this.printTxStats(ci);
        this.printRxStats(ci);
    }

    public void printTxStats(CommandInterpreter ci) {
        ci.println((Object)"TxStats:");
        for (MessageID id : this.sends.keySet()) {
            Stats status = this.sends.get(id);
            ci.println((Object)id);
            ci.println((Object)status);
            ci.println((Object)"------------------------------");
        }
    }

    public void printRxStats(CommandInterpreter ci) {
        ci.println((Object)"RxStats:");
        for (String id : this.receives.keySet()) {
            Stats status = this.sends.get(id);
            ci.println((Object)id);
            ci.println((Object)status);
            ci.println((Object)"------------------------------");
        }
    }

    private class Stats {
        private int count = 0;
        private Date lastReceipt;

        private Stats() {
        }

        public void add(MessageID messageId) {
            this.lastReceipt = new Date();
            ++this.count;
        }

        public void add(Message jmsMessage) {
            this.lastReceipt = new Date();
            ++this.count;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.count);
            sb.append(" : ");
            sb.append(this.lastReceipt);
            return sb.toString();
        }
    }
}

