/*********************************************************************
 * Copyright (c) 2019 Boeing
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Boeing - initial API and implementation
 **********************************************************************/

package org.eclipse.osee.framework.core.enums.token;

import javax.ws.rs.core.MediaType;
import org.eclipse.osee.framework.core.data.AttributeTypeEnum;
import org.eclipse.osee.framework.core.data.NamespaceToken;
import org.eclipse.osee.framework.core.data.TaggerTypeToken;
import org.eclipse.osee.framework.core.enums.EnumToken;
import org.eclipse.osee.framework.core.enums.token.CsciAttributeType.CsciEnum;

/**
 * @author Roberto E. Escobar
 */

public class CsciAttributeType extends AttributeTypeEnum<CsciEnum> {

   public final CsciEnum CoreUnit = new CsciEnum(0, "CoreUnit");
   public final CsciEnum Framework = new CsciEnum(1, "Framework");
   public final CsciEnum Interface = new CsciEnum(2, "Interface");
   public final CsciEnum Navigation = new CsciEnum(3, "Navigation");
   public final CsciEnum Unspecified = new CsciEnum(4, "Unspecified");
   public final CsciEnum Visual = new CsciEnum(5, "Visual");

   public CsciAttributeType(NamespaceToken namespace, int enumCount) {
      super(1152921504606847136L, namespace, "CSCI", MediaType.TEXT_PLAIN, "", TaggerTypeToken.PlainTextTagger,
         enumCount);
   }

   public CsciAttributeType() {
      this(NamespaceToken.OSEE, 6);
   }

   public class CsciEnum extends EnumToken {
      public CsciEnum(int ordinal, String name) {
         super(ordinal, name);
         addEnum(this);
      }
   }
}