/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.executor;

import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.framework.core.executor.HasCancellation;

public class Cancellable
implements HasCancellation {
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    @Override
    public boolean isCancelled() {
        this.cancelled.compareAndSet(false, Thread.currentThread().isInterrupted());
        return this.cancelled.get();
    }

    @Override
    public void setCancel(boolean isCancelled) {
        this.cancelled.set(isCancelled);
    }

    @Override
    public void checkForCancelled() throws CancellationException {
        if (this.isCancelled()) {
            throw new CancellationException();
        }
    }
}

