/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.util;

import java.io.File;
import java.util.LinkedList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class DirectoryOrFileSelector
extends Composite
implements Listener {
    private final Button radDirectory;
    private final Button radSingleFile;
    private final Text txtDirectory;
    private final Text txtFiles;
    private final Button btnDirectory;
    private final Button btnSingleFile;
    private final int singleOrMulti;
    public static final String FILE_SEPARATOR = ",";

    public DirectoryOrFileSelector(Composite parent, int style, String name, Listener listener) {
        this(parent, style, name, listener, false);
    }

    public DirectoryOrFileSelector(Composite parent, int style, String name, Listener listener, boolean multiFileSelect) {
        super(parent, style);
        GridLayout gdMain = new GridLayout();
        gdMain.marginHeight = 0;
        gdMain.marginWidth = 0;
        this.setLayout((Layout)gdMain);
        this.setLayoutData(new GridData(768));
        Group composite = new Group((Composite)this, style);
        composite.setText(name);
        GridLayout gd = new GridLayout();
        gd.numColumns = 3;
        composite.setLayout((Layout)gd);
        composite.setLayoutData((Object)new GridData(768));
        this.singleOrMulti = multiFileSelect ? 2 : 4;
        this.radDirectory = new Button((Composite)composite, 16);
        this.radDirectory.setText("Directory:");
        this.radDirectory.addListener(13, (Listener)this);
        this.radDirectory.addListener(13, listener);
        this.txtDirectory = new Text((Composite)composite, 2052);
        this.txtDirectory.setLayoutData((Object)new GridData(768));
        this.txtDirectory.addListener(24, (Listener)this);
        this.txtDirectory.addListener(24, listener);
        this.btnDirectory = new Button((Composite)composite, 8);
        this.btnDirectory.setText("&Browse...");
        this.btnDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File directory = DirectoryOrFileSelector.this.selectDirectory();
                if (directory != null && directory.isDirectory()) {
                    DirectoryOrFileSelector.this.txtDirectory.setText(directory.getPath());
                }
            }
        });
        this.radSingleFile = new Button((Composite)composite, 16);
        this.radSingleFile.setText("File" + (multiFileSelect ? "(s):" : ":"));
        this.radSingleFile.addListener(13, (Listener)this);
        this.radSingleFile.addListener(13, listener);
        this.txtFiles = new Text((Composite)composite, 2052);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 250;
        this.txtFiles.setLayoutData((Object)layoutData);
        this.txtFiles.addListener(24, (Listener)this);
        this.txtFiles.addListener(24, listener);
        this.btnSingleFile = new Button((Composite)composite, 8);
        this.btnSingleFile.setText("&Browse...");
        this.btnSingleFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Iterable<File> files = DirectoryOrFileSelector.this.selectFiles();
                LinkedList<String> paths = new LinkedList<String>();
                for (File file : files) {
                    if (file == null || !file.isFile()) continue;
                    paths.add(file.getPath());
                }
                DirectoryOrFileSelector.this.setText(Collections.toString((String)DirectoryOrFileSelector.FILE_SEPARATOR, paths));
            }
        });
    }

    private void updateWidgetEnablements() {
        boolean directorySelected = this.radDirectory.getSelection();
        this.txtDirectory.setEnabled(directorySelected);
        this.btnDirectory.setEnabled(directorySelected);
        this.txtFiles.setEnabled(!directorySelected);
        this.btnSingleFile.setEnabled(!directorySelected);
    }

    public Iterable<File> getSelection() {
        String path = this.isDirectorySelected() ? this.txtDirectory.getText() : this.txtFiles.getText();
        return Strings.isValid((String)path) ? this.getFiles(path) : null;
    }

    public File getSingleSelection() {
        File toReturn = null;
        Iterable<File> selection = this.getSelection();
        if (selection != null) {
            toReturn = selection.iterator().next();
        }
        return toReturn;
    }

    private Iterable<File> getFiles(String paths) {
        LinkedList<File> toReturn = new LinkedList<File>();
        String[] stringArray = paths.split(FILE_SEPARATOR);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            toReturn.add(new File(path));
            ++n2;
        }
        return toReturn;
    }

    public String getText() {
        return (this.isDirectorySelected() ? this.txtDirectory : this.txtFiles).getText();
    }

    public boolean isDirectorySelected() {
        return this.radDirectory.getSelection();
    }

    public void setDirectorySelected(boolean selected) {
        this.radDirectory.setSelection(selected);
        this.radSingleFile.setSelection(!selected);
        this.updateWidgetEnablements();
    }

    public void setText(String text) {
        (this.isDirectorySelected() ? this.txtDirectory : this.txtFiles).setText(text);
    }

    public boolean validate(WizardDataTransferPage wizardPage) {
        Iterable<File> files = this.getSelection();
        boolean toReturn = false;
        if (files != null) {
            if (this.isDirectorySelected()) {
                toReturn = files.iterator().next().isDirectory();
            } else {
                toReturn = true;
                for (File file : files) {
                    toReturn &= file.isFile();
                }
            }
        }
        if (!toReturn) {
            wizardPage.setErrorMessage(String.valueOf(this.getText()) + " is not a " + (this.isDirectorySelected() ? "directory" : "file"));
        }
        return toReturn;
    }

    private String getFilterPath() {
        File first;
        String toReturn = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        Iterable<File> file = this.getSelection();
        if (file != null && Strings.isValid((String)(first = file.iterator().next()).getAbsolutePath())) {
            toReturn = first.getAbsolutePath();
        }
        return toReturn;
    }

    private Iterable<File> selectFiles() {
        FileDialog dialog = new FileDialog(this.getShell(), 0x1000 | this.singleOrMulti);
        dialog.setFilterPath(this.getFilterPath());
        String path = dialog.open();
        if (path != null) {
            String selectedPath = dialog.getFilterPath();
            LinkedList<File> files = new LinkedList<File>();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                files.add(new File(String.valueOf(selectedPath) + '/' + filename));
                ++n2;
            }
            return files;
        }
        return null;
    }

    private File selectDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 4096);
        dialog.setFilterPath(this.getFilterPath());
        String path = dialog.open();
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    public void handleEvent(Event event) {
        this.updateWidgetEnablements();
    }
}

