/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import java.util.HashSet;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.MenuService;
import org.eclipse.e4.ui.internal.workbench.swt.Policy;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.MExpression;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.ContributionRecord;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuManagerRendererFilter
implements Listener {
    private static final String MMRF_STATIC_CONTEXT = "HCI-staticContext";
    public static final String NUL_MENU_ITEM = "(None Applicable)";
    static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    @Inject
    private Logger logger;
    @Inject
    private EModelService modelService;
    @Inject
    private MenuManagerRenderer renderer;
    private HashMap<Menu, Runnable> pendingCleanup = new HashMap();
    private SafeWrapper safeWrapper = new SafeWrapper();

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(String.valueOf(msg) + ": " + menu + ": " + menuModel), null);
    }

    public void handleEvent(Event event) {
        this.safeWrapper.event = event;
        SafeRunner.run((ISafeRunnable)this.safeWrapper);
    }

    private void safeHandleEvent(Event event) {
        Object tmp;
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)event.widget;
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        if (event.type == 12) {
            if (Policy.DEBUG_MENUS) {
                MenuManagerRendererFilter.trace("handleMenu.Dispose", (Widget)menu, null);
            }
            this.cleanUp(menu, null, null);
            return;
        }
        MenuManager menuManager = null;
        Object obj = menu.getData("modelElement");
        if (obj == null && (tmp = menu.getData("org.eclipse.jface.action.MenuManager.managerKey")) instanceof MenuManager) {
            MUIElement container;
            MPopupMenu popupMenu;
            MenuManager tmpManager;
            menuManager = tmpManager = (MenuManager)tmp;
            obj = this.renderer.getMenuModel(tmpManager);
            if (obj instanceof MPopupMenu && (popupMenu = (MPopupMenu)obj).getWidget() == null && menuManager.getMenu() != null && (container = this.modelService.getContainer((MUIElement)popupMenu)) instanceof MPart) {
                MenuService.registerMenu((Control)menuManager.getMenu().getParent(), (MPopupMenu)popupMenu, (IEclipseContext)((MPart)container).getContext());
            }
        }
    }

    public static void collectInfo(ExpressionInfo info, MMenu menuModel, MenuManagerRenderer renderer, IEclipseContext evalContext, boolean recurse) {
        HashSet<ContributionRecord> records = new HashSet<ContributionRecord>();
        for (MMenuElement element : menuModel.getChildren()) {
            ContributionRecord record = renderer.getContributionRecord(element);
            if (record != null) {
                if (records.add(record)) {
                    record.collectInfo(info);
                }
            } else {
                ContributionsAnalyzer.collectInfo((ExpressionInfo)info, (MExpression)element.getVisibleWhen());
            }
            if (!recurse || !(element instanceof MMenu)) continue;
            MMenu childMenu = (MMenu)element;
            MenuManagerRendererFilter.collectInfo(info, childMenu, renderer, evalContext, false);
        }
    }

    public static void updateElementVisibility(MMenu menuModel, MenuManagerRenderer renderer, MenuManager menuManager, IEclipseContext evalContext, int recurseLevel, boolean updateEnablement) {
        ExpressionContext exprContext = new ExpressionContext(evalContext);
        HashSet<ContributionRecord> records = new HashSet<ContributionRecord>();
        for (MMenuElement element : menuModel.getChildren()) {
            MMenu childMenu;
            MenuManager childManager;
            ContributionRecord record = renderer.getContributionRecord(element);
            if (record != null) {
                if (records.add(record)) {
                    record.updateVisibility(evalContext);
                }
            } else {
                MenuManagerRenderer.updateVisibility(menuManager, element, exprContext);
            }
            if (recurseLevel > 0 && element.isVisible() && element instanceof MMenu && (childManager = renderer.getManager(childMenu = (MMenu)element)) != null) {
                MenuManagerRendererFilter.updateElementVisibility(childMenu, renderer, childManager, evalContext, recurseLevel - 1, false);
            }
            if (updateEnablement && element instanceof MHandledMenuItem) {
                ParameterizedCommand cmd = ((MHandledMenuItem)element).getWbCommand();
                EHandlerService handlerService = (EHandlerService)evalContext.get(EHandlerService.class);
                if (cmd == null || handlerService == null) continue;
                MHandledMenuItem item = (MHandledMenuItem)element;
                IEclipseContext staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
                ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
                try {
                    ((MHandledMenuItem)element).setEnabled(handlerService.canExecute(cmd, staticContext));
                    continue;
                }
                finally {
                    staticContext.dispose();
                }
            }
            if (updateEnablement && OpaqueElementUtil.isOpaqueMenuItem((MUIElement)element)) {
                Object obj = OpaqueElementUtil.getOpaqueItem((MUIElement)element);
                if (!(obj instanceof IContributionItem)) continue;
                IContributionItem ici = (IContributionItem)obj;
                ici.update();
                ((MItem)element).setEnabled(ici.isEnabled());
                continue;
            }
            if (!updateEnablement || !(element instanceof MDirectMenuItem)) continue;
            MDirectMenuItem contrib = (MDirectMenuItem)element;
            if (contrib.getObject() == null) {
                IContributionFactory icf = (IContributionFactory)evalContext.get(IContributionFactory.class);
                contrib.setObject(icf.create(contrib.getContributionURI(), evalContext, EclipseContextFactory.create()));
            }
            if (contrib.getObject() == null) {
                contrib.setEnabled(false);
                continue;
            }
            MDirectMenuItem item = (MDirectMenuItem)element;
            IEclipseContext staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
            ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
            try {
                Object rc = ContextInjectionFactory.invoke((Object)contrib.getObject(), CanExecute.class, (IEclipseContext)evalContext, (IEclipseContext)staticContext, (Object)Boolean.TRUE);
                if (!(rc instanceof Boolean)) continue;
                contrib.setEnabled(((Boolean)rc).booleanValue());
            }
            finally {
                staticContext.dispose();
            }
        }
    }

    void setEnabled(MHandledMenuItem item) {
        if (!item.isToBeRendered() || !item.isVisible() || item.getWidget() == null) {
            return;
        }
        ParameterizedCommand cmd = item.getWbCommand();
        if (cmd == null) {
            return;
        }
        IEclipseContext lclContext = this.renderer.getContext((MUIElement)item);
        EHandlerService service = (EHandlerService)lclContext.get(EHandlerService.class);
        IEclipseContext staticContext = EclipseContextFactory.create((String)MMRF_STATIC_CONTEXT);
        ContributionsAnalyzer.populateModelInterfaces((Object)item, (IEclipseContext)staticContext, (Class[])item.getClass().getInterfaces());
        try {
            item.setEnabled(service.canExecute(cmd, staticContext));
        }
        finally {
            staticContext.dispose();
        }
    }

    public void cleanUp(Menu menu, MMenu menuModel, MenuManager menuManager) {
        if (Policy.DEBUG_MENUS) {
            MenuManagerRendererFilter.trace("cleanUp", (Widget)menu, null);
        }
        if (this.pendingCleanup.isEmpty()) {
            return;
        }
        Runnable cleanUp = this.pendingCleanup.remove(menu);
        if (cleanUp != null) {
            if (Policy.DEBUG_MENUS) {
                MenuManagerRendererFilter.trace("cleanUp.run()", (Widget)menu, null);
            }
            cleanUp.run();
        }
    }

    public void dispose() {
        Menu[] keys;
        Menu[] menuArray = keys = this.pendingCleanup.keySet().toArray(new Menu[this.pendingCleanup.size()]);
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Menu menu = menuArray[n2];
            this.cleanUp(menu, null, null);
            ++n2;
        }
    }

    private class SafeWrapper
    implements ISafeRunnable {
        Event event;

        private SafeWrapper() {
        }

        public void handleException(Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            if (MenuManagerRendererFilter.this.logger != null) {
                MenuManagerRendererFilter.this.logger.error(e);
            }
        }

        public void run() throws Exception {
            MenuManagerRendererFilter.this.safeHandleEvent(this.event);
        }
    }
}

