/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class UsersByIds {
    public static Pattern userPattern = Pattern.compile("<(.*?)>");

    public static String getStorageString(Collection<User> users) {
        StringBuffer sb = new StringBuffer();
        for (User u : users) {
            sb.append("<" + u.getUserId() + ">");
        }
        return sb.toString();
    }

    public static List<User> getUsers(String sorageString) {
        ArrayList<User> users = new ArrayList<User>();
        Matcher m = userPattern.matcher(sorageString);
        while (m.find()) {
            String userId = m.group(1);
            if (!Strings.isValid((String)userId)) {
                throw new IllegalArgumentException("Blank userId specified.");
            }
            try {
                User u = UserManager.getUserByUserId(m.group(1));
                users.add(u);
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return users;
    }
}

