/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.sorters;

import java.util.Collections;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.enums.RelationSorter;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactNameComparator;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactNameRelationLinkComparator;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.order.IRelationSorter;

public class LexicographicalRelationSorter
implements IRelationSorter {
    private final RelationSorter id;
    private final boolean isDescending;

    public LexicographicalRelationSorter(SortMode sortMode) {
        this.isDescending = SortMode.DESCENDING == sortMode;
        this.id = this.isDescending ? RelationSorter.LEXICOGRAPHICAL_DESC : RelationSorter.LEXICOGRAPHICAL_ASC;
    }

    @Override
    public RelationSorter getSorterId() {
        return this.id;
    }

    @Override
    public void sort(List<? extends ArtifactToken> relatives, List<String> relativeSequence) {
        ArtifactNameComparator comparator = new ArtifactNameComparator(this.isDescending);
        Collections.sort(relatives, comparator);
    }

    @Override
    public void sortRelations(List<? extends RelationLink> relatives, List<String> relativeSequence) {
        ArtifactNameRelationLinkComparator comparator = new ArtifactNameRelationLinkComparator(this.isDescending);
        Collections.sort(relatives, comparator);
    }

    public static enum SortMode {
        ASCENDING,
        DESCENDING;

    }
}

