/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.change.ChangeItem;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.UserManager;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.ArtifactDelta;

public abstract class Change
implements IAdaptable,
Comparable<Change>,
HasBranchId {
    private final GammaId sourceGamma;
    private final ArtifactId artId;
    private final TransactionDelta txDelta;
    private final ArtifactDelta artifactDelta;
    private final ModificationType modType;
    private final BranchToken branch;
    private final boolean isHistorical;
    private final Artifact changeArtifact;
    private ChangeItem changeItem;
    public static Boolean showTokenForChangeName;

    public Change(BranchToken branch, GammaId sourceGamma, ArtifactId artId, TransactionDelta txDelta, ModificationType modType, boolean isHistorical, Artifact changeArtifact, ArtifactDelta artifactDelta) {
        this.branch = branch;
        this.sourceGamma = sourceGamma;
        this.artId = artId;
        this.txDelta = txDelta;
        this.modType = modType;
        this.isHistorical = isHistorical;
        this.artifactDelta = artifactDelta;
        this.changeArtifact = changeArtifact;
    }

    public ChangeItem getChangeItem() {
        return this.changeItem;
    }

    public void setChangeItem(ChangeItem changeItem) {
        this.changeItem = changeItem;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Change) {
            Change change = (Change)obj;
            boolean areDeltasEqual = false;
            if (change.getDelta() != null && this.getDelta() != null) {
                areDeltasEqual = change.getDelta().equals(this.getDelta());
            } else if (change.getDelta() == null && this.getDelta() == null) {
                areDeltasEqual = true;
            }
            return areDeltasEqual && change.getArtId().equals(this.getArtId()) && change.getGamma() == this.getGamma() && change.getChangeArtifact().equals((Object)this.getChangeArtifact()) && change.getModificationType().equals(this.getModificationType()) && change.getTxDelta().equals((Object)this.getTxDelta());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 7;
        hashCode += 13 * this.getArtId().hashCode();
        hashCode += 13 * this.getGamma().hashCode();
        hashCode += 13 * this.getChangeArtifact().hashCode();
        hashCode += this.getDelta() != null ? 13 * this.getDelta().hashCode() : 0;
        hashCode += this.getModificationType() != null ? 13 * this.getModificationType().hashCode() : 0;
        return hashCode += this.getTxDelta() != null ? 13 * this.getTxDelta().hashCode() : 0;
    }

    public GammaId getBaselineGamma() {
        return this.changeItem.getBaselineVersion().getGammaId();
    }

    public boolean isBaseline() {
        return this.changeItem.getBaselineVersion().isValid();
    }

    public boolean isHistorical() {
        return this.isHistorical;
    }

    public ModificationType getModificationType() {
        return this.modType;
    }

    public ArtifactDelta getDelta() {
        return this.artifactDelta;
    }

    public Artifact getChangeArtifact() {
        return this.changeArtifact;
    }

    public String getArtifactNameOrToken() {
        if (UserManager.isShowTokenForChangeName()) {
            return this.getChangeArtifact().toStringWithId();
        }
        return this.getChangeArtifact().getName();
    }

    public String getArtifactName() {
        return this.getChangeArtifact().getName();
    }

    public GammaId getGamma() {
        return this.sourceGamma;
    }

    public ArtifactId getArtId() {
        return this.artId;
    }

    public TransactionDelta getTxDelta() {
        return this.txDelta;
    }

    public abstract Id getItemTypeId();

    public ArtifactTypeToken getArtifactType() {
        return this.getChangeArtifact().getArtifactType();
    }

    public BranchToken getBranch() {
        return this.branch;
    }

    public abstract String getIsValue();

    public abstract String getWasValue();

    public abstract String getItemTypeName();

    public abstract String getNameOrToken();

    public abstract String getName();

    public abstract String getItemKind();

    public abstract Id getItemId();

    public abstract ChangeType getChangeType();

    public <T> T getAdapter(Class<T> type) {
        Object toReturn = null;
        if (type != null) {
            if (type.isAssignableFrom(Artifact.class)) {
                toReturn = this.getChangeArtifact();
            } else if (this.isHistorical() && type.isInstance(this.getTxDelta().getEndTx())) {
                toReturn = this.getTxDelta().getEndTx();
            } else if (type.isAssignableFrom(this.getClass())) {
                toReturn = this;
            }
        }
        return (T)toReturn;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Change o) {
        return this.getName().compareTo(o.getName());
    }
}

