/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.client.OseeClient;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.UpdateBranchData;
import org.eclipse.osee.framework.core.enums.BranchState;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.operation.FinishUpdateBranchOperation;
import org.eclipse.osee.framework.skynet.core.artifact.update.ConflictResolverOperation;
import org.eclipse.osee.framework.skynet.core.conflict.ConflictManagerExternal;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.orcs.rest.model.BranchEndpoint;

public class UpdateBranchOperation
extends AbstractOperation {
    private final BranchToken originalBranch;
    private final BranchId fromBranch;
    private final ConflictResolverOperation resolver;
    private BranchToken newBranch;
    private UpdateBranchData branchData;

    public UpdateBranchOperation(BranchToken branch, ConflictResolverOperation resolver) {
        this(branch, (BranchId)BranchManager.getParentBranch((BranchId)branch), resolver);
    }

    public UpdateBranchOperation(BranchToken branch, BranchId fromBranch, ConflictResolverOperation resolver) {
        super(String.format("Update Branch [%s]", branch.getShortName()), "org.eclipse.osee.framework.skynet.core");
        this.originalBranch = branch;
        this.fromBranch = fromBranch;
        this.resolver = resolver;
        this.branchData = new UpdateBranchData();
    }

    private static String getUpdatedName(String branchName) {
        String storeName = Strings.truncate((String)branchName, (int)100);
        return String.format("%s - for update - %s", storeName, Lib.getDateTimeString());
    }

    public UpdateBranchData run() {
        Operations.executeWorkAndCheckStatus((IOperation)this);
        return this.branchData;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        if (!(this.originalBranch == null || BranchManager.hasMergeBranches((BranchId)this.originalBranch) || BranchManager.getState((BranchId)this.originalBranch).isCommitted() || BranchManager.getState((BranchId)this.originalBranch).equals((Object)BranchState.REBASELINE_IN_PROGRESS))) {
            this.performUpdate(monitor, this.originalBranch);
        }
    }

    private void performUpdate(IProgressMonitor monitor, BranchToken originalBranch) throws Exception {
        boolean wasSuccessful = false;
        OseeClient client = ServiceUtil.getOseeClient();
        BranchEndpoint branchEp = client.getBranchEndpoint();
        BranchState originalState = BranchManager.getState((BranchId)originalBranch);
        try {
            BranchManager.setState((BranchId)originalBranch, BranchState.REBASELINE_IN_PROGRESS);
            monitor.setTaskName("Creating temporary branch");
            String originalBranchName = originalBranch.getName();
            this.branchData.setToName(UpdateBranchOperation.getUpdatedName(originalBranchName));
            this.branchData.setToBranch((BranchId)originalBranch);
            this.branchData.setFromBranch(this.fromBranch);
            this.branchData = branchEp.updateBranch(this.fromBranch, this.branchData);
            this.branchData.setNeedsMerge(BranchManager.hasChanges((BranchId)originalBranch));
            this.newBranch = BranchManager.getBranchToken(this.branchData.getNewBranchId());
            monitor.worked(this.calculateWork(0.4));
            if (this.branchData.isNeedsMerge()) {
                this.commitOldWorkingIntoNewWorkingBranch(monitor, (BranchId)originalBranch, (BranchId)this.newBranch, 0.4);
            } else {
                this.deleteOldAndSetNewAsWorking(monitor, originalBranch, (BranchId)this.newBranch, 0.4);
            }
            wasSuccessful = true;
        }
        catch (Throwable throwable) {
            if (this.newBranch != null && !wasSuccessful) {
                BranchManager.purgeBranch((BranchId)this.newBranch);
                BranchManager.setState((BranchId)originalBranch, originalState);
            }
            monitor.worked(this.calculateWork(0.2));
            branchEp.logBranchActivity(String.format("Branch Operation Update Branch {branchUUID: %s, branchName: %s fromBranch: %s", originalBranch.getIdString(), originalBranch.getName(), this.fromBranch));
            throw throwable;
        }
        if (this.newBranch != null && !wasSuccessful) {
            BranchManager.purgeBranch((BranchId)this.newBranch);
            BranchManager.setState((BranchId)originalBranch, originalState);
        }
        monitor.worked(this.calculateWork(0.2));
        branchEp.logBranchActivity(String.format("Branch Operation Update Branch {branchUUID: %s, branchName: %s fromBranch: %s", originalBranch.getIdString(), originalBranch.getName(), this.fromBranch));
    }

    private void commitOldWorkingIntoNewWorkingBranch(IProgressMonitor monitor, BranchId originalBranch, BranchId newWorkingBranch, double workPercentage) throws Exception {
        AbstractOperation operation;
        monitor.setTaskName("Checking for Conflicts");
        ConflictManagerExternal conflictManager = new ConflictManagerExternal(newWorkingBranch, originalBranch);
        if (!conflictManager.remainingConflictsExist()) {
            operation = new FinishUpdateBranchOperation(conflictManager, true, false);
        } else {
            operation = this.resolver;
            this.resolver.setConflictManager(conflictManager);
        }
        this.doSubWork((IOperation)operation, monitor, workPercentage);
    }

    private void deleteOldAndSetNewAsWorking(IProgressMonitor monitor, BranchToken originalBranch, BranchId newWorkingBranch, double workPercentage) throws Exception {
        String originalBranchName = originalBranch.getName();
        BranchManager.setName((BranchId)originalBranch, UpdateBranchOperation.getUpdatedName(originalBranchName));
        monitor.worked(this.calculateWork(0.2));
        BranchManager.setName(newWorkingBranch, originalBranchName);
        BranchManager.setAssociatedArtifactId(newWorkingBranch, BranchManager.getAssociatedArtifactId((BranchId)originalBranch));
        BranchManager.setState((BranchId)originalBranch, BranchState.REBASELINED);
        BranchManager.deleteBranch((BranchId)originalBranch).join();
        monitor.worked(this.calculateWork(workPercentage));
    }

    public BranchToken getNewBranch() {
        return this.newBranch;
    }
}

