/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.internal;

import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.workdef.IStateToken;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.state.IAtsStateManager;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class PercentCompleteSMAStateUtil {
    public static int getPercentCompleteSMAState(Artifact artifact) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
            if (AtsApiService.get().getWorkItemService().getTeams((Object)artifact).size() == 1) {
                return PercentCompleteSMAStateUtil.getPercentCompleteSMAState(AtsApiService.get().getQueryServiceIde().getArtifact(AtsApiService.get().getWorkItemService().getFirstTeam((Object)artifact)));
            }
            double percent = 0.0;
            int items = 0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams((Object)artifact)) {
                if (team.isCancelled()) continue;
                percent += (double)PercentCompleteSMAStateUtil.getPercentCompleteSMAState(AtsApiService.get().getQueryServiceIde().getArtifact(team));
                ++items;
            }
            if (items > 0) {
                Double rollPercent = percent / (double)items;
                return rollPercent.intValue();
            }
            return 0;
        }
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            return PercentCompleteSMAStateUtil.getPercentCompleteSMAState(artifact, PercentCompleteSMAStateUtil.getStateManager(artifact).getCurrentState());
        }
        return 0;
    }

    public static int getPercentCompleteSMAState(Artifact artifact, IStateToken state) {
        if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) {
            return PercentCompleteSMAStateUtil.getStateManager(artifact).getPercentComplete(state.getName());
        }
        return 0;
    }

    private static IAtsStateManager getStateManager(Artifact artifact) {
        return PercentCompleteSMAStateUtil.cast(artifact).getStateMgr();
    }

    private static AbstractWorkflowArtifact cast(Artifact artifact) {
        AbstractWorkflowArtifact art = null;
        if (artifact instanceof AbstractWorkflowArtifact) {
            art = (AbstractWorkflowArtifact)artifact;
        }
        return art;
    }
}

