/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.AXml;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.transaction.SkynetTransaction;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;

public class ConvertWorkflowStatesOperation
extends AbstractOperation {
    private final Collection<? extends AbstractWorkflowArtifact> workflows;
    private final Map<String, String> fromStateToStateMap;
    private final XResultData rd;
    private final boolean persist;
    private final Pattern pattern = Pattern.compile("^[0-9A-Za-z-_ ]+$");

    public ConvertWorkflowStatesOperation(Map<String, String> fromStateToStateMap, Collection<? extends AbstractWorkflowArtifact> workflows, boolean persist, XResultData rd) {
        super("Convert ATS Workflow States", "org.eclipse.osee.ats.ide");
        this.fromStateToStateMap = fromStateToStateMap;
        this.workflows = workflows;
        this.persist = persist;
        this.rd = rd;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        SkynetTransaction transaction = null;
        if (this.persist) {
            transaction = TransactionManager.createTransaction((BranchId)AtsApiService.get().getAtsBranch(), (String)this.getName());
        }
        if (this.fromStateToStateMap.isEmpty()) {
            this.rd.error("Must enter FromToState pairs");
        } else {
            if (!this.stateNamesAreValid(this.fromStateToStateMap, this.rd)) {
                return;
            }
            if (this.workflows.isEmpty()) {
                this.rd.error("No workflows entered");
            } else {
                try {
                    for (AbstractWorkflowArtifact abstractWorkflowArtifact : this.workflows) {
                        this.convertCurrentState(abstractWorkflowArtifact);
                        this.convertStates(abstractWorkflowArtifact);
                        this.convertCompletedFromState(abstractWorkflowArtifact);
                        this.convertCancelledFromState(abstractWorkflowArtifact);
                        this.convertLogStates(abstractWorkflowArtifact);
                        if (!this.persist) continue;
                        abstractWorkflowArtifact.persist(transaction);
                    }
                }
                catch (OseeCoreException oseeCoreException) {
                    this.rd.error(String.valueOf(oseeCoreException.getLocalizedMessage()) + " (see error log)");
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)oseeCoreException);
                }
            }
        }
        if (transaction != null && this.persist) {
            transaction.execute();
        }
    }

    private boolean stateNamesAreValid(Map<String, String> fromStateToStateMap, XResultData rd) {
        boolean valid = true;
        for (Map.Entry<String, String> fromStateNameToStateName : fromStateToStateMap.entrySet()) {
            String toStateName;
            String fromStateName = fromStateNameToStateName.getKey();
            if (!this.stateNameIsValid(fromStateName, rd)) {
                valid = false;
            }
            if (this.stateNameIsValid(toStateName = fromStateNameToStateName.getValue(), rd)) continue;
            valid = false;
        }
        return valid;
    }

    private boolean stateNameIsValid(String stateName, XResultData rd) {
        Matcher m = this.pattern.matcher(stateName);
        if (!m.find()) {
            rd.errorf("State name must be alpha-numeric with dashes, spaces or underscores.  Invalid for [%s]", new Object[]{stateName});
            return false;
        }
        return true;
    }

    private void convertLogStates(AbstractWorkflowArtifact awa) {
        String logStr;
        String resultLogStr = logStr = (String)awa.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Log, "");
        for (Map.Entry<String, String> fromToState : this.fromStateToStateMap.entrySet()) {
            String fromStr = fromToState.getKey();
            String toStr = fromToState.getValue();
            resultLogStr = resultLogStr.replaceAll("state=\"" + fromStr + "\"", "state=\"" + toStr + "\"");
        }
        if (!logStr.equals(resultLogStr)) {
            awa.setSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Log, resultLogStr);
            this.rd.logf("Converted <can't display>\n", new Object[]{AXml.xmlToText((String)logStr), AXml.xmlToText((String)resultLogStr)});
        }
    }

    private void convertStateAttributes(AbstractWorkflowArtifact awa, AttributeTypeToken attrType) {
        for (Attribute attribute : awa.getAttributes((AttributeTypeId)attrType)) {
            for (Map.Entry<String, String> fromToState : this.fromStateToStateMap.entrySet()) {
                if (!((String)attribute.getValue()).startsWith(String.valueOf(fromToState.getKey()) + ";")) continue;
                String fromStr = (String)attribute.getValue();
                String toStr = fromStr.replaceFirst(String.valueOf(fromToState.getKey()) + ";", String.valueOf(fromToState.getValue()) + ";");
                attribute.setValue((Object)toStr);
                this.rd.logf("Convert [%s] \n   [%s] to \n   [%s]\n", new Object[]{attrType.getName(), fromStr, toStr});
            }
        }
    }

    private void convertCurrentState(AbstractWorkflowArtifact awa) {
        this.convertStateAttributes(awa, (AttributeTypeToken)AtsAttributeTypes.CurrentState);
    }

    private void convertStates(AbstractWorkflowArtifact awa) {
        this.convertStateAttributes(awa, (AttributeTypeToken)AtsAttributeTypes.State);
    }

    private void convertCompletedFromState(AbstractWorkflowArtifact awa) {
        this.convertExactMatchAttributeValue(awa, (AttributeTypeToken)AtsAttributeTypes.CompletedFromState);
    }

    private void convertCancelledFromState(AbstractWorkflowArtifact awa) {
        this.convertExactMatchAttributeValue(awa, (AttributeTypeToken)AtsAttributeTypes.CancelledFromState);
    }

    private void convertExactMatchAttributeValue(AbstractWorkflowArtifact awa, AttributeTypeToken attrType) {
        List attributes = awa.getAttributes((AttributeTypeId)attrType);
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                for (Map.Entry<String, String> fromToState : this.fromStateToStateMap.entrySet()) {
                    if (!attribute.getValue().equals(fromToState.getKey())) continue;
                    String fromStr = (String)attribute.getValue();
                    String toStr = fromToState.getValue();
                    attribute.setValue((Object)toStr);
                    this.rd.logf("Convert [%s] \n   [%s] to \n   [%s]\n", new Object[]{attrType.getName(), fromStr, toStr});
                }
            }
        }
    }
}

