/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.notify;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class EmailActionsData {
    private String subject;
    private String body;
    private final Set<Artifact> workflows = new HashSet<Artifact>(5);
    private EmailRecipient emailRecipient = null;
    private boolean includeCancelHyperlink = false;

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Result isValid() {
        if (!Strings.isValid((String)this.getSubject())) {
            return new Result("Must enter subject");
        }
        if (!Strings.isValid((String)this.getBody())) {
            return new Result("Must enter body");
        }
        if (this.getEmailRecipient() == null) {
            return new Result("Must select Email Recipient");
        }
        if (this.workflows.isEmpty()) {
            return new Result("No workflows dropped");
        }
        for (Artifact workflow : this.workflows) {
            if (workflow instanceof AbstractWorkflowArtifact) continue;
            return new Result("Only valid for Workflow Artifacts, not [%s]", new Object[]{workflow.getArtifactTypeName()});
        }
        return Result.TrueResult;
    }

    public Set<Artifact> getWorkflows() {
        return this.workflows;
    }

    public EmailRecipient getEmailRecipient() {
        return this.emailRecipient;
    }

    public void setEmailRecipient(EmailRecipient emailRecipient) {
        this.emailRecipient = emailRecipient;
    }

    public boolean isIncludeCancelHyperlink() {
        return this.includeCancelHyperlink;
    }

    public void setIncludeCancelHyperlink(boolean includeCancelHyperlink) {
        this.includeCancelHyperlink = includeCancelHyperlink;
    }

    public static enum EmailRecipient {
        Originator,
        Assignees;

    }
}

