/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.internal;

import java.util.Collection;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.world.WorldEditor;
import org.eclipse.osee.ats.ide.world.WorldEditorSimpleProvider;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.cm.IOseeCmService;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;

public class AtsOseeCmService
implements IOseeCmService {
    public void openArtifact(ArtifactId artifact, OseeCmEditor oseeCmEditor) {
        AtsEditors.openATSArtifact(AtsApiService.get().getQueryService().getArtifact(artifact));
    }

    public void openArtifacts(String name, Collection<Artifact> artifacts, OseeCmEditor oseeCmEditor) {
        WorldEditor.open(new WorldEditorSimpleProvider(name, artifacts));
    }

    public boolean isPcrArtifact(Artifact artifact) {
        return AtsObjects.isAtsWorkItemOrAction((Object)artifact);
    }

    public boolean isBranchesAllCommittedExcept(Artifact art, BranchId branch) {
        boolean toReturn = false;
        if (art instanceof TeamWorkFlowArtifact) {
            try {
                toReturn = AtsApiService.get().getBranchService().isBranchesAllCommittedExcept((IAtsTeamWorkflow)((TeamWorkFlowArtifact)art), branch);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex.toString(), (Throwable)ex);
                toReturn = false;
            }
        }
        return toReturn;
    }

    public boolean isWorkFlowBranch(BranchId branch) {
        boolean toReturn = false;
        try {
            Artifact art = BranchManager.getAssociatedArtifact((BranchId)branch);
            if (art instanceof TeamWorkFlowArtifact) {
                toReturn = true;
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)ex.toString(), (Throwable)ex);
            toReturn = false;
        }
        return toReturn;
    }

    public XResultData commitBranch(Artifact art, BranchToken branch, boolean isArchiveSource, XResultData rd) {
        if (art instanceof TeamWorkFlowArtifact) {
            AtsApiService.get().getBranchServiceIde().commitWorkingBranch((TeamWorkFlowArtifact)art, false, false, (BranchId)branch, isArchiveSource, rd);
        }
        return rd;
    }
}

