/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.copy;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.api.ai.ActionableItem;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.ide.config.copy.ConfigData;
import org.eclipse.osee.ats.ide.config.copy.CopyAtsUtil;
import org.eclipse.osee.ats.ide.config.copy.CopyAtsValidation;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeGeneric;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;

public class CopyAtsConfigurationOperation
extends AbstractOperation {
    private final ConfigData data;
    protected XResultData resultData;
    Set<Artifact> newArtifacts;
    Set<Artifact> existingArtifacts;
    Set<Artifact> processedFromAis;
    private final Map<IAtsTeamDefinition, IAtsTeamDefinition> fromTeamDefToNewTeamDefMap = new HashMap<IAtsTeamDefinition, IAtsTeamDefinition>();
    private final Map<Artifact, IAtsActionableItem> newAiArtToNewAi = new HashMap<Artifact, IAtsActionableItem>();

    public CopyAtsConfigurationOperation(ConfigData data, XResultData resultData) {
        super("Copy ATS Configuration", "org.eclipse.osee.ats.ide");
        this.data = data;
        this.resultData = resultData;
    }

    protected CopyAtsValidation getCopyAtsValidation() {
        return new CopyAtsValidation(this.data, this.resultData);
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        try {
            this.data.validateData(this.resultData);
            if (this.resultData.isErrors()) {
                return;
            }
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(this.getName());
            this.getCopyAtsValidation().validate();
            if (this.resultData.isErrors()) {
                this.persistOrUndoChanges(changes);
                return;
            }
            if (this.data.isPersistChanges()) {
                this.resultData.log("Persisting Changes ");
            } else {
                this.resultData.log("Report-Only, Changes are not persisted");
            }
            this.newArtifacts = new HashSet<Artifact>(50);
            this.existingArtifacts = new HashSet<Artifact>(50);
            this.processedFromAis = new HashSet<Artifact>(10);
            this.createTeamDefinitions(changes, this.data.getTeamDef(), this.data.getParentTeamDef());
            if (this.resultData.isErrors()) {
                this.persistOrUndoChanges(changes);
                return;
            }
            this.createActionableItems(changes, this.data.getActionableItem(), this.data.getParentActionableItem());
            if (this.resultData.isErrors()) {
                this.persistOrUndoChanges(changes);
                return;
            }
            if (AtsApiService.get().isSingleServerDeployment()) {
                AtsApiService.get().reloadServerAndClientCaches();
            }
            this.persistOrUndoChanges(changes);
            XResultDataUI.report((XResultData)this.resultData, (String)this.getName());
        }
        finally {
            monitor.subTask("Done");
        }
    }

    protected IAtsActionableItem createActionableItems(IAtsChangeSet changes, IAtsActionableItem fromAi, IAtsActionableItem parentAi) {
        Artifact fromAiArt = AtsApiService.get().getQueryServiceIde().getArtifact(fromAi);
        if (this.processedFromAis.contains(fromAiArt)) {
            this.resultData.log(String.format("Skipping already processed fromAi [%s]", fromAiArt));
            return null;
        }
        this.processedFromAis.add(fromAiArt);
        Artifact parentAiArt = AtsApiService.get().getQueryServiceIde().getArtifact(parentAi);
        Pair<Artifact, IAtsConfigObject> newAiArtResult = this.duplicateTeamDefinitionOrActionableItem(changes, fromAiArt);
        Artifact newAiArt = (Artifact)newAiArtResult.getFirst();
        IAtsActionableItem newAi = (IAtsActionableItem)newAiArtResult.getSecond();
        changes.add((Object)newAiArt);
        changes.relate((Object)parentAiArt, CoreRelationTypes.DefaultHierarchical_Child, (Object)newAi);
        this.existingArtifacts.add(parentAiArt);
        this.newArtifacts.add(newAiArt);
        for (Artifact fromTeamDefArt : fromAiArt.getRelatedArtifacts(AtsRelationTypes.TeamActionableItem_TeamDefinition, Artifact.class)) {
            TeamDefinition fromTeamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)fromTeamDefArt);
            IAtsTeamDefinition newTeamDef = this.fromTeamDefToNewTeamDefMap.get(fromTeamDef);
            if (newTeamDef == null) {
                this.resultData.warningf("No related Team Definition [%s] in scope for AI [%s].  Configure by hand.", new Object[]{fromTeamDefArt, newAiArt});
                continue;
            }
            Artifact newTeamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(newTeamDef);
            newAiArt.addRelation(AtsRelationTypes.TeamActionableItem_TeamDefinition, newTeamDefArt);
            changes.add((Object)newTeamDefArt);
        }
        for (Artifact childFromAiArt : fromAiArt.getChildren()) {
            if (!childFromAiArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) continue;
            ActionableItem childAi = AtsApiService.get().getActionableItemService().getActionableItemById((ArtifactId)childFromAiArt);
            IAtsActionableItem newChildAi = this.newAiArtToNewAi.get(newAiArt);
            this.createActionableItems(changes, (IAtsActionableItem)childAi, newChildAi);
        }
        return newAi;
    }

    protected IAtsTeamDefinition createTeamDefinitions(IAtsChangeSet changes, IAtsTeamDefinition fromTeamDef, IAtsTeamDefinition parentTeamDef) {
        Artifact parentTeamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(parentTeamDef);
        Artifact fromTeamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(fromTeamDef);
        Pair<Artifact, IAtsConfigObject> teamDefResult = this.duplicateTeamDefinitionOrActionableItem(changes, fromTeamDefArt);
        Artifact newTeamDefArt = (Artifact)teamDefResult.getFirst();
        IAtsTeamDefinition newTeamDef = (IAtsTeamDefinition)teamDefResult.getSecond();
        changes.add((Object)newTeamDefArt);
        parentTeamDefArt.addChild(newTeamDefArt);
        changes.add((Object)parentTeamDefArt);
        this.existingArtifacts.add(parentTeamDefArt);
        this.newArtifacts.add(newTeamDefArt);
        this.fromTeamDefToNewTeamDefMap.put(fromTeamDef, newTeamDef);
        if (this.data.isRetainTeamLeads()) {
            this.duplicateTeamLeadsAndMembers(changes, fromTeamDef, newTeamDef);
        }
        for (Artifact childFromTeamDefArt : fromTeamDefArt.getChildren()) {
            if (!childFromTeamDefArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) continue;
            TeamDefinition childFromTeamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)childFromTeamDefArt);
            AtsApiService.get().getTeamDefinitionService().getTeamDefinitionById((ArtifactId)childFromTeamDefArt);
            this.createTeamDefinitions(changes, (IAtsTeamDefinition)childFromTeamDef, newTeamDef);
        }
        return newTeamDef;
    }

    private void duplicateTeamLeadsAndMembers(IAtsChangeSet changes, IAtsTeamDefinition fromTeamDef, IAtsTeamDefinition newTeamDef) {
        Artifact fromTeamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(fromTeamDef);
        Artifact newTeamDefArt = AtsApiService.get().getQueryServiceIde().getArtifact(newTeamDef);
        List leads = newTeamDefArt.getRelatedArtifacts(AtsRelationTypes.TeamLead_Lead);
        for (Artifact user : fromTeamDefArt.getRelatedArtifacts(AtsRelationTypes.TeamLead_Lead)) {
            if (leads.contains(user)) continue;
            this.existingArtifacts.add(user);
            changes.add((Object)user);
            newTeamDefArt.addRelation(AtsRelationTypes.TeamLead_Lead, user);
            this.resultData.log("   - Relating team lead " + user);
        }
        List members = newTeamDefArt.getRelatedArtifacts(AtsRelationTypes.TeamMember_Member);
        for (Artifact user : fromTeamDefArt.getRelatedArtifacts(AtsRelationTypes.TeamMember_Member)) {
            if (members.contains(user)) continue;
            this.existingArtifacts.add(user);
            changes.add((Object)user);
            newTeamDefArt.addRelation(AtsRelationTypes.TeamMember_Member, user);
            this.resultData.log("   - Relating team member " + user);
        }
    }

    private void persistOrUndoChanges(IAtsChangeSet changes) {
        if (this.data.isPersistChanges()) {
            changes.execute();
            AtsApiService.get().reloadServerAndClientCaches();
            AtsApiService.get().clearCaches();
        } else {
            this.resultData.log("\n\nCleanup of created / modified artifacts\n\n");
            for (Artifact artifact : this.newArtifacts) {
                if (artifact.isInDb()) {
                    this.resultData.errorf("Attempt to purge artifact in db [%s]", new Object[]{artifact});
                    continue;
                }
                this.resultData.log("purging " + artifact.toStringWithId());
                artifact.purgeFromBranch();
            }
            for (Artifact artifact : this.existingArtifacts) {
                if (artifact.isInDb()) {
                    this.resultData.log("undoing changes " + artifact.toStringWithId());
                    artifact.reloadAttributesAndRelations();
                    continue;
                }
                this.resultData.errorf("Attempt to reload artifact not in db [%s]", new Object[]{artifact});
            }
        }
    }

    private Pair<Artifact, IAtsConfigObject> duplicateTeamDefinitionOrActionableItem(IAtsChangeSet changes, Artifact fromArt) {
        String newFullName;
        String newName = CopyAtsUtil.getConvertedName(this.data, fromArt.getName());
        if (newName.equals(fromArt.getName())) {
            throw new OseeArgumentException("Could not get new name from name conversion.", new Object[0]);
        }
        Artifact newArt = fromArt.duplicate(AtsApiService.get().getAtsBranch(), Arrays.asList(AtsAttributeTypes.BaselineBranchId));
        TeamDefinition newConfigObj = null;
        if (fromArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamDefinition})) {
            newConfigObj = AtsApiService.get().getTeamDefinitionService().createTeamDefinition((ArtifactToken)newArt);
        } else if (fromArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.ActionableItem})) {
            newConfigObj = AtsApiService.get().getActionableItemService().createActionableItem((ArtifactToken)newArt);
            this.newAiArtToNewAi.put(newArt, (IAtsActionableItem)newConfigObj);
        } else {
            throw new OseeArgumentException("Unexpected artifact type %s", new Object[]{fromArt.getArtifactTypeName()});
        }
        newArt.setName(newName);
        changes.add((Object)newArt);
        this.resultData.log("Creating new " + newArt.getArtifactTypeName() + ": " + newArt);
        String fullName = (String)newArt.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.FullName, null);
        if (fullName != null && !(newFullName = CopyAtsUtil.getConvertedName(this.data, fullName)).equals(fullName)) {
            newArt.setSoleAttributeFromString((AttributeTypeId)AtsAttributeTypes.FullName, newFullName);
            this.resultData.log("   - Converted \"ats.Full Name\" to " + newFullName);
        }
        if (this.data.getNewProgramId() != null) {
            changes.setSoleAttributeFromString((ArtifactId)newArt, (AttributeTypeGeneric)AtsAttributeTypes.ProgramId, this.data.getNewProgramId().toString());
        }
        this.newArtifacts.add(newArt);
        return new Pair((Object)newArt, (Object)newConfigObj);
    }
}

