/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.AtsColumnTokens;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.column.AbstractVersionSelector;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumn;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingValueProvider;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.jdk.core.type.Id;

public class TargetedVersionColumnUI
extends AbstractVersionSelector
implements BackgroundLoadingValueProvider,
IXViewerPreComputedColumn {
    public static TargetedVersionColumnUI instance = new TargetedVersionColumnUI();
    public AtomicBoolean loading = new AtomicBoolean(false);
    public AtomicBoolean loaded = new AtomicBoolean(false);
    protected Map<Long, String> idToValueMap = new HashMap<Long, String>();

    public TargetedVersionColumnUI() {
        super(AtsColumnTokens.TargetedVersionColumn);
    }

    public static TargetedVersionColumnUI getInstance() {
        return instance;
    }

    @Override
    public TargetedVersionColumnUI copy() {
        TargetedVersionColumnUI newXCol = new TargetedVersionColumnUI();
        super.copy(this, newXCol);
        return newXCol;
    }

    @Override
    public RelationTypeSide getRelation() {
        return AtsRelationTypes.TeamWorkflowTargetedForVersion_Version;
    }

    @Override
    public String getValue(IAtsWorkItem teamWf, Map<Long, String> idToValueMap) {
        return super.getColumnText(teamWf, null, 0);
    }

    public String getValue(Object obj) {
        return super.getColumnText(obj, null, 0);
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        this.preComputedValueMap = preComputedValueMap;
        this.loaded.set(false);
        this.loading.set(false);
        for (Object obj : objects) {
            this.preComputedValueMap.put(this.getKey(obj), "loading...");
        }
        BackgroundLoadingPreComputedColumn.startLoadingThread(this.getName(), objects, this.loading, this.loaded, (WorldXViewer)this.getXViewer(), preComputedValueMap, this);
    }

    @Override
    public String getColumnText(Object obj, XViewerColumn column, int columnIndex) {
        return BackgroundLoadingPreComputedColumn.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap);
    }

    public String getText(Object obj, Long key, String cachedValue) {
        return BackgroundLoadingPreComputedColumn.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap);
    }

    public Long getKey(Object obj) {
        if (obj instanceof Id) {
            return ((Id)obj).getId();
        }
        return Id.SENTINEL;
    }
}

