/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.api.workflow.WorkItemType;
import org.eclipse.osee.ats.core.column.BacklogColumn;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingPreComputedColumn;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalCheckTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.transaction.TransactionManager;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class BaseGoalsColumn
extends BackgroundLoadingPreComputedColumn
implements IAltLeftClickProvider,
IMultiColumnEditProvider {
    private final WorkItemType goalType = WorkItemType.Goal;
    private final String persistString = "Set Goals";
    private final boolean isBacklogGoal = false;

    public BaseGoalsColumn(String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    @Override
    public String getValue(IAtsWorkItem workItem, Map<Long, String> idToValueMap) {
        String result = "";
        try {
            result = BacklogColumn.getColumnText((Object)workItem, (AtsApi)AtsApiService.get(), (boolean)this.isBacklogGoal());
        }
        catch (OseeCoreException ex) {
            result = LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return result;
    }

    protected WorkItemType getWorkItemType() {
        return this.goalType;
    }

    protected String getPersistString() {
        return "Set Goals";
    }

    protected boolean isBacklogGoal() {
        return false;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        block7: {
            Artifact useArt;
            block9: {
                block8: {
                    if (!(treeItem.getData() instanceof Artifact)) break block7;
                    useArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                    if (!useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) break block8;
                    if (AtsApiService.get().getWorkItemService().getTeams((Object)useArt).size() == 1) {
                        useArt = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam((Object)useArt).getStoreObject();
                        break block8;
                    }
                    return false;
                }
                if (useArt.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.AbstractWorkflowArtifact})) break block9;
                return false;
            }
            try {
                boolean modified = this.promptChangeGoals(Arrays.asList(useArt), this.isPersistViewer());
                XViewer xViewer = (XViewer)((XViewerColumn)treeColumn.getData()).getXViewer();
                if (modified && this.isPersistViewer(xViewer)) {
                    useArt.persist("persist goals via alt-left-click");
                }
                if (modified) {
                    xViewer.update((Object)useArt, null);
                    return true;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
        return false;
    }

    public boolean promptChangeGoals(Collection<? extends Artifact> awas, boolean persist) {
        HashSet selected = new HashSet();
        for (Artifact artifact : awas) {
            selected.addAll(artifact.getRelatedArtifacts(AtsRelationTypes.Goal_Goal));
        }
        List list = Collections.castAll((Collection)AtsApiService.get().getQueryService().createQuery(this.getWorkItemType(), new WorkItemType[0]).getResultArtifacts().getList());
        ArrayList<IAtsGoal> allInWork = new ArrayList<IAtsGoal>();
        for (Artifact art : list) {
            IAtsGoal goal = AtsApiService.get().getWorkItemService().getGoal((ArtifactToken)art);
            if (goal == null || !goal.isInWork()) continue;
            allInWork.add(goal);
        }
        GoalCheckTreeDialog dialog = new GoalCheckTreeDialog(list);
        dialog.setInitialSelections(selected);
        if (dialog.open() == 0) {
            for (Artifact artifact : awas) {
                artifact.setRelations(AtsRelationTypes.Goal_Goal, dialog.getChecked());
            }
            TransactionManager.persistInTransaction((String)this.getPersistString(), awas);
            return true;
        }
        return false;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            for (TreeItem item : treeItems) {
                Artifact art;
                if (!(item.getData() instanceof Artifact) || !((art = AtsApiService.get().getQueryServiceIde().getArtifact(item)) instanceof AbstractWorkflowArtifact)) continue;
                awas.add((AbstractWorkflowArtifact)art);
            }
            this.promptChangeGoals(awas, true);
            return;
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return;
        }
    }
}

