/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.nebula.widgets.xviewer.IXViewerPreComputedColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.ide.column.BackgroundLoadingValueProvider;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.osee.framework.ui.swt.Displays;

public abstract class BackgroundLoadingPreComputedColumn
extends XViewerAtsColumn
implements IXViewerPreComputedColumn,
BackgroundLoadingValueProvider {
    public AtomicBoolean loading = new AtomicBoolean(false);
    public AtomicBoolean loaded = new AtomicBoolean(false);
    protected Map<Long, String> preComputedValueMap;

    public BackgroundLoadingPreComputedColumn(String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
    }

    private void startLoadingThread(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        BackgroundLoadingPreComputedColumn.startLoadingThread(this.getName(), objects, this.loading, this.loaded, (WorldXViewer)this.getXViewer(), preComputedValueMap, this);
    }

    public static void startLoadingThread(String name, final Collection<?> objects, final AtomicBoolean loading, final AtomicBoolean loaded, final WorldXViewer xViewer, final Map<Long, String> preComputedValueMap, final BackgroundLoadingValueProvider valueProvider) {
        if (loading.get() || loaded.get()) {
            return;
        }
        Thread loadingThread = new Thread("Loading " + name){

            @Override
            public void run() {
                if (loading.getAndSet(true)) {
                    return;
                }
                valueProvider.handlePreLoadingTasks(objects);
                valueProvider.getValues(objects, preComputedValueMap);
                for (Object element : objects) {
                    Long key = valueProvider.getObjKey(element);
                    try {
                        IAtsWorkItem workItem;
                        String value;
                        if (!(element instanceof IAtsWorkItem) || (value = valueProvider.getValue(workItem = (IAtsWorkItem)element, preComputedValueMap)) == null) continue;
                        preComputedValueMap.put(key, value);
                    }
                    catch (OseeCoreException ex) {
                        String cellExceptionString = LogUtil.getCellExceptionString((Exception)((Object)ex));
                        preComputedValueMap.put(key, cellExceptionString);
                    }
                }
                loaded.set(true);
                loading.set(false);
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (xViewer != null) {
                            xViewer.refreshColumn(valueProvider.getId());
                        }
                    }
                });
            }
        };
        loadingThread.start();
    }

    public Long getKey(Object obj) {
        if (obj instanceof Id) {
            return ((Id)obj).getId();
        }
        return Id.SENTINEL;
    }

    public String getColumnText(Object obj, XViewerColumn column, int columnIndex) {
        return BackgroundLoadingPreComputedColumn.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap);
    }

    public String getText(Object obj, Long key, String cachedValue) {
        return BackgroundLoadingPreComputedColumn.getColumnText(obj, this.loading, this.loaded, this.preComputedValueMap);
    }

    public static String getColumnText(Object obj, AtomicBoolean loading, AtomicBoolean loaded, Map<Long, String> idToValueMap) {
        try {
            if (obj instanceof IAtsWorkItem) {
                IAtsWorkItem workItem = (IAtsWorkItem)obj;
                String value = idToValueMap.get(workItem.getId());
                if (value != null) {
                    return value;
                }
                return "unknown";
            }
        }
        catch (OseeCoreException ex) {
            LogUtil.getCellExceptionString((Exception)((Object)ex));
        }
        return "";
    }

    public void populateCachedValues(Collection<?> objects, Map<Long, String> preComputedValueMap) {
        this.preComputedValueMap = preComputedValueMap;
        this.loaded.set(false);
        this.loading.set(false);
        for (Object obj : objects) {
            this.preComputedValueMap.put(this.getKey(obj), "loading...");
        }
        this.startLoadingThread(objects, preComputedValueMap);
    }
}

