/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.importer;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.ui.skynet.widgets.XBranchSelectWidget;
import org.eclipse.osee.ote.ui.define.importer.ImportOutfileUIOperation;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class OutfileImportPage
extends WizardDataTransferPage {
    private static final String PAGE_NAME = "Outfile Import";
    private CheckboxTreeViewer treeViewer;
    private final IStructuredSelection startingResourceSelection;
    private final boolean treeSelectionMode;
    private final ITreeContentProvider contentProvider;
    private final ILabelProvider labelProvider;
    private final List<ViewerFilter> filters;
    private final Object treeInput = ResourcesPlugin.getWorkspace().getRoot();
    private XBranchSelectWidget branchSelect;

    protected OutfileImportPage(IStructuredSelection selection) {
        super(PAGE_NAME);
        this.treeSelectionMode = true;
        this.contentProvider = new WorkbenchContentProvider();
        this.labelProvider = new WorkbenchLabelProvider();
        this.filters = new ArrayList<ViewerFilter>();
        this.startingResourceSelection = selection;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public void handleEvent(Event event) {
        this.updateWidgetEnablements();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setText("Select a Branch to import files into");
        group.setToolTipText("Opens the branch selection dialog");
        this.branchSelect = new XBranchSelectWidget("branch");
        this.branchSelect.createWidgets((Composite)group, 2056);
        this.createFileSelectArea(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    private void createFileSelectArea(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText("Select Files");
        group.setToolTipText("Select files to import");
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.treeViewer = this.treeSelectionMode ? new ContainerCheckedTreeViewer(composite, 2048) : new CheckboxTreeViewer(composite, 2048);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                OutfileImportPage.this.setPageComplete(OutfileImportPage.this.determinePageCompletion());
            }
        });
        if (this.filters != null) {
            int i = 0;
            while (i != this.filters.size()) {
                this.treeViewer.addFilter(this.filters.get(i));
                ++i;
            }
        }
        this.treeViewer.setInput(this.treeInput);
        Tree treeWidget = this.treeViewer.getTree();
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(16);
        treeWidget.setLayout((Layout)new GridLayout());
        treeWidget.setLayoutData((Object)data);
        treeWidget.setFont(composite.getFont());
        treeWidget.setEnabled(true);
        this.createSelectionButtons(composite);
    }

    private Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        this.setButtonLayoutData(button);
        return button;
    }

    private Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 131072);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setFont(composite.getFont());
        GridData data = new GridData(4, 4, true, false);
        data.grabExcessHorizontalSpace = true;
        composite.setData((Object)data);
        Button selectButton = this.createButton(buttonComposite, 18, "Select All", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] viewerElements = OutfileImportPage.this.contentProvider.getElements(OutfileImportPage.this.treeInput);
                if (OutfileImportPage.this.treeSelectionMode) {
                    OutfileImportPage.this.treeViewer.setCheckedElements(viewerElements);
                } else {
                    int i = 0;
                    while (i < viewerElements.length) {
                        OutfileImportPage.this.treeViewer.setSubtreeChecked(viewerElements[i], true);
                        ++i;
                    }
                }
                OutfileImportPage.this.updateWidgetEnablements();
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, "Deselect All", false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OutfileImportPage.this.treeViewer.setCheckedElements(new Object[0]);
                OutfileImportPage.this.updateWidgetEnablements();
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
        return buttonComposite;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String lastSelected = settings.get("last.branch.id");
            try {
                this.branchSelect.setSelection(BranchManager.getBranchToken((Long)Long.parseLong(lastSelected)));
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        this.onStartSelectedResource();
    }

    private void onStartSelectedResource() {
        if (this.startingResourceSelection != null && this.startingResourceSelection.size() > 0) {
            Object[] objectArray = this.startingResourceSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer parentResource;
                IResource currentResource;
                Object resource;
                Object firstElement = objectArray[n2];
                if (firstElement instanceof IAdaptable && (resource = ((IAdaptable)firstElement).getAdapter(IResource.class)) != null && (currentResource = (IResource)resource).getType() == 1 && (parentResource = currentResource.getParent()) != null && parentResource.isAccessible()) {
                    this.treeViewer.expandToLevel((Object)parentResource, 1);
                    this.treeViewer.setChecked((Object)currentResource, true);
                }
                ++n2;
            }
        }
    }

    protected boolean validateSourceGroup() {
        boolean toReturn = super.validateSourceGroup();
        URI[] selectedResources = this.getSelectedResources();
        if (selectedResources.length == 0) {
            this.setMessage(null);
            this.setErrorMessage("There are no resources currently selected for import.");
            toReturn &= false;
        }
        return toReturn;
    }

    protected boolean validateDestinationGroup() {
        boolean toReturn = super.validateDestinationGroup();
        BranchToken branch = this.branchSelect.getData();
        if (branch == null) {
            this.setMessage(null);
            this.setErrorMessage("Please select a working branch. Cannot import into a null branch.");
            toReturn &= false;
        } else {
            try {
                if (BranchManager.isParentSystemRoot((BranchId)branch)) {
                    this.setMessage(null);
                    this.setErrorMessage("Please select a working branch. Cannot import into a top-level branch.");
                    toReturn &= false;
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return toReturn;
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] branchUuids = settings.getArray("all.branches.id");
            if (branchUuids == null) {
                branchUuids = new String[]{};
            }
            BranchToken branch = this.branchSelect.getData();
            try {
                if (branch != null) {
                    String lastBranchSelected = branch.getIdString();
                    branchUuids = this.addToHistory(branchUuids, lastBranchSelected);
                    settings.put("all.branches.id", branchUuids);
                    settings.put("last.branch.id", lastBranchSelected);
                    try {
                        settings.save(((Object)((Object)this)).getClass().getName());
                    }
                    catch (IOException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
    }

    private URI[] getSelectedResources() {
        Object[] selected = this.treeViewer.getCheckedElements();
        ArrayList<URI> selectedResources = new ArrayList<URI>();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IFile) {
                IFile iFile = (IFile)object;
                selectedResources.add(iFile.getLocationURI());
            }
            ++n2;
        }
        return selectedResources.toArray(new URI[selectedResources.size()]);
    }

    public boolean finish() {
        this.saveWidgetValues();
        return new ImportOutfileUIOperation(this.branchSelect.getData(), this.getSelectedResources()).execute();
    }
}

